<?php

namespace App\Http\Controllers\DataIndukPendaftaran;

use App\Http\Controllers\Controller;
use App\Services\DataIndukPendaftaranService;
use Illuminate\Http\Request;
use PDF;
use RealRashid\SweetAlert\Facades\Alert;

class KelurahanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return view('data_induk_pendaftaran.kelurahan', [
            'role' => 'kelurahan',
            'data' => $dataIndukPendaftaranService->getDataKelurahan()->paginate(10),
            'provinsi' => $dataIndukPendaftaranService->getData('smis_rg_propinsi')->get(),
            'keyword' => ''
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $store = $dataIndukPendaftaranService->createKelurahan($request);
        if ($store == 'sukses') {
            Alert::success('Berhasil', 'Kelurahan berhasil ditambahkan');
        } else {
            Alert::error('Gagal', $store);
        }
        return redirect()->route('kelurahan.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return response()->json($dataIndukPendaftaranService->getDataKelurahanById($id));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        //dd($request->all());
        $update = $dataIndukPendaftaranService->updateKelurahan($request);
        if ($update == 'sukses') {
            Alert::success('Berhasil', 'Kelurahan berhasil diperbarui');
        } else {
            Alert::error('Gagal', $update);
        }
        return redirect()->route('kelurahan.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $delete = $dataIndukPendaftaranService->deleteData($id, 'smis_rg_kelurahan');
        if ($delete == 'sukses') {
            Alert::success('Berhasil', 'Kelurahan berhasil dihapus');
        } else {
            Alert::error('Gagal', $delete);
        }
        return redirect()->route('kelurahan.index');
    }

    public function search(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return view('data_induk_pendaftaran.kelurahan', [
            'role' => 'kelurahan',
            'data' => $dataIndukPendaftaranService->getSearchKelurahan($request)->paginate(10),
            'provinsi' => $dataIndukPendaftaranService->getData('smis_rg_propinsi')->get(),
            'keyword' => $request->keyword
        ]);
    }

    public function download(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
        $pdf = PDF::loadView('data_induk_pendaftaran.pdf_kelurahan', [
            'data' => $dataIndukPendaftaranService->getSearchKelurahan($request)->get()
        ])->setPaper('a4', 'portrait');
        return $pdf->download('Kelurahan.pdf');
    }

    public function getKecamatan($id, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return response()->json($dataIndukPendaftaranService->getKecamatanByKabupaten($id));
    }
}
