<?php

namespace App\Http\Controllers;

use App\Models\Antrian;
use App\Models\JadwalPoli;
use App\Models\SMIS_Pasien;
use Illuminate\Http\Request;
use GuzzleHttp\Client;
use App\Models\RsCredential;
use App\Models\SMIS_Ksr_Kolektif;
use App\Models\SMIS_LayananPasien;
use App\Models\SMIS_Rg_Asuransi;
use App\Models\SMIS_Rwt_Antrian;
use App\Models\SmisAdmPrototype;
use App\Models\SMIS_Mjm_Tarif_Pendaftaran;
use App\Models\SmisAdmSettings;
use App\Services\AntrianPendaftaranService;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use stdClass;

class CheckinController extends Controller
{
    function index()
    {
        return view('checkin.index');
    }

    function antrian_by_kode_booking(Request $req)
    {
        $data = Antrian::join('smis_rg_patient', 'smis_rg_patient.id', 'antrians.norm')
            ->select('antrians.*', 'smis_rg_patient.nama as pasien', 'smis_rg_patient.tgl_lahir')
            ->where('kodebooking', $req->kode_booking)->first();
        return response()->json($data);
    }

    function antrian_by_nrm(Request $req)
    {
        $data = Antrian::join('smis_rg_patient', 'smis_rg_patient.nrm', 'antrians.norm')
            ->select('antrians.*', 'smis_rg_patient.nama as pasien', 'smis_rg_patient.tgl_lahir')
            ->where('nrm', $req->nrm)->where('tanggalperiksa', date('Y-m-d'))->where(function($q){
                $q->where('taskid', '!=', 99)->orWhere('taskid', 0);
            })->first();
        return response()->json($data);
    }

    function checkin(Request $req, AntrianPendaftaranService $aps){
        try {
            $checkin = $aps->checkin($req);
            if ($checkin['status']) {
                return response()->json([
                    'status' => true,
                    'message' => $checkin['message']
                ]);
            }else{
                return response()->json([
                    'status' => false,
                    'message' => $checkin['message']
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }
}
