<?php

namespace App\Http\Controllers;

use App\Events\AntrianEvent;
use App\Models\Antrian;
use App\Models\AntrianPendaftaran;
use App\Models\Mjkn_Patient;
use App\Models\Propinsi;
use App\Services\AntrianManualService;
use App\Services\AntrianPendaftaranService;
use Auth;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AntrianPendaftaranController extends Controller
{
    function __construct()
    {
        $this->middleware(function ($request, $next) {
            $menu = json_decode(Auth::user()->menu);
            if (property_exists($menu, 'antrian')) {
                $arr = (array) $menu->antrian;
                if ($arr['pendaftaran'] == 0) {
                    return redirect('home');
                }
            } else {
                return redirect('home');
            }
            return $next($request);
        });
    }

    function index()
    {
        $data['propinsi'] = Propinsi::where('prop', '')->get();
        return view('antrian.pendaftaran', $data);
    }

    function datatable_antrian_online()
    {
        $query = Antrian::leftJoin('smis_rg_patient', 'smis_rg_patient.nrm', 'antrians.norm')
            ->select('antrians.*', 'smis_rg_patient.nama as pasien', 'smis_rg_patient.tgl_lahir', 'smis_rg_patient.ktp', 'smis_rg_patient.nobpjs as nomor_bpjs')
            ->where('tanggalperiksa', date('Y-m-d'))
            // ->where('smis_rg_patient.prop', '')
            ->where('taskid', '!=', 99)
            // ->where('unit_kerja', env('NAMA_KLINIK'))
            ->orderBy('waktu_checkin');
        return DataTables::of($query)->addIndexColumn()->make(true);
    }

    function datatable_pasien_baru()
    {
        $query = Mjkn_Patient::where('origin_updated', 'mobile-jkn')->where('unit_kerja', env('NAMA_KLINIK'));
        return DataTables::of($query)->addIndexColumn()->make(true);
    }

    function batal_antrian(Request $req)
    {
        try {
            Antrian::findOrFail($req->id);
            Antrian::where('id', $req->id)->update(['taskid' => 99, 'keterangan' => $req->keterangan]);
            return response()->json([
                'status' => true,
                'message' => 'Ok'
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function ajax_antrian_manual(AntrianManualService $ams)
    {
        $data = $ams->getLastAntrian();
        return response()->json($data);
    }

    function panggil_antrian(Request $req, AntrianManualService $ams)
    {
        if ($req->pasien_baru == 'false') {
            $data = AntrianPendaftaran::where('tanggal', date('Y-m-d'))->where('unit_kerja', env('NAMA_KLINIK'))->first();
            if (is_null($data)) {
                return response()->json([
                    'status' => false,
                    'message' => 'Antrian tidak ditemukan'
                ]);
            }
        }

        if ($req->manual == 'true') {
            if ($req->tipe == 'next') {
                if ($data->last_call == $data->last_queue) {
                    return response()->json([
                        'status' => false,
                        'message' => 'Sudah antrian terakhir'
                    ]);
                }
                $ams->next();
            }

            $antrian = AntrianPendaftaran::where('tanggal', date('Y-m-d'))->where('unit_kerja', env('NAMA_KLINIK'))->first();

            event(new AntrianEvent($req->loket, $req->bagian, $req->manual, $antrian, $req->pasien_baru, $req->pasien));
        } else {
            $antrian = Antrian::where('id', $req->id)->first();
            event(new AntrianEvent($req->loket, $req->bagian, $req->manual, $antrian, $req->pasien_baru, $req->pasien));
        }

        return response()->json([
            'status' => true,
            'message' => 'Ok'
        ]);
    }

    function checkin(Request $req, AntrianPendaftaranService $aps)
    {
        $antrian = Antrian::where('id', $req->id)->where('unit_kerja', env('NAMA_KLINIK'))->first();
        if (is_null($antrian)) {
            return response()->json([
                'status' => false,
                'message' => 'Antrian tidak ditemukan'
            ]);
        }

        try {
            $result = $aps->checkin($req);
            return response()->json($result);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function pasien_mjkn_daftar(Request $req, AntrianPendaftaranService $aps)
    {
        try {
            $aps->pasien_mjkn_daftar($req->pasien);
            return response()->json([
                'status' => true,
                'message' => 'Pendaftaran pasien berhasil'
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function hapus_mjkn(Request $req, AntrianPendaftaranService $aps)
    {
        try {
            $aps->hapus_mjkn($req->pasien);
            return response()->json([
                'status' => true,
                'message' => 'Hapus pasien berhasil'
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }
}
