<?php

namespace App\Http\Controllers;

use App\Models\Mjkn_Patient;
use App\Services\AntrianPoliService;
use Illuminate\Http\Request;
use App\Http\Controllers\CheckinController;
use App\Http\Requests\ObservasiPascaOperasiRequest;
use App\Models\Antrian;
use App\Models\AntrianPendaftaran;
use App\Models\SMIS_Rg_Asuransi;
use App\Models\JadwalPoli;
use App\Models\JenisPasien;
use App\Models\SMIS_Rg_Perusahaan;
use App\Models\SMIS_LayananPasien;
use App\Http\Requests\PasienUmumRequest;
use App\Http\Requests\PasienBpjsRequest;
use App\Models\DokumenKunjungan;
use App\Models\SMIS_Diagnosa;
use App\Models\Smis_Lab_Pesanan;
use App\Models\Smis_Mr_Icd;
use App\Services\AntrianPendaftaranService;
use Illuminate\Support\Facades\Validator;
use App\Models\SMIS_Pasien;
use App\Models\SmisHrdEmployee;
use App\Services\ERekamMedisService;
use Yajra\DataTables\Facades\DataTables;
use DB;
use App\Models\Propinsi;
use App\Models\Kabupaten;
use App\Models\Kecamatan;
use App\Models\Kelurahan;
use App\Services\LaboratoriumService;
use App\Services\ResepService;
use App\Services\SmisService;

class AjaxRequestController extends Controller
{
    function perujuk()
    {
        $data = DB::table('smis_rg_perujuk')->select('smis_rg_perujuk.id', 'smis_rg_perujuk.nama');
        return DataTables::of($data)->toJson();
    }

    function perujuk_by_kodedokter(Request $req)
    {
        $data = JadwalPoli::join('smis_rg_perujuk', 'smis_rg_perujuk.nama', 'smis_rg_jadwal_poli.nama_dokter')
            ->select('smis_rg_perujuk.id', 'smis_rg_perujuk.nama')
            ->where('smis_rg_jadwal_poli.kodedokter_bpjs', $req->kodedokter)->first();
        return response()->json($data);
    }

    function data_master_form_pendaftaran(Request $req)
    {
        $data['pasien'] = SMIS_Pasien::where('prop', '')->where(function ($q) use ($req) {
            $q->where('id', $req->nomor)->orWhere('ktp', $req->nomor);
        })->first();
        $data['poli'] = JadwalPoli::select('kodepoli_bpjs', 'nama_poli')->groupBy(['kodepoli_bpjs', 'nama_poli'])->get();
        $data['jenispasien'] = JenisPasien::where('prop', '')->get();
        $data['asuransi'] = SMIS_Rg_Asuransi::where('prop', '')->get();
        $data['perusahaan'] = SMIS_Rg_Perusahaan::where('prop', '')->get();
        $data['layanan'] = SMIS_LayananPasien::where('nrm', $data['pasien']->id)->orderBy('id', 'desc')->first();
        return response()->json($data);
    }

    function tambah_pasien_umum(PasienUmumRequest $req, AntrianPendaftaranService $aps)
    {
        try {
            $hasil = $aps->insert_pasien_anjungan_mandiri($req);
            DB::table('smis_rg_faskes')->where('prefix_id', env('slug_klinik'))->update([
                'last_nrm' => $hasil['nrm']
            ]);
            return response()->json([
                'status' => true,
                'message' => 'No. rekam medis anda ' . $hasil['nrm'] . ' tersebut hanya bersifat sementara. Harap datang ke admisi untuk verifikasi & melengkapi data rekam medis dengan membawa kartu identitas, pastikan data anda benar-benar valid & belum pernah terdaftar di ' . env('NAMA_KLINIK'),
                'code' => 200
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage(),
                'code' => 500
            ]);
        }
    }

    function tambah_pasien_bpjs(PasienBpjsRequest $req, AntrianPendaftaranService $aps)
    {
        try {
            $hasil = $aps->insert_pasien_anjungan_mandiri($req);
            DB::table('smis_rg_faskes')->where('prefix_id', env('slug_klinik'))->update([
                'last_nrm' => $hasil['nrm']
            ]);
            return response()->json([
                'status' => true,
                'message' => 'No. rekam medis anda ' . $hasil['nrm'] . ' tersebut hanya bersifat sementara. Harap datang ke admisi untuk verifikasi & melengkapi data rekam medis dengan membawa kartu identitas, pastikan data anda benar-benar valid & belum pernah terdaftar di ' . env('NAMA_KLINIK'),
                'code' => 200
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage(),
                'code' => 500
            ]);
        }
    }

    function pasien_daftar(Request $req, AntrianPendaftaranService $aps)
    {
        $valid = Validator::make($req->all(), [
            'tanggalperiksa' => "required|date_format:Y-m-d",
            'kodepoli' => 'required',
            'kodedokter' => 'required',
            'jampraktek' => 'required',
            'jenis_kunjungan' => "required"
        ], [
            'tanggalperiksa.required' => 'Pilih tanggal periksa dahulu',
            'tanggalperiksa.date_format' => 'Format tanggal periksa tidak sesuai',
            'kodepoli.required' => 'Pilih poli dahulu',
            'kodedokter.required' => 'Pilih dokter dahulu',
            'jampraktek.required' => 'Pilih jam terlebih dahulu',
            'jenis_kunjungan.required' => 'Jenis kunjungan harus diisi'
        ]);

        try {
            $hasil = $aps->pasien_daftar($req);
            return response()->json($hasil);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage(),
                'code' => 201
            ]);
        }
    }

    function select_mjkn_patient(Request $req)
    {
        $data = Mjkn_Patient::findOrFail($req->pasien);
        return response()->json($data);
    }

    function get_antrian_selesai_poli(Request $req, AntrianPoliService $aps)
    {
        $data = $aps->antrian_selesai();
        return response()->json($data);
    }

    function pasien_mjkn(Request $req)
    {
        $data = Mjkn_Patient::where('origin_updated', 'mobile-jkn')->get();
        return response()->json($data);
    }

    function update_mjkn(Request $req)
    {
        $propinsi = Propinsi::where('id', $req->propinsi)->first();
        $kabupaten = Kabupaten::where('id', $req->kabupaten)->first();
        $kecamatan = Kecamatan::where('id', $req->kecamatan)->first();
        $kelurahan = Kelurahan::where('id', $req->kelurahan)->first();
        try {
            $data = Mjkn_Patient::where('id', $req->id)->update([
                'nama' => $req->nama,
                'nrm' => $req->nrm,
                'nik' => $req->nik,
                'nobpjs' => $req->nobpjs,
                'kelamin' => $req->kelamin,
                'tgl_lahir' => $req->tanggal_lahir,
                'alamat' => $req->alamat,
                'id_propinsi' => $req->propinsi,
                'propinsi' => $propinsi ? $propinsi->nama : "",
                'id_kabupaten' => $req->kabupaten,
                'kabupaten' => $kabupaten ? $kabupaten->nama : "",
                'id_kecamatan' => $req->kecamatan,
                'kecamatan' => $kecamatan ? $kecamatan->nama : "",
                'id_kelurahan' => $req->kelurahan,
                'kelurahan' => $kelurahan ? $kelurahan->nama : "",
                'rt' => $req->rt,
                'rw' => $req->rw
            ]);
            return response()->json([
                'status' => true,
                'message' => 'Ok'
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function ambil_antrian_farmasi(Request $req)
    {
        $waktu = strtotime(now()) . '000';
        $data = Antrian::where('kodebooking', $req->kodebooking)->where('taskid', 4)->first();

        if (!$data) {
            return response()->json([
                'status' => false,
                'message' => 'Data tidak ditemukan (sudah mengambil antrian sebelumnya)'
            ]);
        }
        $obj_bpjs = new CheckinController();
        $hit_bpjs = $obj_bpjs->update_waktu_antrian(5, $data->kodebooking, $waktu);
        if (!$hit_bpjs['status']) {
            return response()->json([
                'status' => false,
                'message' => $hit_bpjs['message']
            ]);
        }

        Antrian::where('id', $data->id)->update([
            'taskid' => 5,
            'waktu_taskid_lima' => $waktu,
            'jenis_obat' => $req->jenis_obat
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Ambil antrian farmasi berhasil'
        ]);
    }

    function antrian_obat(Request $req)
    {
        $query = Antrian::leftJoin('smis_rg_patient', 'smis_rg_patient.id', 'antrians.norm')
            ->select('antrians.*', 'smis_rg_patient.nama as pasien', 'smis_rg_patient.ktp', 'smis_rg_patient.nobpjs', 'antrians.taskid')
            ->where(function ($q) {
                $q->where('taskid', 5)->orWhere('taskid', 6)->orWhere('taskid', 7);
            })->whereDate('tanggalperiksa', date('Y-m-d'));
        if (isset($req->display)) {
            $query->where('antrians.keterangan', 'farmasi');
        }
        if ($req->keyword != '' && $req->keyword != null) {
            $key = $req->keyword;
            $query->where(function ($q) use ($key) {
                $q->where('norm', 'like', '%' . $key . '%')->orWhere('smis_rg_patient.nama', 'like', '%' . $key . '%');
            });
        }
        $data = $query->get();
        return response()->json($data);
    }

    function antrian_manual(Request $req)
    {
        $data = AntrianPendaftaran::where('tanggal', date('Y-m-d'))->first();
        return response()->json($data);
    }

    function pasien_by_nrm(Request $req)
    {
        $data = SMIS_Pasien::with(['kunjungan', 'erm'])
            ->select('nama', 'kelamin', 'alamat', 'tempat_lahir', 'tgl_lahir', 'id')
            ->where('id', $req->nrm)->first();
        return response()->json($data);
    }

    function dokumen_kunjungan_by_noreg(Request $req)
    {
        $data = SMIS_LayananPasien::with('dokumen_kunjungan')->where('id', $req->noreg)->first();
        return response()->json($data);
    }

    function create_dokumen_kunjungan(Request $req, ERekamMedisService $erms)
    {
        if (DokumenKunjungan::where('nama_dokumen', $req->jenis_dokumen)->where('noreg', $req->noreg)->first()) {
            return response()->json([
                'status' => false,
                'message' => 'Dokumen sudah pernah dibuat'
            ]);
        }
        try {
            $data = $erms->create_dokumen_kunjungan($req);
            return response()->json([
                'status' => true,
                'message' => 'Dokumen berhasil dibuat',
                'data' => $data
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function employee(Request $req)
    {
        $query = SmisHrdEmployee::join('smis_hrd_job', 'smis_hrd_job.id', 'smis_hrd_employee.jabatan')
            ->select('smis_hrd_employee.id', 'smis_hrd_employee.nama', 'smis_hrd_job.nama as nama_jabatan');
        if ($req->keyword != '') {
            $query->where('smis_hrd_employee.nama', 'like', '%' . $req->keyword . '%');
        }
        return DataTables::of($query->get())->toJson();
    }

    function observasi_pasca_operasi(Request $req, ERekamMedisService $erms)
    {
        try {
            $data = $erms->observasi_pasaca_operasi_get_by_dokumen($req);
            return response()->json([
                'status' => true,
                'data' => $data
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function delete_observasi_pasca_operasi(Request $req, ERekamMedisService $erms)
    {
        try {
            $data = $erms->observasi_pasaca_operasi_delete($req);
            return response()->json('Observasi berhasil dihapus');
        } catch (\Throwable $th) {
            return response()->json($th->getMessage());
        }
    }

    function select_observasi_pasca_operasi(Request $req, ERekamMedisService $erms)
    {
        $data = $erms->observasi_pasaca_operasi_select($req);
        return response()->json($data);
    }

    function create_observasi_pasca_operasi(ObservasiPascaOperasiRequest $req, ERekamMedisService $erms)
    {
        try {
            $erms->observasi_pasaca_operasi_create($req);
            return response()->json([
                'status' => true,
                'message' => 'Observasi pasca operasi berhasil ditambahkan'
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function update_observasi_pasca_operasi(ObservasiPascaOperasiRequest $req, ERekamMedisService $erms)
    {
        try {
            $erms->observasi_pasaca_operasi_update($req);
            return response()->json([
                'status' => true,
                'message' => 'Observasi pasca operasi berhasil diubah'
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function datatable_dokter()
    {
        $data = SmisHrdEmployee::leftJoin('smis_hrd_job', 'smis_hrd_job.id', 'smis_hrd_employee.jabatan')->where('jabatan', 2)->orWhere('jabatan', 1)->orWhere('jabatan', 22)->select('smis_hrd_employee.nama as nama', 'smis_hrd_employee.id', 'smis_hrd_job.nama as jabatan', 'nomor_sipa')->get();
        return Datatables::of($data)->addIndexColumn()->make(true);
    }

    function datatable_karyawan()
    {
        $data = SmisHrdEmployee::join('smis_hrd_job', 'smis_hrd_job.id', 'smis_hrd_employee.jabatan')
            ->select('smis_hrd_employee.nama as nama', 'smis_hrd_employee.id', 'smis_hrd_job.nama as jabatan', 'nip')->get();
        return DataTables::of($data)->addIndexColumn()->make(true);
    }

    function pesanan_lab_store(Request $req, ERekamMedisService $erms)
    {
        try {
            $id = (new LaboratoriumService)->store($req);
            $data = (new LaboratoriumService)->select($id);
            return response()->json([
                'status' => true,
                'message' => 'Ok',
                'data' => $data
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }

    function pesanan_lab_by_noreg(Request $req)
    {
        $data['pesanan_lab'] = Smis_Lab_Pesanan::where('noreg_pasien', $req->noreg)->where('prop', '')->first();
        $data['diagnosa'] = SMIS_Diagnosa::where('noreg_pasien', $req->noreg)->first();
        return response()->json($data);
    }

    function pesanan_lab_by_id(Request $req)
    {
        $data = Smis_Lab_Pesanan::where('id', $req->id)->where('prop', '')->first();
        return response()->json($data);
    }

    function diagnosa_by_noreg(Request $req)
    {
        $data = SMIS_Diagnosa::leftJoin('smis_hrd_employee', 'smis_hrd_employee.id', 'smis_mr_diagnosa.id_dokter')
            ->where('noreg_pasien', $req->noreg)->select('smis_mr_diagnosa.*', 'smis_hrd_employee.nip')->first();
        return response()->json($data);
    }

    function diagnosa_by_id(Request $req)
    {
        $data = SMIS_Diagnosa::leftJoin('smis_hrd_employee', 'smis_hrd_employee.id', 'smis_mr_diagnosa.id_dokter')->where('smis_mr_diagnosa.id', $req->id)->select('smis_mr_diagnosa.*', 'smis_hrd_employee.nip')->first();
        return response()->json($data);
    }

    function autocomplete_diagnosa(Request $req)
    {
        $hit_service = (new SmisService)->post(env('SMIS_URL_GET_LIST_DIAGNOSA'), [
            [
                'name'     => 'username',
                'contents' => 'abdijaka'
            ],
            [
                'name'     => 'param1',
                'contents' => $req['keyword']
            ],
            [
                'name'     => 'param2',
                'contents' => '0'
            ],
            [
                'name'     => 'param3',
                'contents' => '100'
            ]
        ]);

        $response = json_decode($hit_service->getBody()->getContents());

        return response()->json(is_null($response) || $response->metaData->code == 204 ? [] : $response->response->list);
    }

    function update_diagnosa(Request $req)
    {
        $dokumen = DokumenKunjungan::join('smis_rg_patient', 'smis_rg_patient.id', 'dokumen_kunjungan_pasien.nrm')
            ->select(
                'dokumen_kunjungan_pasien.*',
                'smis_rg_patient.nama_provinsi',
                'smis_rg_patient.nama_kabupaten',
                'smis_rg_patient.nama_kecamatan',
                'smis_rg_patient.nama_kelurahan',
                'smis_rg_patient.alamat',
                'smis_rg_patient.sebutan',
                'smis_rg_patient.profile_number',
                'smis_rg_patient.kelamin',
                'smis_rg_patient.tgl_lahir',
            )
            ->where('dokumen_kunjungan_pasien.id', $req->dokumen)->first();
        try {
            $diagnosa = Smis_Mr_Icd::where('nama', $req->diagnosa)->first();
            $diagnosa_sekunder = Smis_Mr_Icd::where('nama', $req->diagnosa_sekunder_satu)->first();

            $arr_ins = [
                'tanggal' => $req->tanggal,
                'diagnosa' => $req->catatan_diagnosa,
                'id_dokter' => $req->id_dokter,
                'nama_dokter' => $req->dokter,
                'nama_icd' => $diagnosa ? $diagnosa->nama : '',
                'kode_icd' => $diagnosa ? $diagnosa->icd : '',
                'nama_icd_sekunder' => $diagnosa ? $diagnosa_sekunder->nama : '',
                'kode_icd_sekunder' => $diagnosa ? $diagnosa_sekunder->icd : '',
                'sebab_sakit' => $req->penyebab ? $req->penyebab : '',
                'ruangan' => $req->ruangan,
                'nrm_pasien' => $dokumen ? $dokumen->nrm : '',
                'nama_pasien' => $dokumen ? $dokumen->nama_pasien : '',
                'time_updated' => date('Y-m-d H:i:s'),
                'origin' => 'casamedical',
                'duplicate' => 0,
                'autonomous' => '[casamedical]',
                'origin_updated' => 'casamedical',
                'propinsi' => $dokumen ? $dokumen->nama_provinsi : '',
                'kabupaten' => $dokumen ? $dokumen->nama_kabupaten : '',
                'kecamatan' => $dokumen ? $dokumen->nama_kecamatan : '',
                'kelurahan' => $dokumen ? $dokumen->nama_kelurahan : '',
                'jk' => $dokumen ? $dokumen->kelamin : '',
                'tgl_lahir' => $dokumen ? $dokumen->tgl_lahir : '',
                'noreg_pasien' => $req->noreg
            ];

            if ($req->id == 0) {
                $id = DB::table('smis_mr_diagnosa')->insertGetId($arr_ins);
            }else{
                DB::table('smis_mr_diagnosa')->where('id', $req->id)->update($arr_ins);
                $id = $req->id;
            }
            
            $last = SMIS_Diagnosa::leftJoin('smis_hrd_employee', 'smis_hrd_employee.id', 'smis_mr_diagnosa.id_dokter')
            ->where('smis_mr_diagnosa.id', $id)->select('smis_mr_diagnosa.*', 'smis_hrd_employee.nip')->first();

            return response()->json([
                'status' => true,
                'message' => 'Ok',
                'data' => $last,
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage(),
            ]);
        }
    }

    function select_resep(Request $req)
    {
        return response()->json((new ResepService)->select($req->id));
    }

    function list_obat(Request $req)
    {
        return DataTables::of((new ResepService)->obat_tersedia())->toJson();
    }

    function autocomplete_obat(Request $req)
    {
        if($req['query'] != ''){
            $query = (new ResepService)->obat_tersedia($req['query']);
            if (sizeof($query) > 0) {
                foreach ($query as $q) {
                    $output['suggestions'][] = [
                        'value' => $q->kode_obat . ' - ' . $q->nama_obat,
                        'nama'  => $q->nama_obat,
                        'kode_obat'  => $q->kode_obat,
                        'id'  => $q->id,
                        'jenis_obat'  => $q->nama_jenis_obat,
                        'stok' => $q->stok,
                    ];
                }
            }
            if (!empty($output)) {
                echo json_encode($output);
            }
        }
    }

    function harga_obat(Request $req)
    {
        return response()->json((new ResepService)->harga_obat($req->id_obat));
    }

    function resep_store(Request $req)
    {
        try {
            $resep = (new ResepService)->store($req);
            return response()->json([
                'status' => true,
                'message' => 'Ok',
                'data' => $resep,
                'code' => 200
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage(),
                'code' => 500
            ]);
        }
    }

    function resep_lock(Request $req)
    {
        try {
            $resep = (new ResepService)->lock($req);
            return response()->json([
                'status' => true,
                'message' => 'Ok',
                'data' => $resep,
                'code' => 200
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage(),
                'code' => 500
            ]);
        }
    }
}
