<?php

namespace App\Exports\DataIndukKepegawaian;

use App\Services\DataIndukKepegawaianService;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Sheet;

class UnitKerjaExport implements FromView, WithEvents
{
    private $request;
    /**
     * @param $dependencies
     */
    public function __construct($request)
    {
        $this->request = $request;
    }

    public function view(): View
    {
        $dataIndukKepegawaianService = new DataIndukKepegawaianService();

        return view('data_induk_kepegawaian.excel_unit_kerja', [
            'data' => $dataIndukKepegawaianService->getSearchUnitKerja($this->request)->get(),
            'kop' => $dataIndukKepegawaianService->getKopExcel()
        ]);
    }

    public function registerEvents(): array
    {
        Sheet::macro('styleCells', function (Sheet $sheet, string $cellRange, array $style) {
            $sheet->getDelegate()->getStyle($cellRange)->applyFromArray($style);
        });

        return [
            AfterSheet::class => function (AfterSheet $event) {

                //                $event->sheet->getStyle('C:F')->getNumberFormat()
                //                   ->setFormatCode('_(* #,##0_);_(* \(#,##0\);_(* "-"??_);_(@_)');

                $event->sheet->getColumnDimension('A')->setWidth(4);
                $event->sheet->getColumnDimension('B')->setWidth(20);
                $event->sheet->getColumnDimension('C')->setWidth(25);
                $event->sheet->getColumnDimension('D')->setWidth(25);
                $event->sheet->getColumnDimension('E')->setWidth(25);
                $event->sheet->getColumnDimension('F')->setWidth(25);
                $event->sheet->getColumnDimension('G')->setWidth(33);
            },

        ];
    }
}
