@extends('layouts.app')
@section('content')
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Practioner</h1>
        </div>

        <div class="section-body">
            <div class="card pt-3 pb-3">
                <div class="row" style="width: 100%; margin-left: 0;">
                    <div class="col-lg-12">
                        <table class="table table-striped" id="tabel_practioner" style="width: 100%">
                            <thead>
                                <tr class="text-center">
                                    <th>No.</th>
                                    <th>Nama</th>
                                    <th>NIK</th>
                                    <th>Nomor IHS</th>
                                    <th>Alamat</th>
                                    <th>Ruangan</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
@push('scripts')
<script>
    $(document).ready(function() {
        get_data_practioner();
    })

    function loading(tipe, msg) {
        return '<div class="spinner-border spinner-border-'+tipe+'" role="status">' +
            '<span class="sr-only"></span>' +
            '</div> '+msg;
    }

    function get_data_practioner() {
        if ($.fn.DataTable.isDataTable("#tabel_practioner")) {
            $('#tabel_practioner').DataTable().clear().destroy();
        }

        $('#tabel_practioner').DataTable({
            processing: true,
            serverSide: true,
            bAutoWidth: false,
            bLengthChange: false,
            ajax: "{{ url('satu_sehat/practioner/datatable') }}", // memanggil route yang menampilkan data json
            columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                    data: null,
                    name: 'id',
                    render: function(data, type, row, meta) {
                        return '<div class="text-center">' + (meta.row + meta.settings._iDisplayStart +
                            1) + '</div>';
                    }
                },
                {
                    data: 'nama',
                    name: 'nama'
                },
                {
                    data: 'noktp',
                    name: 'noktp'
                },
                {
                    data: 'ihs_number',
                    name: 'ihs_number'
                },
                {
                    data: 'alamat',
                    name: 'alamat'
                },
                {
                    data: 'ruangan_pegawai',
                    name: 'ruangan_pegawai'
                },
                {
                    data: 'noktp',
                    name: 'noktp',
                    render: function(data, type, row, meta) {
                        return '<div class="text-center">' +
                            '<button class="btn btn-warning" onclick="update_ihs(' + "'" + data + "'" + ')"><i class="fa fa-pencil"></i></button>' +
                            '</div>';
                    }
                }
            ],
        })
    }

    function update_ihs(param) {
        toastr.warning(loading('sm', 'Sedang mengupdate data, harap tunggu...'));
        $.ajax({
            url: "{{ url('satu_sehat/practioner/update_ihs') }}",
            data: {
                nik: param,
                _token : '{{ csrf_token() }}',
                _method : 'patch'
            },
            method : 'post',
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                toastr.success(response.message);
                get_data_practioner();
            }
        })
    }
</script>
@endpush