<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Persetujuan Umum Rawat Jalan</title>

    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/css/toastr.css" rel="stylesheet" />

    <style type="text/css">
        #data_diri_header tr td {
            font-size: 16px;
            vertical-align: top;
        }

        #data_diri_ttd tr td {
            font-size: 20px;
            vertical-align: top;
        }

        ul li {
            font-size: 18px;
            list-style-type: numeric;
            text-align: justify;
        }

        ul {
            /* margin-left: -25px; */
        }

        /* input[type=text] {
            border: 1px solid;
        } */
        #kop_alamat {
            font-size: 18px;
        }

        .inputan {
            border: none;
            border-bottom: 1px dotted;
        }

        #logo {
            width: 100%;
        }

        ul li {
            list-style-type: numeric;
            font-size: 16px;
        }

        .sub_list li {
            list-style-type: lower-alpha;
        }

        @media print {
            #box_btn_simpan {
                display: none;
            }

            .hidden_on_print {
                display: none;
            }

            #pi_satu {
                border: 1px solid;
            }

            #pi_dua {
                border: 1px solid;
            }

            #pi_tiga {
                border: 1px solid;
            }

            input[type=text] {
                border: 1px solid transparent;
            }

            input[type=date] {
                border: 1px solid transparent;
            }

            input[type=number] {
                border: 1px solid transparent;
            }

            .alert {
                display: none;
            }

            #kop_alamat {
                font-size: 14px;
            }

            #logo {
                width: 140%;
                margin-left: 15px;
            }

            .col-md-1,
            .col-md-2,
            .col-md-3,
            .col-md-4,
            .col-md-5,
            .col-md-6,
            .col-md-7,
            .col-md-8,
            .col-md-9,
            .col-md-10,
            .col-md-11,
            .col-md-12 {
                float: left;
            }

            .col-md-12 {
                width: 100%;
            }

            .col-md-11 {
                width: 91.66666667%;
            }

            .col-md-10 {
                width: 83.33333333%;
            }

            .col-md-9 {
                width: 75%;
            }

            .col-md-8 {
                width: 66.66666667%;
            }

            .col-md-7 {
                width: 58.33333333%;
            }

            .col-md-6 {
                width: 50%;
            }

            .col-md-5 {
                width: 41.66666667%;
            }

            .col-md-4 {
                width: 33.33333333%;
            }

            .col-md-3 {
                width: 25%;
            }

            .col-md-2 {
                width: 16.66666667%;
            }

            .col-md-1 {
                width: 8.33333333%;
            }
        }
    </style>
</head>

<body style="margin: 20px;">
    <div class="modal fade" id="modal_petugas" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Verifikasi Petugas</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" id="form_verifikasi">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="">Password :</label>
                            <input type="password" id="pass" placeholder="Input your password" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Verifikasi</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modal_pasien" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Tanda tangan pasien</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="POST" id="form_tanda_tangan">
                    <div class="modal-body">
                        <div class="col-md-12">
                            <div class="form-group text-center">
                                <label for="">Nama Lengkap</label>
                                <input style="border: 2px solid;" class="form-control" id="nama_pasien" placeholder="Nama Lengkap">
                                <h6>Signature :</h6>
                                <canvas style="border: 2px solid;" id="signature-pad" class="signature-pad" width=400 height=200></canvas>
                            </div>
                            <div class="form-group text-center">
                                <button id="clear" type="button" class="btn btn-danger btn-sm">Clear Signature</button>
                            </div>
                        </div>
                        <br />
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <form style="border:1px solid;" id="form_dokumen">
        @csrf
        <input type="hidden" name="dokumen" value="{{ $dokumen->id }}">
        <input type="hidden" name="jenis_verifikasi">
        <input type="hidden" name="nama_pasien">
        <input type="hidden" name="password">
        <textarea name="signed" style="display: none"></textarea>
        <div class="row" style="width:100%; margin-left: 0;">
            <div class="col-md-7 pl-0 pr-0">
                <div class="row" style="width:100%; margin-left: 0; border: 1px solid;">
                    <div class="col-md-2" style="display:flex; justify-content:center; align-items:center;">
                        <img src="{{ asset('filelogo/logo_new.jpg') }}" id="logo">
                    </div>
                    <div class="col-md-10 pt-4">
                        <h3>{{ env('NAMA_KLINIK') }}</h3>
                        <p id="kop_alamat">{{ env('ALAMAT_KLINIK') }}</p>
                    </div>
                    <div class="col-md-12 text-center pt-4 pb-3" style="border-top:1px solid">
                        <h4>PERNYATAAN PERSETUJUAN UMUM</h4>
                    </div>
                </div>
            </div>
            <div class="col-md-5 pt-3" style="border:1px solid">
                <table style="border-collapse:collapse;" id="data_diri_header">
                    <tr>
                        <td style="width: 20%;">No RM</td>
                        <td style="padding-left:10px; padding-right:10px"> : </td>
                        <td>{{ $pasien->nrm ?? '' }}</td>
                    </tr>
                    <tr>
                        <td style="width: 20%;">NIK</td>
                        <td style="padding-left:10px; padding-right:10px"> : </td>
                        <td>{{ $pasien->ktp ?? '' }}</td>
                    </tr>
                    <tr>
                        <td style="width: 20%;">Nama</td>
                        <td style="padding-left:10px; padding-right:10px"> : </td>
                        <td>{{ $pasien->nama ?? '' }} ({{ $pasien ? ($pasien->kelamin == 0 ? 'L' : ($pasien->kelamin == 1 ? 'P' : '')) : '' }})</td>
                    </tr>
                    <tr>
                        <td style="width: 20%;">Tgl Lahir</td>
                        <td style="padding-left:10px; padding-right:10px"> : </td>
                        <td>{{ $pasien ? date('d-m-Y', strtotime($pasien->tgl_lahir)) : '' }}</td>
                    </tr>
                    <tr>
                        <td style="width: 20%; vertical-align:top;">Alamat</td>
                        <td style="padding-left:10px; vertical-align:top; padding-right:10px"> : </td>
                        <td>
                            @if($pasien)
                            {{ $pasien->alamat }}, RT {{ $pasien->rt }} RW {{ $pasien->rw }},
                            {{ $pasien->nama_kelurahan }}, {{ $pasien->nama_kecamatan }},
                            {{ $pasien->nama_kabupaten }}
                            @endif
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        <div class="row" style="width:100%; margin-left: 0;">
            <div class="col-md-12">
                <table style="border-collapse:collapse;" id="data_diri_ttd">
                    <tr>
                        <td colspan="3">Saya yang bertanda tangan dibawah ini :</td>
                    </tr>
                    <tr>
                        <td style="width: 20%;">Nama</td>
                        <td style="padding-left:10px; padding-right:10px"> : </td>
                        <td>
                            <input type="text" name="nama" value="{{ $data ? $data->nama : ($pasien->nama ?? '') }}" class="form-control inputan">
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 20%;">Tanggal Lahir</td>
                        <td style="padding-left:10px; padding-right:10px"> : </td>
                        <td>
                            <input type="text" name="tgl_lahir" value="{{ $data ? date('d-m-Y', strtotime($data->tgl_lahir)) : ($pasien ? date('d-m-Y', strtotime($pasien->tgl_lahir)) : '') }}" class="form-control inputan datepicker">
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 20%;">Alamat</td>
                        <td style="padding-left:10px; padding-right:10px"> : </td>
                        <td>
                            <input type="text" name="alamat" value="{{ $data ? $data->alamat : ($pasien ? $pasien->alamat . ', RT ' . $pasien->rt . ' RW ' . $pasien->rw . ', ' . $pasien->nama_kelurahan . ', ' . $pasien->nama_kecamatan . ', ' . $pasien->nama_kabupaten : '') }}" class="form-control inputan">
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 20%;">Telepon</td>
                        <td style="padding-left:10px; padding-right:10px"> : </td>
                        <td>
                            <input type="number" min="0" name="telpon" value="{{ $data ? $data->telpon : ($pasien->telpon ?? '') }}" class="form-control inputan">
                        </td>
                    </tr>
                    <tr>
                        <td colspan="3">
                            Hubungan dengan pasien :
                            <input type="text" name="hubungan" class="inputan" value="{{ $data ? $data->hubungan : 'Diri Sendiri' }}" placeholder="diisi bila anda bukan pasien">
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        <div class="row" style="width:100%; margin-left: 0;">
            <div class="col-md-12">
                <h3 style="font-weight:bold;">I. PERSETUJUAN UNTUK PERAWAT DAN PENGOBATAN</h3>
                <ul id="list_numbering">
                    <li>
                        Saya mengetahui bahwa saya memiliki kondisi yang membutuhkan perawatan medis, saya memberi
                        ijin kepada dokter dan profesi kesehatan lainya untuk melakukan prosedur diagnostik dan untuk
                        memberikan pengobatan medis seperti yang diperlukan untuk penilaian secara profesional. Prosedur
                        diagnostik dan perawatan medis ( pasang infus, injeksi IV/IM/SC ), termasuk terapi tidak
                        terbatas pada ECG,X-Ray, tes darah, terapi fisik dan pemberian obat.
                    </li>
                    <li>
                        Saya sadar bahwa praktek kedokteran dan ilmu bedah bukanlah ilmu pasti dan saya mengakui
                        bahwa tidak ada jaminan atas basil apapun, terhadap perawatan prosedur atau pemeriksaan apapun
                        yang dilakukan kepada saya.
                    </li>
                    <li>
                        Saya-mengerti dan memahami bahwa
                        <ul class="sub_list">
                            <li>
                                Saya memiliki hak untuk menanyakan tentang pengobatan yang diusulkan termasuk identitas
                                setiap orang yang memberikan atau mengamati pengobatan setiap saat.
                            </li>
                            <li>
                                Saya memiliki hak untuk persetujuan, atau menolak persetujuan untuk setiap
                                prosedur/terapi.
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
        <div class="row" style="width:100%; margin-left: 0;">
            <div class="col-md-12">
                <h3 style="font-weight:bold;">II. BARANG BARANG MILIK PASIEN</span>
                </h3>
                <ul id="list_numbering">
                    <li>
                        Saya telah memahami bahwa rumah sakit tidak bertanggung jawab sepenuhnya atas kehilangan
                        barang-barang milik saya dan saya secara pribadi bertanggung jawab atas barang-barang berharga
                        yang saya miliki seperti uang, perhiasan, handphone atau barang lainnya. Dan apabila saya
                        membutuhkan maka saya dapat menitipkan barang tersebut kepada rumah sakit.
                    </li>
                    <li>
                        Saya memahami bahwa {{ env('NAMA_KLINIK') }} telah menghimbau untuk tidak membawa barang berharga ke RS
                        untuk menghindari kehilangan
                    </li>
                </ul>
            </div>
        </div>
        <div class="row" style="width:100%; margin-left: 0; padding-bottom:20px;">
            <div class="col-md-12">
                <h3 style="font-weight:bold;">III. PERSETUJUAN PELEPASAN INFORMASI</h3>
                <ul id="list_numbering">
                    <li>
                        Saya memahami bahwa informasi yang ada di dalam diri pasien termasuk data rekam medis pasien
                        yang akan digunakan untuk kepentingan keperawatan medis, {{ env('NAMA_KLINIK') }} akan menjamin
                        kerahasiaannya.
                    </li>
                    <li>
                        Saya memberi persetujuan kepada pihak {{ env('NAMA_KLINIK') }} untuk memberikan informasi dalam rekam
                        medis pasien bila diperlukan untuk proses klaim asuransi / perusahaan atau lembaga pemerintah.
                    </li>
                    <li>
                        Saya mengetahui dan menyetujui bahwa berdasarkan Peraturan Menteri Kesehatan Nomor 24 Tahun
                        2022 tentang Rekam Medis, fasilitas pelayanan kesehatan wajib membuka akses dan mengirim data
                        rekam medis kepada Kementerian Kesehatan melalui Platform SATUSEHAT.
                    </li>
                    <li>
                        Menyetujui untuk menerima dan membuka data Pasien dari Fasilitas Pelayanan Kesehatan lainnya
                        melalui SATUSEHAT untuk kepentingan pelayanan kesehatan dan/atau rujukan.
                    </li>
                    <li>
                        Saya memberi persetujuan kepada pihak {{ env('NAMA_KLINIK') }} untuk memberikan informasi tentang
                        diagnosis hasil pelayanan dan pengobatan saya kepada.
                    </li>
                </ul>
            </div>
            <div class="col-md-4">
                <input type="text" class="form-control" name="pi_satu" value="{{ $data ? $data->pi_satu : '' }}">
            </div>
            <div class="col-md-4">
                <input type="text" class="form-control" name="pi_dua" value="{{ $data ? $data->pi_dua : '' }}">
            </div>
            <div class="col-md-4">
                <input type="text" class="form-control" name="pi_tiga" value="{{ $data ? $data->pi_tiga : '' }}">
            </div>
        </div>
        <div class="row" style="width:100%; margin-left: 0;">
            <div class="col-md-12">
                <h3 style="font-weight:bold;">IV. KEWAJIBAN, HAK, DAN TANGGUNG JAWAB PASIEN</h3>
                <ul>
                    <li>
                        Saya memiliki hak untuk mengambil bagian dalam keputusan mengenai penyakit saya dalam hal
                        perawatan medis dan rencana pengobatan.
                    </li>
                    <li>
                        Saya telah mendapat informasi tentang Tata-tertib, Hak dan Kewajiban pasien di {{ env('NAMA_KLINIK') }}
                        melalui leaflet dan banner yang disediakan oleh petugas.
                    </li>
                </ul>
            </div>
        </div>
        <div class="row" style="width:100%; margin-left: 0;">
            <div class="col-md-12">
                <h3 style="font-weight:bold;">V. PRIVASI</h3>
                <ul style="margin-left: -17px;">
                    <li style="list-style-type: none;">
                        Saya memberi kuasa kepada {{ env('NAMA_KLINIK') }} untuk menjaga privasi saya selama dalam perawatan,
                        bila saya membutuhkan perlindungan privasi khusus, saya akan menandatangani formulir yang sudah
                        disediakan oleh rumah sakit.
                    </li>
                </ul>
            </div>
        </div>
        <div class="row pb-3" style="width:100%; margin-left: 0;">
            <div class="col-md-12">
                <h3 style="font-weight:bold;">VI. PROSES PENYAMPAIAN KELUHAN</h3>
                <ul>
                    <li>Langsung ke petugas.</li>
                    <li>Lewat kotak saran.</li>
                    <li>Lewat Telp : {{ env('TELPON_KLINIK') }}</li>
                </ul>
            </div>
        </div>
        <div class="row" style="width:100%; margin-left: 0;">
            <div class="col-md-12">
                <p>
                    Dengan tanda tangan saya dibawah ini,saya menyatakan bahwa saya telah mengerti dan memahami persetujuan umum tersebut.
                </p>
            </div>
            <!-- <div class="col-md-12 text-center" id="box_btn_simpan">
                <button type="submit" class="btn btn-success">Simpan</button>
            </div> -->
        </div>
        <div class="row pt-4" style="width:100%; margin-left: 0; ">
            <div class="col-md-6 text-center" onclick="open_modal_petugas()" style="padding-top:10px; font-weight:bold;">
                <p>&nbsp;</p>
                <p>Petugas Klinik</p>
                <div id="box_ttd_petugas">
                    @if($dokumen->status == 1)
                    <img src="{{ env('SMIS_UPLOAD_URL').'/'.($employee ? $employee->ttd : '') }}" style="height: 2.5cm; width: 5cm;" alt="">
                    <br>
                    ({{ $employee->nama ?? '' }})
                    @else
                    <br>
                    Simpan & verifikasi
                    <br>
                    <br>
                    (.................................................)
                    <br>
                    Tanda tangan & nama terang
                    @endif
                </div>
                
            </div>
            <div class="col-md-6 text-center pt-2" onclick="open_modal_pasien()" style="padding-top: 20px; font-weight:bold;">
                <p>
                    Batam {{ is_null($dokumen->tanggal_update) ? '..........................................' : date('d-m-Y', strtotime($dokumen->tanggal_update)) }}
                </p>
                <p style="margin-top:-6px;">Yang Memberi persetujuan</p>
                <div id="box_ttd_pasien">
                    @if ($data && $data->ttd_pasien != '')
                    <img src="{{ asset('signature_patient/'.$data->ttd_pasien) }}" style="height: 2.5cm; width: 5cm;" alt="">
                    <br>
                    (<?php echo $data ? $data->nama_pasien : $dokumen->nama_pasien; ?>)
                    @else
                    <br>
                    Simpan & verifikasi
                    <br>
                    <br>
                    (.................................................)
                    <br>
                    Tanda tangan & nama terang
                    @endif                    
                </div>
            </div>
        </div>
    </form>
    <!-- <div class="row pb-5 hidden_on_print" style="width:100%; margin-left:0;" id="keterangan">
        <div class="col-md-12">
            @if ($dokumen->status == 1)
            Dokumen asli telah diupload pada {{ date('d-m-Y H:i:s', strtotime($dokumen->tanggal_update)) }} oleh
            {{ $dokumen->nama_verifikator }}
            @endif
        </div>
    </div> -->
</body>
<script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script type="text/javascript" src="{{ asset('app-assets/js/bootstrap.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.30.1/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/js/toastr.js"></script>
<script>
    $('.datepicker').daterangepicker({
        locale: {
            format: 'DD-MM-Y'
        },
        singleDatePicker: true,
        autoUpdateInput: false,
        timePicker: false,
    });

    $('.timepicker').daterangepicker({
        locale: {
            format: 'HH:mm'
        },
        singleDatePicker: true,
        timePicker: true,
        timePicker24Hour: true,
        autoUpdateInput: false,
    }).on('show.daterangepicker', function(ev, picker) {
        picker.container.find(".calendar-table").hide();
    });

    $('.datetimepicker').daterangepicker({
        locale: {
            format: 'DD-MM-Y HH:mm'
        },
        singleDatePicker: true,
        timePicker: true,
        autoUpdateInput: false,
        timePicker24Hour: true,
    });

    $('.datepicker').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('DD-MM-YYYY'));
    });

    $('.timepicker').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('HH:mm'));
    });

    $('.datetimepicker').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('DD-MM-Y HH:mm'));
    });
</script>
<script>
    $(document).ready(function() {
        var verif = '{{ $dokumen->id_verifikator }}';
        if (verif != 0) {
            window.scrollTo({
                left: 0,
                top: document.body.scrollHeight,
                behavior: "smooth"
            });
        }
    })

    const signaturePad = new SignaturePad(document.getElementById('signature-pad'), {
        minWidth: 5,
        maxWidth: 10,
        penColor: 'rgb(0, 0, 0)',
        maxWidth: 2
    });

    $('#clear').click(function(e) {
        e.preventDefault();
        signaturePad.clear();
        $("[name=signed]").val('');
    });

    function open_modal_petugas() {
        $('#modal_petugas').modal('show');
    }

    function open_modal_pasien() {
        $('#modal_pasien').modal('show');
    }

    $('#form_verifikasi').submit(function(e) {
        e.preventDefault();
        $('[name=jenis_verifikasi]').val('petugas');
        $('[name=password]').val($('#password').val());
        $('#modal_petugas').modal('hide');
        $('#form_verifikasi')[0].reset();
        $('#form_dokumen').submit();
    })

    $('#form_tanda_tangan').submit(function(e) {
        e.preventDefault();
        $('[name=jenis_verifikasi]').val('pasien');
        $('[name=nama_pasien]').val($('#nama_pasien').val());
        $('[name=signed]').val(signaturePad.toDataURL('image/png'));
        $('#modal_pasien').modal('hide');
        $('#form_tanda_tangan')[0].reset();
        signaturePad.clear();
        $('#form_dokumen').submit();
    })

    $('#form_dokumen').submit(function(e) {
        e.preventDefault();

        toastr.warning('Sedang menyimpan dokumen, harap tunggu...')

        $.ajax({
            url: "{{ url('medical_record/e_rekam_medis/persetujuan_umum_rawat_jalan/store') }}",
            method: 'post',
            data: $('#form_dokumen').serialize(),
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }

                toastr.success(response.message);
                render_tanda_tangan($('[name=jenis_verifikasi]').val() == 'pasien' ? response.data : response.employee);
            }
        })
    })

    function render_tanda_tangan(data) {
        switch ($('[name=jenis_verifikasi]').val()) {
            case 'petugas':
                $('#box_ttd_petugas').html(
                    `<img src="{{ env('SMIS_UPLOAD_URL') }}/` + (data ? data.ttd : '') + `" alt="" style="width: 4cm; height:2.5cm">` +
                    '<br>' +
                    '<span style="border-bottom:1px solid;">(' + (data ? data.nama : '') + ')</span>'
                );
                break;
            case 'pasien':
                $('#box_ttd_pasien').html(
                    `<img src="{{ asset('signature_patient') }}/` + (data ? data.ttd_pasien : '') + `" alt="" style="width: 4cm; height:2.5cm">` +
                    '<br>' +
                    '<span style="border-bottom:1px solid;">(' + (data ? data.nama_pasien : '') + ')</span>'
                );
                break;

            default:
                break;
        }
    }
</script>

</html>