<script>
    let id_lab = '{{ $data->id_lab ?? 0 }}';
    //LAB
    function open_modal_lab() {
        $('#id_lab').val(id_lab);
        $.ajax({
            url: "{{ url('ajax_request/pesanan_lab_by_id') }}",
            data: {
                id: id_lab,
            },
            success: function(response) {
                let temp = [];
                if (Object.keys(response).length !== 0) {
                    const periksa = JSON.parse(response.periksa);
                    Object.entries(periksa).forEach(([key, value]) => {
                        if (`${value}` == 1) {
                            temp.push(`${key}`);
                        }
                    });
                    $('#pesan_pemeriksaan').val(temp).change();
                    $('#ruangan_lab').val(response.ruangan).change();
                }
                $('#modal_lab').modal('show');
            }
        })
    }

    $('#form_laboratorium').submit(function(e) {
        e.preventDefault();

        toastr.warning('Sedang menyimpan data, harap tunggu...');

        $.ajax({
            url: "{{ url('ajax_request/pesanan_lab_store') }}",
            method: 'post',
            data: $('#form_laboratorium').serialize(),
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }

                toastr.success(response.message);
                $('#modal_lab').modal('hide');
                let deta = response.data;

                var ins = deta.no_lab + ' - ';

                let master_lab = <?php echo $pemeriksaan; ?>;
                let json_periksa = JSON.parse(deta.periksa);
                let iteration = 0;

                for (let i = 0; i < master_lab.length; i++) {
                    if (json_periksa[master_lab[i].slug] == 1) {
                        ins +=  (iteration > 0 ? ', ' : '')+master_lab[i].nama;
                        iteration++;
                    }                    
                }
                $('#box_button_pesanan_lab').html(
                    '<button class="btn btn-warning btn-sm" type="button" onclick="open_modal_lab()"><i class="fa fa-pencil" style="color:#fff;"></i></button>' +
                    '<button class="btn btn-info btn-sm ml-1" type="button" data-toggle="tooltip" title="Hasil" onclick="open_modal_hasil_lab()">' +
                    '<i class="fa fa-book" style="color:#fff;"></i>' +
                    '</button>');
                $('#list_pesanan_lab').html(ins);
                id_lab = deta.id;
                $('[name=id_lab]').val(id_lab);
                $('[name=ppa_submit]').val('dr');
                $('#form_dokumen').submit();
            }
        })
    });

    function open_modal_hasil_lab() {
        let cek = false
        $.ajax({
            url: "{{ url('ajax_request/pesanan_lab_by_id') }}",
            data: {
                id: id_lab
            },
            success: function(response) {
                if (Object.keys(response).length === 0) {
                    return;
                }
                let temp = JSON.parse(response.hasil);
                let hasil = Object.entries(temp);
                let key_hasil = Object.keys(hasil);
                for (let i = 0; i < hasil.length; $i++) {
                    if (hasil[key_hasil[i]] != '') {
                        cek = true;
                        break;
                    }
                }
                var ins = '';
                if (cek) {
                    let temp_grup = '';
                    let master_hasil = <?php echo $master_hasil; ?>;
                    for (let i = 0; i < master_hasil.length; i++) {
                        if (temp[master_hasil[i].slug] != '') {
                            if (temp_grup != master_hasil[i].grup) {
                                ins += '<tr>' +
                                    '<th colspan="3">' + master_hasil[i].grup + '</th>' +
                                    '</tr>';
                                temp_grup = master_hasil[i].grup;
                            }
                            ins += '<tr>' +
                                '<td style="padding-left: 40px">' + master_hasil[i].name + '</td>' +
                                '<td class="text-center" style="' + cek_nilai_normal(temp[master_hasil[i].slug], master_hasil[i]) + '">' +
                                temp[master_hasil[i].slug] +
                                '</td>' +
                                '<td class="text-center">' + master_hasil[i].nt + '</td>' +
                                '</tr>';
                        }
                    }
                } else {
                    ins = '<tr>' +
                        '<th colspan="3" class="text-center">Tidak ada hasil</th>' +
                        '</tr>';
                }
                $('#list_hasil_lab').html(ins);
                $('#modal_hasil_lab').modal('show');
            }
        })
    }

    function cek_nilai_normal(nilai, master) {
        let kelamin = '{{ $layanan->kelamin }}';
        switch (master.nn) {
            case 'less-than':
                if (nilai < master.lessthan) {
                    return '';
                }
                return 'font-weight:bold; color:blue';
                break;
            case 'more-than':
                if (nilai > master.morethan) {
                    return '';
                }
                return 'font-weight:bold; color:blue';
                break;
            case 'between':
                if (nilai >= master.valmin && nilai <= master.valmax) {
                    return '';
                }
                return 'font-weight:bold; color:blue';
                break;
            case 'diantara_sampai':
                if (nilai >= master.valmin && nilai <= master.valmax) {
                    return '';
                }
                return 'font-weight:bold; color:blue';
                break;
            case 'same':
                if (nilai == master.sameval) {
                    return '';
                }
                return 'font-weight:bold; color:blue';
                break;
            case 'reaktif_nonreaktif':
                if (nilai == master.nt) {
                    return '';
                }
                return 'font-weight:bold; color:blue';
                break;
            case 'negatif':
                if (nilai == master.nt) {
                    return '';
                }
                return 'font-weight:bold; color:blue';
                break;
            case 'negatif_2':
                if (nilai == master.nt) {
                    return '';
                }
                return 'font-weight:bold; color:blue';
                break;
            case 'normal':
                if (nilai == master.nt) {
                    return '';
                }
                return 'font-weight:bold; color:blue';
                break;
            case 'negatif_positif':
                if (nilai == master.nt) {
                    return '';
                }
                return 'font-weight:bold; color:blue';
                break;
            case 'laper':
                if (kelamin == '0') {
                    if (nilai >= master.lmin && nilai <= master.lmax) {
                        return '';
                    }
                    return 'font-weight:bold; color:blue';
                } else if (kelamin == '1') {
                    if (nilai >= master.pmin && nilai <= master.pmax) {
                        return '';
                    }
                    return 'font-weight:bold; color:blue';
                }
                return '';
                break;

            default:
                return '';
                break;
        }
    }
    //END OF LAB
</script>