@extends('medical_record.e_rekam_medis.dokumen_kunjungan.layout')
@section('content')
<style>
    .inputan {
        border: none;
        border-bottom: 1px dotted;
    }
</style>
<form style="border:1px solid;" class="container pl-0 pr-0" id="form_dokumen">
    @csrf
    <input type="hidden" name="dokumen" value="{{ $dokumen->id }}">
    <input type="hidden" name="password">
    @include('medical_record.e_rekam_medis.dokumen_kunjungan.kop')

    <div class="row pt-4" style="width:100%; margin-left: 0;">
        <div class="col-lg-12">
            <p>Pemeriksaan Tanggal : {{ date('d-m-Y H:i', strtotime($dokumen->created_at)) }}</p>
        </div>
    </div>
    <div class="row pt-4" style="width:100%; margin-left: 0;">
        <div class="col-md-3" style="display: inline-flex;">
            <p style="font-weight: bold;">A. Keluhan Utama : </p>
        </div>
        <div class="col-md-9">
            <input type="text" name="keluhan_utama" value="{{ $data ? $data->keluhan_utama : ($diagnosa->keluhan ?? '') }}" class="form-control">
        </div>
    </div>
    <div class="row pt-4" style="width:100%; margin-left: 0;">
        <div class="col-md-3" style="display: inline-flex;">
            <p style="font-weight: bold;">B. Riwayat Kesehatan : </p>
        </div>
        <div class="col-md-9">
            <input type="text" value="{{ $data->riwayat_kesehatan ?? '' }}" name="riwayat_kesehatan" class="form-control">
        </div>
    </div>
    <div class="row" style="width:100%; margin-left: 0;">
        <div class="col-md-12 pt-2">
            <p style="font-weight: bold;">C. Pemeriksaan fisik<br><span style="padding-left: 18px; font-weight:normal;">Keadaan umum :</span></p>
        </div>
        <div class="col-md-12 pb-3">
            <table style="width: 100%; border-collapse: collapse;">
                <tr>
                    <td class="text-center">
                        TTV : TD {{ $diagnosa ? $diagnosa->sistole."/".$diagnosa->diastole : '..../....' }} mmHg
                    </td>
                    <td class="text-center">
                        RR {{ $diagnosa->rr ?? '....' }} x/menit
                    </td>
                    <td class="text-center">
                        Nadi {{ $diagnosa->nadi ?? '....' }} x/menit
                    </td>
                    <td class="text-center">
                        Suhu {{ $diagnosa->suhu ?? '....' }} ᵒC
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row" style="width:100%; margin-left: 0;">
        <div class="col-md-3">
            <p style="padding-left: 18px;">Pemeriksaan Fisik : </p>
        </div>
        <div class="col-md-9">
            <input type="text" value="{{ $diagnosa ? $diagnosa->anamnesa : '' }}" class="form-control" readonly>
        </div>
    </div>
    <div class="row pt-4" style="width:100%; margin-left: 0;">
        <div class="col-md-3" style="display: inline-flex;">
            <p style="padding-left: 18px;">Kesadaran : </p>
        </div>
        <div class="col-md-9">
            <input type="text" readonly value="{{ $diagnosa ? $diagnosa->kesadaran : '' }}" name="kesadaran" class="form-control">
        </div>
    </div>
    <div class="row pt-4" style="width:100%; margin-left: 0;">
        <div class="col-md-3" style="display: inline-flex;">
            <p style="padding-left: 18px;">Catatan Khusus : </p>
        </div>
        <div class="col-md-9">
            <input type="text" value="{{ $dokumen ? ($data ? $data->catatan_khusus : '' ) : '' }}" name="catatan_khusus" class="form-control">
        </div>
    </div>
    <div class="row pt-4" style="width:100%; margin-left: 0;">
        <div class="col-md-12" style="display: inline-flex;">
            <p style="font-weight: bold;">D. Riwayat Psikologi</p>
        </div>
        <div class="col-md-12">
            <table style="width: 100%;">
                <tr>
                    <td style="padding-left: 18px;">
                        <input type="checkbox" id="tidak_ada" {{ isset($data) ? in_array('tidak_ada', json_decode($data->riwayat_psikologi)) ? 'checked' : '' : 'checked' }}> Tidak Ada
                    </td>
                    <td>
                        <input type="checkbox" id="rasa_tertekan" @if(isset($data)){{ in_array('rasa_tertekan', json_decode($data->riwayat_psikologi)) ? 'checked' : '' }} @endif> Rasa tertekan
                    </td>
                    <td>
                        <input type="checkbox" id="sulit_tidur" @if(isset($data)){{ in_array('sulit_tidur',json_decode($data->riwayat_psikologi)) ? 'checked' : '' }} @endif> Sulit tidur
                    </td>
                    <td>
                        <input type="checkbox" id="cemas" @if(isset($data)){{ in_array('cemas',json_decode($data->riwayat_psikologi)) ? 'checked' : '' }} @endif> Cemas
                    </td>
                    <td>
                        <input type="checkbox" id="sulit_berbicara" @if(isset($data)){{ in_array('sulit_berbicara',json_decode($data->riwayat_psikologi)) ? 'checked' : '' }} @endif> Sulit berbicara
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 18px;">
                        <input type="checkbox" id="rasa_bersalah" @if(isset($data)){{ in_array('rasa_bersalah',json_decode($data->riwayat_psikologi)) ? 'checked' : '' }} @endif> Rasa bersalah
                    </td>
                    <td>
                        <input type="checkbox" id="cepat_lelah" @if(isset($data)){{ in_array('cepat_lelah',json_decode($data->riwayat_psikologi)) ? 'checked' : '' }} @endif> Cepat lelah
                    </td>
                    <td>
                        <input type="checkbox" id="depresi" @if(isset($data)){{ in_array('depresi',json_decode($data->riwayat_psikologi)) ? 'checked' : '' }} @endif> Depresi
                    </td>
                    <td colspan="2">
                        <input type="checkbox" id="sulit_berkonsentrasi" @if(isset($data)){{ in_array('sulit_berkonsentrasi',json_decode($data->riwayat_psikologi)) ? 'checked' : '' }} @endif> Sulit berkonsentrasi
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row pt-4" style="width:100%; margin-left: 0;">
        <div class="col-md-12" style="display: inline-flex;">
            <p style="font-weight: bold;">E. Skrining Nutrisi</p>
        </div>
        <div class="col-md-5">
            <table style="border-collapse: collapse; width: 100%;">
                <tr>
                    <td>Berat badan</td>
                    <td> : </td>
                    <td>
                        <input style="width: 30%;" onkeyup="hitung_imt()" value="{{ $diagnosa ? $diagnosa->berat_badan : '' }}" type="number" min="0" step="0.01" id="bb" name="bb" class="ml-2"> kg
                    </td>
                </tr>
                <tr>
                    <td>Tinggi badan</td>
                    <td> : </td>
                    <td>
                        <input style="width: 30%;" onkeyup="hitung_imt()" value="{{ $diagnosa ? $diagnosa->tinggi_badan : '' }}" type="number" min="0" step="0.01" id="tb" name="tb" class="ml-2"> cm
                    </td>
                </tr>
                <tr>
                    <td>IMT</td>
                    <td> : </td>
                    <td>
                        <input style="width: 30%;" readonly id="imt" name="imt" value="{{ $diagnosa ? $diagnosa->imt : '' }}" type="number" min="0" step="0.01" class="ml-2"> kg/m2
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-md-7">
            <table style="border-collapse: collapse; width:100%">
                <tr>
                    <td>Penurunan BB</td>
                    <td> : </td>
                    <td>
                        <input type="radio" {{ isset($data) ? $data->penurunan_bb == '0' ? 'checked' : '' : 'checked' }} value="0" onclick="cek_penurunan_bb(this.value)" name="form_penurunan_bb"> Tidak
                        <input class="ml-2" {{ isset($data) ? $data->penurunan_bb == '1' ? 'checked' : '' : '' }} type="radio" value="1" onclick="cek_penurunan_bb(this.value)" name="form_penurunan_bb"> Ya
                        <input type="number" value="{{ $data ? $data->jumlah_penurunan_bb : '' }}" min="0" step="0.01" style="width:20%;" id="jumlah_penurunan_bb" name="jumlah_penurunan_bb"> kg
                    </td>
                </tr>
                <tr>
                    <td>Nafsu makan</td>
                    <td> : </td>
                    <td>
                        <input type="radio" {{ isset($data) ? $data->nafsu_makan == '0' ? 'checked' : '' : '' }} value="0" name="form_nafsu_makan"> Tidak
                        <input class="ml-2" {{ isset($data) ? $data->nafsu_makan == '1' ? 'checked' : '' : 'checked' }} type="radio" value="1" name="form_nafsu_makan"> Ya
                    </td>
                </tr>
                <tr>
                    <td>Status Gizi</td>
                    <td> : </td>
                    <td>
                        <input type="radio" @if(isset($data)){{ $data->status_gizi == 'normal' ? 'checked' : '' }} @endif value="normal" name="form_status_gizi"> Normal
                        <input class="ml-2" @if(isset($data)){{ $data->status_gizi == 'kurang' ? 'checked' : '' }} @endif type="radio" value="kurang" name="form_status_gizi"> Gizi Kurang
                        <input class="ml-2" @if(isset($data)){{ $data->status_gizi == 'lebih' ? 'checked' : '' }} @endif type="radio" value="lebih" name="form_status_gizi"> Gizi Lebih
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row pt-2" style="width:100%; margin-left: 0;">
        <div class="col-md-12" style="display: inline-flex;">
            <p style="width: 15%; font-weight:bold">F. Asesmen Nyeri</p>
            <select id="asesmen_nyeri" class="form-control" style="width: 10%;">
                @for($i = 0; $i<=10; $i++)
                    <option @if(isset($data))
                    {{ $data->asesmen_nyeri == $i ? 'selected' : '' }}
                    @elseif(isset($layanan->tanda_vital))
                    {{ $layanan->tanda_vital->nyeri == $i ? 'selected' : '' }}
                    @endif value="{{$i}}">{{$i}}</option>
                    @endfor
            </select>
            <div style="width: 75%;"></div>
        </div>
        <div class="col-md-12">
            <table style="width: 100%;" border="1">
                <tr>
                    <td style="width: 16.5%;">
                        <p style="font-size:100px; text-align: center;">&#128516;</p>
                    </td>
                    <td style="width: 16.5%;">
                        <p style="font-size:100px; text-align: center;">&#128522;</p>
                    </td>
                    <td style="width: 16.5%;">
                        <p style="font-size:100px; text-align: center;">&#128528;</p>
                    </td>
                    <td style="width: 16.5%;">
                        <p style="font-size:100px; text-align: center;">&#128542;</p>
                    </td>
                    <td style="width: 16.5%;">
                        <p style="font-size:100px; text-align: center;">&#128534;</p>
                    </td>
                    <td style="width: 16.5%;">
                        <p style="font-size:100px; text-align: center;">&#128557;</p>
                    </td>
                </tr>
                <tr class="text-center" style="font-weight: bold;">
                    <td>0<br>Tidak sakit</td>
                    <td>2<br>Sedikit sakit</td>
                    <td>4<br>Agak mengganggu</td>
                    <td>6<br>Mengganggu aktivitas</td>
                    <td>8<br>Sangat mengganggu</td>
                    <td>10<br>Tak tertahankan</td>
                </tr>
            </table>
            <!-- <img src="{{ asset('images/asesmen_nyeri.png') }}" alt=""> -->
        </div>
        <div class="col-md-12">
            <p>Klasifikasi nyeri : </p>
        </div>
        <div class="col-md-4">
            <ul style="list-style-type: none; margin-left: -30px;">
                <li>0 = tidak ada nyeri</li>
                <li>1 = nyeri seperti gatal, nyut-nyutan</li>
                <li>2 = nyeri seperti melilit atau terpukul</li>
                <li>3 = nyeri seperti perih atau mules</li>
            </ul>
        </div>
        <div class="col-md-5">
            <ul style="list-style-type: none; margin-left: -70px;">
                <li>4 = nyeri seperti kram atau kaku</li>
                <li>5 = nyeri seperti tertekan</li>
                <li>6 = nyeri seperti terbakar atau ditusuk-tusuk</li>
                <li>7-9 = sangat nyeri tapi masih bisa dikontrol oleh pasien</li>
            </ul>
        </div>
        <div class="col-md-3">
            <ul style="list-style-type: none; margin-left: -30px;">
                <li>10 = sangat nyeri, tidak dapat dikontrol oleh pasien</li>
            </ul>
        </div>
    </div>
    <div class="row pt-2" style="width:100%; margin-left: 0;">
        <div class="col-md-12" style="display: inline-flex;">
            <p style="font-weight: bold;">G. Asesmen fungsional</p>
        </div>
        <div class="col-md-12" style="padding-left: 30px;">
            <p>1. Penglihatan</p>
            <div style="margin-top: -20px;" class="mb-3">
                <input type="radio" @if(isset($data)){{ $data->penglihatan == 'normal' ? 'checked' : '' }} @else {{ 'checked' }} @endif value="normal" name="form_penglihatan"> Normal
                <input type="radio" @if(isset($data)){{ $data->penglihatan == 'memakai_kacamata' ? 'checked' : '' }} @endif class="ml-3" value="memakai_kacamata" name="form_penglihatan"> Memakai kacamata
                <input type="radio" @if(isset($data)){{ $data->penglihatan == 'mengeluh_adanya_penglihatan_buram' ? 'checked' : '' }} @endif class="ml-3" value="mengeluh_adanya_penglihatan_buram" name="form_penglihatan"> Mengeluh adanya penglihatan buram<br>
                <input type="radio" @if(isset($data)){{ $data->penglihatan == 'mempunyai_glukoma' ? 'checked' : '' }} @endif value="mempunyai_glukoma" name="form_penglihatan"> Mempunyai glukoma /katarak /degenerasi makula
            </div>
            <p>2. Penciuman</p>
            <div style="margin-top: -20px;" class="mb-3">
                <input type="radio" @if(isset($data)){{ $data->penciuman == 'normal' ? 'checked' : '' }} @else {{ 'checked' }} @endif value="normal" name="form_penciuman"> Normal
                <input type="radio" @if(isset($data)){{ $data->penciuman == 'tidak' ? 'checked' : '' }} @endif value="tidak" class="ml-3" name="form_penciuman"> Tidak
            </div>
            <p>3. Pendengaran</p>
            <div style="margin-top: -20px;" class="mb-3">
                <input type="radio" @if(isset($data)){{ $data->pendengaran == 'normal' ? 'checked' : '' }} @else {{ 'checked' }} @endif value="normal" name="form_pendengaran"> Normal
                <input type="radio" @if(isset($data)){{ $data->pendengaran == 'tuli' ? 'checked' : '' }} @endif value="tuli" class="ml-3" name="form_pendengaran"> Tuli kanan / kiri󠄀
                <input type="radio" @if(isset($data)){{ $data->pendengaran == 'alat_bantu' ? 'checked' : '' }} @endif value="alat_bantu" class="ml-3" name="form_pendengaran"> Alat bantu dengar kanan / kiri󠄀
            </div>
            <p>4. Kebiasaan buang air kecil / buang air besar</p>
            <div style="margin-top: -20px;" class="mb-3">
                <input type="radio" @if(isset($data)){{ $data->kebiasaan_bak_bab == 'normal' ? 'checked' : '' }} @else {{ 'checked' }} @endif value="normal" name="form_kebiasaan_bak_bab"> Normal
                <input type="radio" @if(isset($data)){{ $data->kebiasaan_bak_bab == 'perubahan' ? 'checked' : '' }} @endif value="perubahan" class="ml-3" name="form_kebiasaan_bak_bab"> Ada perubahan perilaku BAK / BAB
            </div>
        </div>
    </div>
    <div class="row pt-2" style="width:100%; margin-left: 0;">
        <div class="col-md-12" style="display: inline-flex;">
            <p style="font-weight: bold;">H. Asesmen Risiko Jatuh</p>
        </div>
        <div class="col-md-12">
            <table style="width:100%" border="1">
                <thead>
                    <tr class="text-center">
                        <th rowspan="2">Variabel</th>
                        <th colspan="2" class="p-3">Penilaian</th>
                        <th rowspan="2" class="p-3">Nilai</th>
                        <th rowspan="2">Keterangan</th>
                    </tr>
                    <tr class="text-center">
                        <th>Ya</th>
                        <th>Tidak</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="pl-3">Riwayat jatuh</td>
                        <td class="text-center">25</td>
                        <td class="text-center">0</td>
                        <td class="text-center; pl-2 pr-2">
                            <select id="riwayat_jatuh" name="riwayat_jatuh" onchange="hitung_skor()" class="form-control">
                                <option value="">--Select Here--</option>
                                <option value="25" {{ isset($data) ? $data->riwayat_jatuh == '25' ? 'selected' : '' : '' }}>25</option>
                                <option value="0" {{ isset($data) ? $data->riwayat_jatuh == '0' ? 'selected' : '' : 'selected' }}>0</option>
                            </select>
                        </td>
                        <td class="pl-3">
                            0 : pasien tidak mempunyai riwayat jatuh<br>
                            25 : jatuh pada saat pasien baru tiba di RS atau ada riwayat jatuh
                        </td>
                    </tr>
                    <tr>
                        <td class="pl-3">Diagnosis sekunder</td>
                        <td class="text-center">15</td>
                        <td class="text-center">0</td>
                        <td class="text-center; pl-2 pr-2">
                            <select id="diagnosis_sekunder" name="diagnosis_sekunder" onchange="hitung_skor()" class="form-control">
                                <option value="">--Select Here--</option>
                                <option value="15" {{ isset($data) ? $data->diagnosis_sekunder == '15' ? 'selected' : '' : '' }}>15</option>
                                <option value="0" {{ isset($data) ? $data->diagnosis_sekunder == '0' ? 'selected' : '' : 'selected' }}>0</option>
                            </select>
                        </td>
                        <td class="pl-3">
                            0 : hanya satu diagnose medis<br>
                            15 : lebih dari saru diagnosa medis
                        </td>
                    </tr>
                    <tr>
                        <td class="pl-3">
                            Alat bantu : <br>
                            <ul style="list-style-type: none;">
                                <li>Tidak/ bedrest/ bantuan perawat</li>
                                <li>Tongkat/ walker</li>
                                <li>Furniture</li>
                            </ul>
                        </td>
                        <td class="text-center" colspan="2">0<br>15<br>30</td>
                        <td class="text-center; pl-2 pr-2">
                            <select id="alat_bantu" name="alat_bantu" onchange="hitung_skor()" class="form-control">
                                <option value="">--Select Here--</option>
                                <option value="0" {{ isset($data) ? $data->alat_bantu == '0' ? 'selected' : '' : 'selected' }}>0</option>
                                <option value="15" {{ isset($data) ? $data->alat_bantu == '15' ? 'selected' : '' : '' }}>15</option>
                                <option value="30" {{ isset($data) ? $data->alat_bantu == '30' ? 'selected' : '' : '' }}>30</option>
                            </select>
                        </td>
                        <td class="pl-3">
                            0 : pasien berjalan tidak menggunakan alat bantu, menggunakan kursi roda, dan jika bedrest total tidak boleh bernajak dari tempat tidur<br>
                            15 : pasien menggunakan tongkat/ walker<br>
                            30 : mobilisasi menggunakan furniture sebagai penyangga
                        </td>
                    </tr>
                    <tr>
                        <td class="pl-3">Akses i.v.</td>
                        <td class="text-center">20</td>
                        <td class="text-center">0</td>
                        <td class="text-center; pl-2 pr-2">
                            <select id="akses_i_v" id="akses_i_v" onchange="hitung_skor()" class="form-control">
                                <option value="">--Select Here--</option>
                                <option value="20" {{ isset($data) ? $data->akses_i_v == '20' ? 'selected' : '' : '' }}>20</option>
                                <option value="0" {{ isset($data) ? $data->akses_i_v == '0' ? 'selected' : '' : 'selected' }}>0</option>
                            </select>
                        </td>
                        <td class="pl-3">
                            0 : tidak terpasang infuse,<br>
                            20 : terpasang infuse
                        </td>
                    </tr>
                    <tr>
                        <td class="pl-3">
                            Gaya berjalan : <br>
                            <ul style="list-style-type: none;">
                                <li>Normal/ bedrest/ kursi roda</li>
                                <li>Lemah</li>
                                <li>Gangguan berjalan</li>
                            </ul>
                        </td>
                        <td class="text-center" colspan="2">0<br>10<br>20</td>
                        <td class="text-center; pl-2 pr-2">
                            <select id="gaya_berjalan" id="gaya_berjalan" onchange="hitung_skor()" class="form-control">
                                <option value="">--Select Here--</option>
                                <option value="0" {{ isset($data) ? $data->gaya_berjalan == '0' ? 'selected' : '' : 'selected' }}>0</option>
                                <option value="10" {{ isset($data) ? $data->gaya_berjalan == '10' ? 'selected' : '' : '' }}>10</option>
                                <option value="20" {{ isset($data) ? $data->gaya_berjalan == '20' ? 'selected' : '' : '' }}>20</option>
                            </select>
                        </td>
                        <td class="pl-3">
                            0 : gaya berjalan normal, pasien berjalan tanpa alat bantu<br>
                            10 : gaya berjalan lemah, berpegangan pada furniture<br>
                            20 : gaya berjalan abnormal, pasien kesulitan bangun dari kursi, mencoba untuk bangun dengan cara memegang kursi
                        </td>
                    </tr>
                    <tr>
                        <td class="pl-3">
                            Status mental : <br>
                            <ul style="list-style-type: none;">
                                <li>Orientasi baik</li>
                                <li>Disorientasi</li>
                            </ul>
                        </td>
                        <td class="text-center" colspan="2">0<br>15</td>
                        <td class="text-center; pl-2 pr-2">
                            <select id="status_mental" id="status_mental" onchange="hitung_skor()" class="form-control">
                                <option value="">--Select Here--</option>
                                <option value="0" {{ isset($data) ? $data->status_mental == '0' ? 'selected' : '' : 'selected' }}>0</option>
                                <option value="15" {{ isset($data) ? $data->status_mental == '15' ? 'selected' : '' : '' }}>15</option>
                            </select>
                        </td>
                        <td class="pl-3">
                            0 : orientasi pasien baik<br>
                            15 : pasien disorientasi
                        </td>
                    </tr>
                    <tr>
                        <td colspan="3" class="text-center">Jumlah Skor</td>
                        <td class="text-center">
                            <p id="jumlah_skor">
                                <?php
                                if (isset($data)) {
                                    echo $data->riwayat_jatuh + $data->diagnosis_sekunder + $data->alat_bantu + $data->akses_i_v + $data->gaya_berjalan + $data->status_mental;
                                } else {
                                    echo '0';
                                }
                                ?>
                            </p>
                        </td>
                        <td class="pl-3">
                            0 – 24 : Risiko Rendah<br>
                            25 – 44 : Risiko Sedang<br>
                            ≥45 : Risiko Tingi<br>
                            Pasien yang risiko tinggi dipasang gelang warna kuning
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="row pt-4" style="width:100%; margin-left: 0;">
        <div class="col-md-12" style="display: inline-flex;">
            <p style="font-weight: bold;">I. Kebutuhan Edukasi</p>
        </div>
        <div class="col-md-12" style="padding-left: 18px;">
            <div style="display: inline-flex; align-items: center; width:100%;">
                <p style="width:50%;">Pemahaman tentang penyakit</p>
                <div style="margin-top: -15px; width:50%;" class="pl-5">
                    <input type="radio" {{ isset($data) ? $data->pemahaman_penyakit == '1' ? 'checked' : '' : 'checked' }} name="form_pemahaman_penyakit" value="1"> Ya
                    <input type="radio" {{ isset($data) ? $data->pemahaman_penyakit == '0' ? 'checked' : '' : '' }} class="ml-5" name="form_pemahaman_penyakit" value="0"> Tidak
                </div>
            </div>
            <br>
            <div style="display: inline-flex; align-items: center; width:100%;">
                <p style="width:50%;">Pemahaman tentang pengobatan</p>
                <div style="margin-top: -15px; width:50%;" class="pl-5">
                    <input type="radio" {{ isset($data) ? $data->pemahaman_pengobatan == '1' ? 'checked' : '' : 'checked' }} name="form_pemahaman_pengobatan" value="1"> Ya
                    <input type="radio" {{ isset($data) ? $data->pemahaman_pengobatan == '0' ? 'checked' : '' : '' }} class="ml-5" name="form_pemahaman_pengobatan" value="0"> Tidak
                </div>
            </div>
            <br>
            <div style="display: inline-flex; align-items: center; width:100%;">
                <p style="width:50%;">Pemahaman tentang perawatan</p>
                <div style="margin-top: -15px; width:50%;" class="pl-5">
                    <input type="radio" {{ isset($data) ? $data->pemahaman_perawatan == '1' ? 'checked' : '' : 'checked' }} name="form_pemahaman_perawatan" value="1"> Ya
                    <input type="radio" class="ml-5" {{ isset($data) ? $data->pemahaman_perawatan == '0' ? 'checked' : '' : '' }} name="form_pemahaman_perawatan" value="0"> Tidak
                </div>
            </div>
            <br>
            <div style="display: inline-flex; align-items: center; width:100%;">
                <p style="width:50%;">Pemahaman tentang keamanan dan penggunaan alkes</p>
                <div style="margin-top: -15px; width:50%;" class="pl-5">
                    <input type="radio" {{ isset($data) ? $data->pemahaman_keamanan_penggunaan_alkes == '1' ? 'checked' : '' : 'checked' }} name="form_pemahaman_keamanan_penggunaan_alkes" value="1"> Ya
                    <input type="radio" {{ isset($data) ? $data->pemahaman_keamanan_penggunaan_alkes == '0' ? 'checked' : '' : '' }} class="ml-5" name="form_pemahaman_keamanan_penggunaan_alkes" value="0"> Tidak
                </div>
            </div>
            <br>
            <div style="display: inline-flex; align-items: center; width:100%;">
                <p style="width:50%;">Pemahaman tentang nutrisi dan diet</p>
                <div style="margin-top: -15px; width:50%;" class="pl-5">
                    <input type="radio" {{ isset($data) ? $data->pemahaman_nutrisi_diet == '1' ? 'checked' : '' : 'checked' }} name="form_pemahaman_nutrisi_diet" value="1"> Ya
                    <input type="radio" {{ isset($data) ? $data->pemahaman_nutrisi_diet == '0' ? 'checked' : '' : '' }} class="ml-5" name="form_pemahaman_nutrisi_diet" value="0"> Tidak
                </div>
            </div>
            <br>
            <div style="display: inline-flex; align-items: center; width:100%;">
                <p style="width:50%;">Pemahaman tentang manajemen nyeri</p>
                <div style="margin-top: -15px; width:50%;" class="pl-5">
                    <input type="radio" {{ isset($data) ? $data->pemahaman_manajemen_nyeri == '1' ? 'checked' : '' : 'checked' }} name="form_pemahaman_manajemen_nyeri" value="1"> Ya
                    <input type="radio" class="ml-5" {{ isset($data) ? $data->pemahaman_manajemen_nyeri == '0' ? 'checked' : '' : '' }} name="form_pemahaman_manajemen_nyeri" value="0"> Tidak
                </div>
            </div>
        </div>
    </div>
    <div class="row pt-4" style="width:100%; margin-left: 0;">
        <div class="col-md-12" style="display: inline-flex;">
            <p style="font-weight: bold;">J. Hambatan untuk Menerima Edukasi</p>
        </div>
        <div class="col-md-4">
            <ul style="list-style-type: none;">
                <li><input type="radio" {{ isset($data) ? $data->hambatan == 'tidak_ada' ? 'checked' : '' : 'checked' }} value="tidak_ada" name="form_hambatan"> Tidak ada</li>
                <li><input type="radio" @if(isset($data)){{ $data->hambatan == 'ada_gangguan_penglihatan' ? 'checked' : '' }} @endif value="ada_gangguan_penglihatan" name="form_hambatan"> Ada gangguan penglihatan</li>
                <li><input type="radio" @if(isset($data)){{ $data->hambatan == 'buta_aksara' ? 'checked' : '' }} @endif value="buta_aksara" name="form_hambatan"> Buta Aksara</li>
                <li><input type="radio" @if(isset($data)){{ $data->hambatan == 'ada_gangguan_emosi' ? 'checked' : '' }} @endif value="ada_gangguan_emosi" name="form_hambatan"> Ada, gangguan emosi</li>
            </ul>
        </div>
        <div class="col-md-6">
            <ul style="list-style-type: none;">
                <li><input type="radio" @if(isset($data)){{ $data->hambatan == 'gangguan_fisik' ? 'checked' : '' }} @endif value="gangguan_fisik" name="form_hambatan"> Ada, gangguan fisik</li>
                <li><input type="radio" @if(isset($data)){{ $data->hambatan == 'gangguan_kognitif' ? 'checked' : '' }} @endif value="gangguan_kognitif" name="form_hambatan"> Ada, gangguan kognitif</li>
                <li><input type="radio" @if(isset($data)){{ $data->hambatan == 'keterbatasan_bahasa' ? 'checked' : '' }} @endif value="keterbatasan_bahasa" name="form_hambatan"> Ada, keterbatasan dalam bahasa</li>
                <li><input type="radio" @if(isset($data)){{ $data->hambatan == 'keterbatasan_budaya' ? 'checked' : '' }} @endif value="keterbatasan_budaya" name="form_hambatan"> Ada, keterbatasan dalam hal budaya/ spiritual/ agama</li>
            </ul>
        </div>
    </div>
    <div class="row pt-4" style="width:100%; margin-left: 0;">
        <div class="col-md-12" style="display: inline-flex;">
            <p style="font-weight: bold;">K. Pemeriksaan Penunjang (Jenis dan Tanggal Pemeriksaan) </p>
        </div>
        <div class="col-md-12">
            <ul style="list-style-type: none;">
                <li>
                    <input type="checkbox" {{ is_null($laboratorium) ? 'checked' : '' }} value="tidak ada" name="form_pemeriksaan_penunjang"> Tidak Ada
                </li>
                <li>
                    <?php
                    if ($laboratorium) {
                        $temp = '';
                        $iteration = 0;
                        $json = (array) json_decode($laboratorium->periksa);

                        for ($i = 0; $i < sizeof($pemeriksaan); $i++) {
                            if ($json[$pemeriksaan[$i]->slug] == 1) {
                                $temp .= ($iteration > 0 ? ', ' : '') . $pemeriksaan[$i]->nama;
                                $iteration++;
                            }
                        }
                    ?>
                        <input type="checkbox" checked value="laboratorium" name="form_pemeriksaan_penunjang"> {{ $laboratorium->no_lab }} - {{ $temp }}
                    <?php } else { ?>
                        <input type="checkbox" value="laboratorium" name="form_pemeriksaan_penunjang"> Laboratorium : -
                    <?php } ?>
                </li>
            </ul>
        </div>
    </div>
    <div class="row pt-4" style="width:100%; margin-left: 0;">
        <div class="col-md-12">
            <p style="font-weight: bold;">L. Masalah Keperawatan </p>
            <input type="form-control" autocomplete="on" name="masalah_keperawatan" value="{{ $data ? $data->masalah_keperawatan : '' }}" id="masalah_keperawatan" class="form-control">
        </div>
    </div>
    <div class="row pt-4" style="width:100%; margin-left: 0;">
        <div class="col-md-12">
            <p style="font-weight: bold;">M. Implementasi Keperawatan </p>
            <input type="form-control" autocomplete="on" name="implementasi_keperawatan" value="{{ $data ? $data->implementasi_keperawatan : '' }}" id="implementasi_keperawatan" class="form-control">
        </div>
        <div class="col-md-12 text-center pt-3">
            <button class="btn btn-success" type="submit">Simpan & Verifikasi</button>
        </div>
    </div>
    <div class="row pt-4 pb-5" style="width:100%; margin-left: 0; ">
        <div class="col-md-3 text-center" style="padding-top:20px; font-weight:bold;">

        </div>
        <div class="col-md-6 text-center" style="padding-top: 20px; font-weight:bold;">
            <p>Nama dan tanda tangan Perawat Rawat Jalan</p>
            <div id="box_ttd">
                @if($dokumen->id_verifikator == 0)
                <br>
                <br>
                <br>
                <br>
                (.................................................)
                <br>Tanda tangan & nama terang
                @else
                <img src="{{ env('SMIS_UPLOAD_URL').'/'.($employee->ttd ?? '') }}" style="height: 2.5cm; width: 5cm;" alt="">
                <br>{{$dokumen->nama_verifikator}}
                @endif
            </div>
        </div>
        <div class="col-md-3" style="padding-top: 20px; font-weight:bold;"></div>
    </div>
    <textarea name="riwayat_psikologi" hidden></textarea>
</form>
@include('medical_record.e_rekam_medis.dokumen_kunjungan.popup_verifikasi')
@endsection
@push('scripts')
<script>
    $(document).ready(function() {
        var imt = '{{ $diagnosa ? $diagnosa->imt : 0 }}';
        $('#imt').val(parseFloat(imt).toFixed(2));
        if (imt < 18.5) {
            $("input[name='form_status_gizi'][value='kurang']").prop("checked", true);
        } else if (imt > 18.5 && imt < 24.9) {
            $("input[name='form_status_gizi'][value='normal']").prop("checked", true);
        } else if (imt > 25) {
            $("input[name='form_status_gizi'][value='lebih']").prop("checked", true);
        }
    })

    function hitung_imt() {
        if ($('#bb').val() != '' && $('#tb').val() != '') {
            var imt = $('#bb').val() / (($('#tb').val() / 100) * ($('#tb').val() / 100));
            $('#imt').val(imt.toFixed(2));
            if (imt < 18.5) {
                $("input[name='form_status_gizi'][value='kurang']").prop("checked", true);
            } else if (imt > 18.5 && imt < 24.9) {
                $("input[name='form_status_gizi'][value='normal']").prop("checked", true);
            } else if (imt > 25) {
                $("input[name='form_status_gizi'][value='lebih']").prop("checked", true);
            }
        }
    }

    function hitung_skor() {
        var riwayat_jatuh = 0;
        var diagnosis_sekunder = 0;
        var alat_bantu = 0;
        var akses_i_v = 0;
        var gaya_berjalan = 0;
        var status_mental = 0;

        if ($("#riwayat_jatuh").val() != "") {
            riwayat_jatuh = $("#riwayat_jatuh").val();
        }
        if ($("#diagnosis_sekunder").val() != "") {
            diagnosis_sekunder = $("#diagnosis_sekunder").val();
        }
        if ($("#alat_bantu").val() != "") {
            alat_bantu = $("#alat_bantu").val();
        }
        if ($("#akses_i_v").val() != "") {
            akses_i_v = $("#akses_i_v").val();
        }
        if ($("#gaya_berjalan").val() != "") {
            gaya_berjalan = $("#gaya_berjalan").val();
        }
        if ($("#status_mental").val() != "") {
            status_mental = $("#status_mental").val();
        }

        var skor_akhir = 0;
        skor_akhir = parseInt(riwayat_jatuh) + parseInt(diagnosis_sekunder) + parseInt(alat_bantu) + parseInt(akses_i_v) + parseInt(gaya_berjalan) + parseInt(status_mental);
        $("#jumlah_skor").html(skor_akhir);
    }

    $('#form_dokumen').submit(function(e) {
        e.preventDefault();

        toastr.warning('Sedang menyimpan dokumen, harap tunggu...');

        let riwayat_psikologi = []
        if ($('#tidak_ada').is(':checked')) {
            riwayat_psikologi.push('tidak_ada');
        }
        if ($('#rasa_tertekan').is(':checked')) {
            riwayat_psikologi.push('rasa_tertekan');
        }
        if ($('#sulit_tidur').is(':checked')) {
            riwayat_psikologi.push('sulit_tidur');
        }
        if ($('#cemas').is(':checked')) {
            riwayat_psikologi.push('cemas');
        }
        if ($('#sulit_berbicara').is(':checked')) {
            riwayat_psikologi.push('sulit_berbicara');
        }
        if ($('#rasa_bersalah').is(':checked')) {
            riwayat_psikologi.push('rasa_bersalah');
        }
        if ($('#cepat_lelah').is(':checked')) {
            riwayat_psikologi.push('cepat_lelah');
        }
        if ($('#depresi').is(':checked')) {
            riwayat_psikologi.push('depresi');
        }
        if ($('#sulit_berkonsentrasi').is(':checked')) {
            riwayat_psikologi.push('sulit_berkonsentrasi');
        }

        $('[name=riwayat_psikologi]').val(JSON.stringify(riwayat_psikologi));

        $.ajax({
            url: "{{ url('medical_record/e_rekam_medis/pengkajian_keperawatan_rawat_jalan/store') }}",
            data: $('#form_dokumen').serialize(),
            method: 'post',
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }

                toastr.success(response.message);

                $('#box_ttd').html(
                    `<img src="{{ env('SMIS_UPLOAD_URL') }}/` + (response.employee ? response.employee.ttd : ``) + `" style="height: 2.5cm; width: 5cm;" alt="">` +
                    '<br>' +
                    (response.employee ? response.employee.nama : '')
                );
            }
        })
    })
</script>
@endpush