<div class="modal fade" id="modal_lab" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true" style="overflow-y: scroll">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Pesanan Lab</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="form_laboratorium" method="post">
                @csrf
                <input type="hidden" name="id" id="id_lab" value="{{ $data->id_lab ?? 0 }}">
                <input type="hidden" name="alamat" value="{{ $pasien->alamat ?? '' }}">
                <input type="hidden" name="ibu" value="{{ $layanan->ibu ?? '' }}">
                <input type="hidden" name="jenis_pasien" value="{{ $layanan->carabayar ?? '' }}">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="">No. Reg</label>
                        <input type="text" class="form-control" name="noreg" value="{{ str_replace(env('slug_klinik'),'',$layanan->id) }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="">Nama Pasien</label>
                        <input type="text" name="nama_pasien" value="{{ $layanan->nama_pasien }}" class="form-control" readonly>
                    </div>
                    <div class="form-group">
                        <label for="">NRM</label>
                        <input type="text" name="nrm" value="{{ $layanan->nrm }}" readonly class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">L/P</label>
                        <select name="kelamin" disabled class="form-control">
                            <option value="1" @if ($layanan->kelamin == 1) {{ 'selected' }} @endif> Laki-Laki</option>
                            <option value="0" @if ($layanan->kelamin == 0) {{ 'selected' }} @endif> Perempuan</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Umur</label>
                        <input type="text" readonly value="{{ $layanan->umur }}" name="umur" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Ruangan</label>
                        <select name="ruangan" id="ruangan_lab" class="form-control">
                            <option value="">--Select Here--</option>
                            @foreach ($ruangan as $ru)
                            <option value="{{ $ru->slug }}" @if ($layanan->jenislayanan == $ru->slug) {{ 'selected' }} @endif>
                                {{ $ru->nama }}
                            </option>
                            @endforeach
                            <option value="pendaftaran" @if ($layanan->jenislayanan == 'pendaftaran') {{ 'selected' }} @endif>Pendaftaran</option>
                            <option value="laboratory" @if ($layanan->jenislayanan == 'laboratory') {{ 'selected' }} @endif>Laboratory</option>
                            <option value="radiology" @if ($layanan->jenislayanan == 'radiology') {{ 'selected' }} @endif>Radiology</option>
                            <option value="elektromedis" @if ($layanan->jenislayanan == 'elektromedis') {{ 'selected' }} @endif>Elektromedis</option>
                            <option value="medical_checkup" @if ($layanan->jenislayanan == 'medical_checkup') {{ 'selected' }} @endif>Medical Checkup</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Tanggal</label>
                        <input type="date" readonly value="{{ date('Y-m-d') }}" name="tanggal" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Kelas</label>
                        <select name="kelas" class="form-control">
                            <option value="">--Select Here--</option>
                            @foreach ($list_kelas as $kls)
                            <option value="{{ $kls->slug }}" @if ($kelas) @if ($kls->slug == $kelas->value) {{ 'selected' }} @endif @endif>{{ $kls->nama }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Dokter</label>
                        <input type="text" id="dokter_lab" name="dokter" readonly placeholder="Pilih dokter" value="{{ $employee_auth->nama ?? '' }}" class="form-control">
                        <input type="hidden" value="{{ $employee_auth->id ?? '0' }}" id="id_dokter_lab" name="id_dokter">
                    </div>
                    <div class="form-group">
                        <label for="">Diagnosa</label>
                        <input type="text" readonly id="diagnosa_lab" name="diagnosa" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">Pesan Pemeriksaan</label>
                        <select name="pesan_pemeriksaan[]" multiple="multiple" id="pesan_pemeriksaan"
                            style="width: 100%" class="form-control">
                            @foreach ($pemeriksaan as $pe)
                            <option value="{{ $pe->slug }}">{{ $pe->nama }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_hasil_lab" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Hasil Laboratorium</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <thead>
                        <tr class="text-center">
                            <th>Jenis Pemeriksaan</th>
                            <th>Hasil</th>
                            <th>Nilai Rujukan</th>
                        </tr>
                    </thead>
                    <tbody id="list_hasil_lab">
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>