<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ambil Antrian</title>
    <link rel="stylesheet" href="{{ asset('app-assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style>
        #tabel_pasien tr {
            line-height: 40px;
        }
    </style>
</head>

<body style="background-color: lightblue;">
    <div class="row" style="margin-left: 0; width:100%; height:100vh;">
        <div class="col-lg-3"></div>
        <div class="col-lg-6" style="display: flex; justify-content: center; align-items: center;">
            <div id="box" class="card p-4" style="box-shadow: 3px 3px #999; width:100%;">
                <h3 style="text-align: center;">Ambil Antrian</h3>
                <br>
                <div style="display: inline-flex; align-items: center;">
                    <div style="width:25px; height:25px; border-radius:50%; background-color: green; color:#fff; text-align: center;"></div>
                    <div style="width:25vw; height:10px; background-color: green; color:#fff; text-align: center; margin-left: -2px;margin-right: -2px;"></div>
                    <div style="width:25px; height:25px; border-radius:50%; background-color: green; color:#fff; text-align: center;"></div>
                    <div style="width:25vw; height:10px; border-top:1px solid green; border-bottom:1px solid green; color:#fff; text-align: center; margin-left: -2px;margin-right: -2px;"></div>
                    <div style="width:25px; height:25px; border-radius:50%; border:1px solid green; color:#fff; text-align: center;"></div>
                </div>
                <br>
                <h6 style="text-align: center;">Pendaftaran Pasien Umum.</h6>
                <br>
                @if(Session::has('gagal'))
                <div class="alert alert-danger text-center">{{Session::get('gagal')}}</div>
                @endif
                @if(Session::has('sukses'))
                <div class="alert alert-success text-center">{{Session::get('sukses')}}</div>
                @endif
                @if ($errors->any())
                @foreach ($errors->all() as $error)
                <div class="alert alert-danger">{{$error}}</div>
                @endforeach
                @endif
                <div class="row" style="width: 100%; margin-left: 0;">
                    <form class="col-lg-12 pl-0 pr-0" method="post" action="{{ url('guest_registration/pasien_umum/daftar/post') }}">
                        @csrf
                        <input type="hidden" name="pasien" value="{{$pasien->id}}">
                        <input type="hidden" name="ktp" value="{{$pasien->ktp}}">
                        <input type="hidden" name="nobpjs" value="">
                        <input type="hidden" name="form" value="umum">
                        <div class="form-group">
                            <label for="">Pembayaran</label>
                            <select name="jenis_pasien" id="jenis_pasien" class="form-control" required>
                                <option value="">--Select Here--</option>
                                @foreach($jenispasien as $jp)
                                <option value="{{$jp->slug.'-'.$jp->asuransi.'-'.$jp->nama_perusahaan}}">{{$jp->nama}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Asuransi</label>
                            <select name="asuransi" id="asuransi" class="form-control" disabled>
                                <option value="">--Select Here--</option>
                                @foreach($asuransi as $asuran)
                                <option value="{{$asuran->id}}">{{$asuran->nama}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Perusahaan</label>
                            <select name="perusahaan" id="perusahaan" class="form-control" disabled>
                                <option value="">--Select Here--</option>
                                @foreach($perusahaan as $peru)
                                <option value="{{$peru->id}}">{{$peru->nama}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Tanggal Periksa</label>
                            <input type="date" value="{{ date('Y-m-d') }}" min="{{ date('Y-m-d') }}" max="{{ date('Y-m-d', strtotime('+1 days')) }}" id="tanggal" name="tanggalperiksa" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="">Poliklinik / Unit Penunjang</label>
                            <select name="kodepoli" id="poli" class="form-control" required>
                                <option value="">--Select Here--</option>
                                @foreach($poli as $pol)
                                <option value="{{$pol->kodepoli_bpjs.'-'.$pol->nama_poli_pcare}}">{{$pol->kodepoli_bpjs.' - '.$pol->nama_poli_pcare}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Dokter</label>
                            <select name="kodedokter" id="dokter" class="form-control" required>
                            </select>
                        </div>
                        <input type="hidden" name="id_jadwal">
                        {{-- <div class="form-group">
                            <label for="">Jam Praktek</label>
                            <select name="jampraktek" id="jam" class="form-control" required>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Keluhan</label>
                            <input type="text" name="keluhan" class="form-control" required>
                        </div> --}}
                        <div class="form-group">
                            <label for="">Jenis Kunjungan</label>
                            <select name="jenis_kunjungan" class="form-control" required>
                                <option value="">--Select Here--</option>
                                <option value="Kunjungan Sakit">Kunjungan Sakit</option>
                                <option value="SKS">SKS</option>
                            </select>
                        </div>
                        <div class="form-group pt-3 text-center">
                            <a href="{{ url('guest_registration/pasien_umum') }}" class="btn btn-warning" style="color: #fff;">Kembali</a>
                            <button class="btn btn-success" type="submit">Ambil Antrian</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-3"></div>
    </div>
</body>
<script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script src="{{ asset('app-assets/js/bootstrap.min.js') }}"></script>
<script>
    var kode_booking = '';
    var loading = '<div class="spinner-border spinner-border-sm" role="status">' +
        '<span class="sr-only">Loading...</span>' +
        '</div> Sedang mencari data...';

    $('#poli').on('change', function() {
        if ($('#tanggal').val() == '') {
            alert('Pilih tanggal periksa dahulu');
            $('#poli').val('');
            return;
        }
        $('#dokter').html('');
        $('#jam').html('');
        if ($('#poli').val() == '') {
            return;
        }
        $.ajax({
            url: '{{ url("ajax_request/dokter_by_poli") }}',
            data: {
                kode: $('#poli').val(),
                hari: new Date($('#tanggal').val()).getDay()
            },
            success: function(response) {
                console.log(response);
                if (response.length <= 0) {
                    return;
                }
                let ins = '<option value="">--Select Here--</option>';
                for (let i = 0; i < response.length; i++) {
                    ins += '<option value="' + response[i].id_dokter + '-'+response[i].id+'">' + response[i].nama_dokter+' '+response[i].jam_mulai+'-'+response[i].jam_selesai + '</option>';
                }
                $('#dokter').html(ins);
            }
        })
    })

    $('#tanggal').on('change', function() {
        $("#poli").val('');
        $("#dokter").html('');
        $("#jam").html('');
    })

    $('#dokter').on('change', function() {
        if ($('#tanggal').val() == '') {
            alert('Pilih tanggal periksa dahulu');
            $('#dokter').val('');
            return;
        }
        $('#jam').html('');
        if ($('#dokter').val() == '') {
            return;
        }
        let temp = $('#dokter').val().split('-');
        $('[name=id_jadwal]').val(temp[1]);
        $.ajax({
            url: '{{ url("ajax_request/jam_praktek_by_dokter") }}',
            data: {
                dokter: $('#dokter').val(),
                hari: new Date($('#tanggal').val()).getDay()
            },
            success: function(response) {
                console.log(response);
                if (response.length <= 0) {
                    return;
                }
                let ins = '';
                for (let i = 0; i < response.length; i++) {
                    ins += '<option value="' + response[i].jam_mulai + '-' + response[i].jam_selesai + '">' + response[i].jam_mulai + '-' + response[i].jam_selesai + '</option>';
                }
                $('#jam').html(ins);
            }
        })
    })

    $('#jenis_pasien').on('change', function(){
        if($('#jenis_pasien').val() == ''){
            $('#asuransi').attr('disabled', true);
            $('#perusahaan').attr('disabled', true);
        }else{
            var temp = $('#jenis_pasien').val().split('-');
            if (temp[1] == 1) {
                $('#asuransi').removeAttr('disabled');
            }else{
                $('#asuransi').attr('disabled', true);
            }
            if (temp[2] == 1) {
                $('#perusahaan').removeAttr('disabled');
            }else{
                $('#perusahaan').attr('disabled', true);
            }
        }
    })
</script>

</html>