@extends('layouts.app')
@section('content')
    <style>
        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        #tabel_identitas tr td {
            line-height: 40px;
        }

        #tabel_identitas td {
            white-space: nowrap;
        }
    </style>

    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>E-Rekam Medis</h1>
            </div>

            <div class="section-body">
                <div class="row" style="width: 100%; margin-left: 0;">
                    <div class="col-lg-5 pl-0">
                        <form class="card p-3" id="form_pencarian">
                            <p style="font-weight: bold">Pencarian Pasien</p>
                            <div class="form-group">
                                <label for="">No. RM</label>
                                <input type="number" name="nrm" id="nrm" min="1" class="form-control">
                            </div>
                            <table id="tabel_identitas" style="border-collapse: collapse;">
                                <tr>
                                    <td style="width:20%">Nama</th>
                                    <td style="width:5%"> : </th>
                                    <td id="result_nama">
                                        </th>
                                </tr>
                                <tr>
                                    <td style="width:20%">Tgl. Lahir</th>
                                    <td style="width:5%"> : </th>
                                    <td id="result_ttl">
                                        </th>
                                </tr>
                                <tr>
                                    <td style="width:20%">Kelamin</th>
                                    <td style="width:5%"> : </th>
                                    <td id="result_kelamin">
                                        </th>
                                </tr>
                                <tr>
                                    <td style="width:20%">Alamat</th>
                                    <td style="width:5%"> : </th>
                                    <td id="result_alamat">
                                        </th>
                                </tr>
                            </table>
                        </form>
                        <div class="card p-3 table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr class="text-center">
                                        <th>Tgl. Kunjungan</th>
                                        <th>Jenis</th>
                                        <th>Ruangan</th>
                                        <th>Dignosa</th>
                                    </tr>
                                </thead>
                                <tbody id="history_kunjungan"></tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col-lg-7">
                        <div id="erm"></div>
                        <div id="dokumen_kunjungan"></div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('scripts')
        <script>
            function erm(body) {
                return '<div class="card p-3 table-responsive">' +
                    '<p style="font-weight:bold">Dokumen Pasien</p>' +
                    '<table class="table table-striped">' +
                    '<thead>' +
                    '<tr class="text-center">' +
                    '<th>No</th>' +
                    '<th>Nama Dokumen</th>' +
                    '<th>Status</th>' +
                    '<th>Tanggal Update</th>' +
                    '<th>Verifikator</th>' +
                    '<th>Action</th>' +
                    '</tr>' +
                    '</thead>' +
                    '<tbody>' +
                    body +
                    '</tbody>' +
                    '</table>' +
                    '</div>';
            }

            function dokumen_kunjungan(body, layanan) {
                return '<div class="card p-3 table-responsive">' +
                    '<p style="font-weight:bold">Dokumen Kunjungan ' + tanggal_dmy(layanan.tanggal) + '</p>' +
                    '<div id="loading_dokumen_kunjungan">' +
                    '</div>' +
                    '<form id="form_create_dokumen_kunjungan" onsubmit="create_dokumen_kunjungan()" class="row pb-3" style="width:100%; margin-left:0;">' +
                    '<div class="col-lg-6 pl-0">' +
                    '<input type="hidden" name="noreg" value="' + layanan.id + '"/>' +
                    '<select class="form-control" name="jenis_dokumen">' +
                    '<option value="Asesmen Medis Rawat Jalan">Asesmen Medis Rawat Jalan</option>' +
                    '<option value="Surat Keterangan Sakit">Surat Keterangan Sakit</option>' +
                    '<option value="Konsultasi Poli Lain">Konsultasi Poli Lain</option>' +
                    '<option value="Informed Consent">Informed Consent</option>' +
                    '<option value="Pembedahan Operasi Kecil">Pembedahan Operasi Kecil</option>' +
                    '<option value="Catatan Perkembangan Pasien">Catatan Perkembangan Pasien</option>' +
                    '<option value="Pengkajian Awal Medis">Pengkajian Awal Medis</option>' +
                    '</select>' +
                    '</div>' +
                    '<div class="col-lg-6 pl-0 pt-1">' +
                    '<button class="btn btn-success" type="submit">Create</button>' +
                    '</div>' +
                    '</form>' +
                    '<table class="table table-striped">' +
                    '<thead>' +
                    '<tr class="text-center">' +
                    '<th>No</th>' +
                    '<th>Nama Dokumen</th>' +
                    '<th>Status</th>' +
                    '<th>Tanggal Update</th>' +
                    '<th>Verifikator</th>' +
                    '<th>Action</th>' +
                    '</tr>' +
                    '</thead>' +
                    '<tbody>' +
                    body +
                    '</tbody>' +
                    '</table>' +
                    '</div>';
            }

            function create_dokumen_kunjungan() {
                window.event.preventDefault();
                $('#loading_dokumen_kunjungan').html('<div class="alert alert-info">' + loading('Sedang membuat dokumen...',
                    'sm') + '</div>');
                $.ajax({
                    url: "{{ url('ajax_request/create_dokumen_kunjungan') }}",
                    data: $('#form_create_dokumen_kunjungan').serialize(),
                    success: function(response) {
                        if (!response.status) {
                            $('#loading_dokumen_kunjungan').html('<div class="alert alert-danger">' + response
                                .message + '</div>');
                            return;
                        }
                        $('#loading_dokumen_kunjungan').html('<div class="alert alert-success">' + response
                            .message + '</div>');
                        alert(response.message);
                        get_dokumen_kunjungan(response.data.noreg);
                    }
                })
            }

            function loading(msg, tipe) {
                return '<div class="spinner-border spinner-border-' + tipe + '" role="status">' +
                    '<span class="sr-only">Loading...</span>' +
                    '</div> ' + msg;
            }

            $('#form_pencarian').submit(function(e) {
                e.preventDefault();
                if ($('#nrm').val() == '') {
                    alert('Masukkan nomor RM terlebih dahulu');
                    return;
                }
                $('#result_nama').html(loading('', 'sm'));
                $('#result_ttl').html(loading('', 'sm'));
                $('#result_alamat').html(loading('', 'sm'));
                $('#result_kelamin').html(loading('', 'sm'));
                $('#erm').html(loading('', 'sm'));
                $('#dokumen_kunjungan').html('');
                $('#history_kunjungan').html('<tr><td colspan="4" class="text-center">' + loading(
                    ' Sedang mencari data', 'sm') + '</td></tr>');

                $.ajax({
                    url: "{{ url('ajax_request/pasien_by_nrm') }}",
                    data: $('#form_pencarian').serialize(),
                    success: function(response) {
                        console.log(response);
                        if (Object.keys(response).length === 0) {
                            $('#result_nama').html('');
                            $('#result_ttl').html('');
                            $('#result_alamat').html('');
                            $('#result_kelamin').html('');
                            $('#history_kunjungan').html('');
                            $('#erm').html('');
                            return;
                        }
                        $('#result_nama').html(response.nama);
                        $('#result_ttl').html(response.tempat_lahir + ', ' + tanggal_dmy(response
                            .tgl_lahir));
                        $('#result_alamat').html(response.alamat);
                        $('#result_kelamin').html(response.kelamin == 0 ? 'Laki-Laki' : 'Perempuan');
                        render_history_kunjungan(response.kunjungan);
                        render_erm(response);
                    }
                })
            })

            function render_erm(pasien) {
                if (pasien.erm == null) {
                    $('#erm').html(erm('<tr class="text-center"><td colspan="6">Data tidak ditemukan</td></tr>'));
                    return;
                }
                var ins = '<tr>'+
                    '<td class="text-center">1.</td>'+
                    '<td class="text-center">'+pasien.erm.nama_dokumen+'</td>'+
                    '<td class="text-center">'+(pasien.erm.status ? 'Sudah diverifikasi' : 'Belum diverifikasi')+'</td>'+
                    '<td class="text-center">'+tanggal_dmy(pasien.erm.tanggal_update)+'</td>'+
                    '<td class="text-center">'+pasien.erm.nama_verifikator+'</td>'+
                    '<td class="text-center">'+
                    '<div style="display:flex; flex-direction:row;">'+
                    (pasien.erm.status ? '<a href="./e_rekam_medis/identitas/pdf?dokumen='+pasien.erm.id+'" target="_blank" class="btn btn-success mr-1"><i class="fas fa-arrow-down"></i></a>' : '') +
                    '<a href="./e_rekam_medis/identitas?dokumen='+pasien.erm.id+'" target="_blank" class="btn btn-primary"><i class="fas fa-eye"></i></a>'
                    '</div>'+
                    '</td>'+
                    '</tr>';
                $('#erm').html(erm(ins));
            }

            function render_history_kunjungan(kunjungan) {
                var ins = '';
                if (kunjungan.length < 1) {
                    ins = '<tr><td colspan="4" class="text-center">Belum ada kunjungan</td></tr>';
                } else {
                    for (let i = 0; i < kunjungan.length; i++) {
                        ins += '<tr>' +
                            '<td><a style="text-decoration:none; color:#111;" onclick="get_dokumen_kunjungan(' + "'" +
                            kunjungan[i].id + "'" + ')" href="#">' + tanggal_dmyhi(kunjungan[i].tanggal) + '</a></td>' +
                            '<td>' + convert_slug(kunjungan[i].jenislayanan) + '</td>' +
                            '<td>' + convert_slug(kunjungan[i].last_ruangan) + '</td>' +
                            '<td>' + kunjungan[i].keluhan + '</td>' +
                            '</tr>';
                    }
                }
                $('#history_kunjungan').html(ins);
            }

            function get_dokumen_kunjungan(noreg) {
                window.event.preventDefault();
                $('#dokumen_kunjungan').html(loading('', 'sm'));
                $.ajax({
                    url: "{{ url('ajax_request/dokumen_kunjungan_by_noreg') }}",
                    data: {
                        noreg: noreg
                    },
                    success: function(response) {
                        console.log(response);
                        if (response.dokumen_kunjungan.length < 1) {
                            $('#dokumen_kunjungan').html(dokumen_kunjungan(
                                '<tr class="text-center"><td colspan="6">Data tidak ditemukan</td></tr>',
                                response));
                            return;
                        }
                        var ins = '';
                        for (let i = 0; i < response.dokumen_kunjungan.length; i++) {
                            var slug_dokumen = response.dokumen_kunjungan[i].nama_dokumen.replaceAll(' ', '_')
                                .toLowerCase();
                            var download = response.dokumen_kunjungan[i].status ? '<a target="_blank" href="./e_rekam_medis/' +
                                slug_dokumen + '/pdf?dokumen=' + response.dokumen_kunjungan[i].id +
                                '" class="btn btn-dark mr-1"><i class="fas fa-arrow-down"></i></a>' : '';
                            ins += '<tr>' +
                                '<td class="text-center">' + (i + 1) + '</td>' +
                                '<td>' + response.dokumen_kunjungan[i].nama_dokumen + '</td>' +
                                '<td>' + (response.dokumen_kunjungan[i].status ? 'Sudah diverifikasi' :
                                    'Belum diverifikasi') + '</td>' +
                                '<td>' + tanggal_dmy(response.dokumen_kunjungan[i].tanggal_update) + '</td>' +
                                '<td>' + response.dokumen_kunjungan[i].nama_verifikator + '</td>' +
                                '<td>' +
                                '<div style="display:flex; flex-direction:row;">'+
                            download +
                                '<a class="btn btn-primary" href="./e_rekam_medis/' + slug_dokumen + '?dokumen=' +
                                response.dokumen_kunjungan[i].id +
                                '" target="_blank"><i class="fas fa-eye"></i></a>' +
                                '</div>' +
                                '</td>' +
                                '</tr>';
                        }
                        $('#dokumen_kunjungan').html(dokumen_kunjungan(ins, response));
                    }
                })
            }

            function convert_slug(param) {
                if (param == '' || param == null) {
                    return '';
                }
                arr = param.split('_');
                for (var i = 0; i < arr.length; i++) {
                    arr[i] = arr[i].charAt(0).toUpperCase() + arr[i].slice(1);

                }
                return arr.join(' ');
            }

            function tanggal_dmyhi(tanggal) {
                if (tanggal == '' || tanggal == null) {
                    return '';
                }
                var tgl = tanggal.split(' ');
                var temp = tgl[0].split('-');
                var jam = tgl[1].split(':');
                return temp[2] + '-' + temp[1] + '-' + temp[0] + ' ' + jam[0] + ':' + jam[1];
            }

            function tanggal_dmy(tanggal) {
                if (tanggal == '' || tanggal == null) {
                    return '';
                }
                if (tanggal.includes(' ')) {
                    var tgl = tanggal.split(' ');
                    var temp = tgl[0].split('-');
                    var jam = tgl[1].split(':');
                    return temp[2] + '-' + temp[1] + '-' + temp[0];
                } else {
                    var temp = tanggal.split('-');
                    return temp[2] + '-' + temp[1] + '-' + temp[0];
                }
            }
        </script>
    @endpush
@endsection
