<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Pembedahan Kecil Operasi</title>

    <link rel="stylesheet" href="{{ asset('app-assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.7/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <!-- <link type="text/css" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/south-street/jquery-ui.css" rel="stylesheet"> -->
    <!-- <link rel="stylesheet" type="text/css" href="//keith-wood.name/css/jquery.signature.css"> -->
    <style>
        #data_diri tr th {
            vertical-align: top;
        }

        .main_table tr th {
            border: 2px solid;
            padding: 5px;
        }

        .main_table {
            width: 100%;
        }

        .main_table tr td {
            border: 2px solid;
            padding: 5px;
        }

        #list_diagnosa li {
            padding-bottom: 10px;
        }
    </style>
</head>

<body class="container">
    @if ($errors->any())
    @foreach ($errors->all() as $error)
    <div class="alert alert-danger">{{$error}}</div>
    @endforeach
    @endif
    @if(Session::get('sukses'))
    <script>
        alert('{{ Session::get("sukses") }}')
    </script>
    @endif
    @if(Session::get('gagal'))
    <script>
        alert('{{ Session::get("gagal") }}')
    </script>
    @endif

    <div class="modal fade" id="modal_verifikasi_operator" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Verifikasi Operator</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form onsubmit="return cek_verifikasi_operator()" action="{{ url('medical_record/e_rekam_medis/pembedahan_operasi_kecil/save') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" value="{{$dokumen->id}}" name="id_dokumen">
                        <input type="hidden" id="hide_keluhan_utama" name="keluhan_utama">
                        <input type="hidden" id="hide_rps" name="rps">
                        <input type="hidden" id="hide_rpd" name="rpd">
                        <input type="hidden" id="hide_id_operator" name="id_operator">
                        <input type="hidden" id="hide_operator" name="operator">
                        <input type="hidden" id="hide_id_asisten" name="id_asisten">
                        <input type="hidden" id="hide_asisten" name="asisten">
                        <input type="hidden" id="hide_tanggal_operasi" name="tanggal_operasi">
                        <input type="hidden" id="hide_mulai_jam" name="mulai_jam">
                        <input type="hidden" id="hide_selesai_jam" name="selesai_jam">
                        <input type="hidden" id="hide_teknik_operasi" name="teknik_operasi">
                        <input type="hidden" id="hide_jenis_anestesi" name="jenis_anestesi">
                        <input type="hidden" id="hide_jenis_sedatif" name="jenis_sedatif">
                        <input type="hidden" id="hide_uraian" name="uraian">
                        <div class="form-group">
                            <label for="">Passowrd</label>
                            <input type="password" name="pass" placeholder="Masukkan password anda" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Verifikasi</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_operator" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Pilih operator</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table table-striped" id="tabel_operator">
                        <thead>
                            <tr class="text-center">
                                <th>No</th>
                                <th>Nama</th>
                                <th>Jabatan</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_asisten" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Pilih asisten</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table class="table table-striped" id="tabel_asisten">
                        <thead>
                            <tr class="text-center">
                                <th>No</th>
                                <th>Nama</th>
                                <th>Jabatan</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_add_observasi" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Tambah Observasi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="">JAM/MENIT</label>
                        <input type="time" id="jam_menit" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">T</label>
                        <input type="text" id="t" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">N</label>
                        <input type="text" id="n" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">RR</label>
                        <input type="text" id="rr" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">S</label>
                        <input type="text" id="s" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">KETERANGAN</label>
                        <input type="text" id="keterangan" class="form-control">
                    </div>
                    <div id="msg_loading"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" onclick="save_observasi()" class="btn btn-success">Simpan</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_edit_observasi" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Ubah Observasi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="edit_id">
                    <div class="form-group">
                        <label for="">JAM/MENIT</label>
                        <input type="time" id="edit_jam_menit" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">T</label>
                        <input type="text" id="edit_t" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">N</label>
                        <input type="text" id="edit_n" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">RR</label>
                        <input type="text" id="edit_rr" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">S</label>
                        <input type="text" id="edit_s" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="">KETERANGAN</label>
                        <input type="text" id="edit_keterangan" class="form-control">
                    </div>
                    <div id="msg_ubah_loading"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" onclick="ubah_observasi()" class="btn btn-success">Simpan</button>
                </div>
            </div>
        </div>
    </div>

    <div class="row pt-3" style="width: 100%; margin-left: 0;">
        <div class="col-md-2 pl-0">
            {{-- <img src="{{ asset('filelogo/kotakihc.png') }}" alt="" style="width: 100%;"> --}}
        </div>
        <div class="col-md-8" style="text-align: center; padding-top:50px;">
            <h4 style="text-transform: uppercase;">KLINIK UTAMA DHARMAHUSADA PREMIER</h4>
        </div>
        <div class="col-md-2"></div>
        <div class="col-md-12">
            <table style="border-collapse: collapse; text-align: left; width:100%;">
                <tr>
                    <th>Alamat Kantor</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>Jl. Raya Dharma Husada Indah No.26 Surabaya</th>
                    <th style="padding-left: 30px;">E-mail</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>klinik.dharmahusadapremier@gmail.com</th>
                </tr>
                <tr>
                    <th>Telepon</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>(031)5921101</th>
                    <th style="padding-left: 30px;">Whatsapp</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>085233664118</th>
                </tr>
            </table>
        </div>
        <div class="col-md-12 mt-3" style="border:1px solid; border-width: 1px;">
        </div>
    </div>
    <div class="row pt-4 pb-3" style="width: 100%; margin-left: 0;">
        <div class="col-md-12">
            <h3 class="text-center">PENCATATAN LAPORAN OPERASI / PEMBEDAHAN</h3>
        </div>
    </div>
    <div class="row pb-5" style="width: 100%; margin-left: 0; border:2px solid;">
        <div class="col-md-12" style="border-bottom:2px solid; padding-bottom: 10px; padding-top:10px;">
            <div style="width:50%; float:left;">
                <table style="border-collapse: collapse;" id="data_diri">
                    <tr>
                        <th>NO. REG</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            {{ preg_replace("/[^0-9]/", "", $layanan->id )}}
                        </th>
                    </tr>
                    <tr>
                        <th>NAMA</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            {{$layanan->nama_pasien}}
                        </th>
                    </tr>
                    <tr>
                        <th>ALAMAT</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            {{ $pasien->alamat }}, {{ $pasien->nama_kelurahan }}, {{ $pasien->nama_kecamatan }}, {{ $pasien->nama_kabupaten }}
                        </th>
                    </tr>
                </table>
            </div>
            <div style="width:50%; float:left;">
                <table style="border-collapse: collapse;">
                    <tr>
                        <th>POLI</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            {{$layanan ? strtoupper(str_replace('_', ' ', $layanan->jenislayanan)) : ""}}
                        </th>
                    </tr>
                    <tr>
                        <th>LK / PR</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            {{$pasien->kelamin == 0 ?'Laki-Laki' : 'Perempuan'}}
                        </th>
                    </tr>
                    <tr>
                        <th>UMUR</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            <?php
                            $date = new DateTime($pasien->tgl_lahir);
                            $now = new DateTime();
                            $age = $now->diff($date);
                            echo $age->y . ' Tahun';
                            ?>
                        </th>
                    </tr>
                    <tr>
                        <th>DIAGNOSIS</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            {{ $layanan->diagnosa ? $layanan->diagnosa->kode_icd.'-'.$layanan->diagnosa->nama_icd : '' }}
                        </th>
                    </tr>
                </table>
            </div>
        </div>
        <table style="border-collapse: collapse;">
            <tr>
                <td colspan="3" style=" padding-left:15px; padding-top:10px; padding-bottom:10px;">KAJIAN PRE OP</td>
            </tr>
            <tr>
                <td style="vertical-align:top; padding-left:15px;">KELUHAN UTAMA</td>
                <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                <td style="padding-bottom: 15px;">
                    <textarea id="keluhan_utama" cols="120" class="form-control" style="width:100%" rows="5">{{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->keluhan_utama : '' }}</textarea>
                </td>
            </tr>
            <tr>
                <td style="vertical-align:top; padding-left:15px;">RPS</td>
                <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                <td style="padding-bottom: 15px;">
                    <textarea id="rps" cols="120" class="form-control" style="width:100%" rows=5">{{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->rps : '' }}</textarea>
                </td>
            </tr>
            <tr>
                <td style="vertical-align:top; padding-left:15px;">RPD</td>
                <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                <td style="padding-bottom: 15px;">
                    <textarea id="rpd" cols="120" class="form-control" style="width:100%" rows=5">{{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->rpd : '' }}</textarea>
                </td>
            </tr>
        </table>
        <div style="width: 100%; border:1px solid;"></div>
        <div style="width:50%; float:left;">
            <table style="border-collapse: collapse; margin-top:15px;">
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">OPERATOR</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        <div class="input-group">
                            <input type="hidden" value="{{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->id_operator : '' }}" id="id_operator">
                            <input type="text" value="{{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->operator : '' }}" readonly class="form-control" id="operator">
                            <div class="input-group-append">
                                <button class="btn btn-primary" onclick="open_modal_operator()" type="button"><i class="fa fa-list"></i></button>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">ASISTEN</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        <div class="input-group">
                            <input type="hidden" value="{{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->id_asisten : '' }}" id="id_asisten">
                            <input type="text" value="{{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->asisten : '' }}" readonly class="form-control" id="asisten">
                            <div class="input-group-append">
                                <button class="btn btn-primary" onclick="open_modal_asisten()" type="button"><i class="fa fa-list"></i></button>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">TANGGAL OPERASI</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        <input type="date" value="{{ $dokumen->pembedahan_operasi_kecil ? date('Y-m-d', strtotime($dokumen->pembedahan_operasi_kecil->tanggal_operasi)) : date('Y-m-d', strtotime($dokumen->created_at)) }}" id="tanggal_operasi" class="form-control">
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">MULAI JAM</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        <input type="time" value="{{ $dokumen->pembedahan_operasi_kecil ? date('H:i', strtotime($dokumen->pembedahan_operasi_kecil->mulai_jam)) : date('H:i', strtotime($dokumen->created_at)) }}" id="mulai_jam" class="form-control">
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">SELESAI JAM</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        <input type="time" value="{{ $dokumen->pembedahan_operasi_kecil ? date('H:i', strtotime($dokumen->pembedahan_operasi_kecil->selesai_jam)) : '' }}" id="selesai_jam" class="form-control">
                    </td>
                </tr>
            </table>
        </div>
        <div style="width:50%; float:left;">
            <table style="border-collapse: collapse; margin-top:15px;">
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">TEKNIK OPERASI</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        <input type="text" value="{{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->teknik_operasi : '' }}" id="teknik_operasi" class="form-control">
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">JENIS ANESTESI</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        <input type="text" id="jenis_anestesi" value="{{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->jenis_anestesi : '' }}" class="form-control">
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">JENIS SEDATIF</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        <input type="text" value="{{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->jenis_sedatif : '' }}" id="jenis_sedatif" class="form-control">
                    </td>
                </tr>
                <tr>
                    <td style="padding-left: 15px; vertical-align:top;">LAMA_OPERASI</td>
                    <td style="padding-left: 10px; vertical-align:top; padding-right: 10px;"> : </td>
                    <td style="padding-bottom: 15px;">
                        <?php
                        if (isset($dokumen->pembedahan_operasi_kecil)) {
                            $temp = (strtotime($dokumen->pembedahan_operasi_kecil->selesai_jam) - strtotime($dokumen->pembedahan_operasi_kecil->mulai_jam)) / 60;
                            $menit = fmod($temp, 60);
                            echo floor($temp / 60) . ' Jam ' . $menit . ' Menit';
                        }
                        ?>
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-md-12" style="border-top: 2px solid; border-bottom:2px solid">
            <h5 style="text-align: center; padding-top: 10px;">URAIAN OPERASI</h5>
        </div>
        <div class="col-md-12" style="padding-top: 10px; padding-bottom:15px;">
            <textarea id="uraian" placeholder="Tambahkan uraian operasi disini" cols="30" class="form-control" style="width: 100%;" rows="10">{{ $dokumen->pembedahan_operasi_kecil ? $dokumen->pembedahan_operasi_kecil->uraian : '' }}</textarea>
        </div>
        <div class="col-md-12" style="border-top: 2px solid;">
            <h5 style="text-align: center; padding-top: 10px;">OBSERVASI PASCA OPERASI</h5>
        </div>
        <table class="main_table">
            <thead>
                <tr style="text-align: center;">
                    <th>JAM/MENIT</th>
                    <th>T</th>
                    <th>N</th>
                    <th>RR</th>
                    <th>S</th>
                    <th>KETERANGAN</th>
                    <th>
                        <button class="btn btn-success" onclick="open_modal_add_observasi()" type="button"><i class="fa fa-plus"></i></button>
                    </th>
                </tr>
            </thead>
            <tbody id="list_observasi">
                @if(sizeof($dokumen->observasi_pasca_operasi) < 1) <tr style="text-align: center;">
                    <td colspan="7">Data tidak ditemukan.</td>
                    </tr>
                    @else
                    @foreach($dokumen->observasi_pasca_operasi as $opo)
                    <tr>
                        <td style="text-align: center;">{{$opo->jam_menit}}</td>
                        <td>{{$opo->t}}</td>
                        <td>{{$opo->n}}</td>
                        <td>{{$opo->rr}}</td>
                        <td>{{$opo->s}}</td>
                        <td>{{$opo->keterangan}}</td>
                        <td style="text-align: center;">
                            <button onclick="open_modal_edit_observasi('{{$opo->id}}')" class="btn btn-warning"><i class="fa fa-pencil" style="color: #fff;"></i></button>
                            <button onclick="hapus_observasi('{{$opo->id}}')" class="btn btn-danger"><i class="fa fa-trash" style="color: #fff;"></i></button>
                        </td>
                    </tr>
                    @endforeach
                    @endif
            </tbody>
        </table>
        <div class="row pt-5" style="width:100%;">
            <div class="col-lg-8">
                <p>&nbsp;</p>
            </div>
            <div class="col-lg-4 text-center">
                <p>TTD OPERATOR</p>
                @if($dokumen->status == 1)
                <img src="{{ env('SMIS_UPLOAD_URL').'/'.$dokumen->ttd }}" style="height: 2.5cm; width: 5cm;" alt="">
                <p>{{ $dokumen->nama_verifikator }}</p>
                @else
                <br>
                <br>
                <br>
                <br>
                <br>
                --------------------------------------------
                @endif
            </div>
        </div>
    </div>
    <div class="row pt-3 pb-3" style="width:100%; margin-left: 0;">
        <div class="col-md-3"></div>
        <div class="col-md-6" onclick="open_modal_verifikasi_operator()" style="padding: 10px;">
            <div style="border:1px solid; height:250px; display: flex; align-items:center; justify-content: center;">
                <h5>Operator</h5>
            </div>
        </div>
        <div class="col-md-3"></div>
    </div>
    <div class="row pb-5 pt-5" style="width:100%; margin-left:0;">
        <div style="text-align: center;" class="col-md-12">
            @if($dokumen->status != 0)
            <a href="{{ url('medical_record/e_rekam_medis/pembedahan_operasi_kecil/pdf?dokumen='.$dokumen->id) }}" class="btn btn-success" target="_blank">Download PDF</a>
            @endif
        </div>
    </div>
</body>
<script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script src="https://cdn.datatables.net/1.10.7/js/jquery.dataTables.min.js"></script>
<script src="{{ asset('app-assets/js/bootstrap.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
<script>
    function loading(param) {
        return '<div class="spinner-border spinner-border-sm mr-1" role="status">' +
            '<span class="sr-only">Loading...</span>' +
            '</div>' + param;
    }

    function get_operator(param) {
        $.ajax({
            url: "{{ url('ajax_request/employee') }}",
            data: {
                keyword: param
            },
            success: function(response) {
                console.log(response);
                if (response == null) {
                    $('#list_operator').html('<tr class="text-center"><td colspan="4">Data tidak ditemukan</td></tr>');
                    return;
                }
                var ins = '';
                for (let i = 0; i < response.length; i++) {
                    ins += '<tr>' +
                        '<td>' + (i + 1) + '</td>' +
                        '<td>' + response[i].nama + '</td>' +
                        '<td>' + response[i].nama_jabatan + '</td>' +
                        '<td><button class="btn btn-dark" onclick="set_operator(' + "'" + response[i].id + "','" + response[i].nama + "'" + ')"><i class="fa fa-check"></i></button></td>' +
                        '</tr>';
                }
                $('#list_operator').html(ins);
            }
        });
    }

    function get_asisten(param) {
        $.ajax({
            url: "{{ url('ajax_request/employee') }}",
            data: {
                keyword: param
            },
            success: function(response) {
                console.log(response);
                if (response == null) {
                    $('#list_asisten').html('<tr class="text-center"><td colspan="4">Data tidak ditemukan</td></tr>');
                    return;
                }
                var ins = '';
                for (let i = 0; i < response.length; i++) {
                    ins += '<tr>' +
                        '<td>' + (i + 1) + '</td>' +
                        '<td>' + response[i].nama + '</td>' +
                        '<td>' + response[i].nama_jabatan + '</td>' +
                        '<td><button class="btn btn-dark" onclick="set_asisten(' + "'" + response[i].id + "','" + response[i].nama + "'" + ')"><i class="fa fa-check"></i></button></td>' +
                        '</tr>';
                }
                $('#list_asisten').html(ins);
            }
        });
    }

    $('#tabel_operator').DataTable({
        processing: true,
        serverSide: true,
        ajax: '{{ url("ajax_request/employee") }}', // memanggil route yang menampilkan data json
        columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                data: 'id',
                name: 'id',
                render(data, type, row, meta) {
                    return '<p class="text-center">' + (meta.row + meta.settings._iDisplayStart + 1) + '</p>';
                }
            },
            {
                data: 'nama',
                name: 'nama'
            },
            {
                data: 'nama_jabatan',
                name: 'nama_jabatan',
                render(data, type, row) {
                    return '<p class="text-center">' + data + '</p>';
                }
            },
            {
                data: 'id',
                name: 'id',
                render(data, type, row) {
                    var fungsi_set = 'set_operator(' + "'" + data + "','" + row.nama + "'" + ')';
                    return '<div class="text-center"><button type="button" onclick="' + fungsi_set + '" class="btn btn-dark"><i class="fa fa-check"></i></button></div>';
                }
            }
        ]
    });

    $('#tabel_asisten').DataTable({
        processing: true,
        serverSide: true,
        ajax: '{{ url("ajax_request/employee") }}', // memanggil route yang menampilkan data json
        columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                data: 'id',
                name: 'id',
                render(data, type, row, meta) {
                    return '<p class="text-center">' + (meta.row + meta.settings._iDisplayStart + 1) + '</p>';
                }
            },
            {
                data: 'nama',
                name: 'nama'
            },
            {
                data: 'nama_jabatan',
                name: 'nama_jabatan',
                render(data, type, row) {
                    return '<p class="text-center">' + data + '</p>';
                }
            },
            {
                data: 'id',
                name: 'id',
                render(data, type, row) {
                    var fungsi_set = 'set_asisten(' + "'" + data + "','" + row.nama + "'" + ')';
                    return '<div class="text-center"><button type="button" onclick="' + fungsi_set + '" class="btn btn-dark"><i class="fa fa-check"></i></button></div>';
                }
            }
        ]
    });

    function set_operator(id, nama) {
        $('#id_operator').val(id);
        $('#operator').val(nama);
        $('#modal_operator').modal('hide');
    }

    function set_asisten(id, nama) {
        $('#id_asisten').val(id);
        $('#asisten').val(nama);
        $('#modal_asisten').modal('hide');
    }

    function search_operator() {
        window.event.preventDefault();
        $('#list_operator').html('<tr class="text-center"><td colspan="4">' + loading('Sedang mencari data...') + '</td></tr>');
        get_operator($('#key_operator').val());
    }

    function search_asisten() {
        window.event.preventDefault();
        $('#list_asisten').html('<tr class="text-center"><td colspan="4">' + loading('Sedang mencari data...') + '</td></tr>');
        get_asisten($('#key_asisten').val());
    }

    function open_modal_operator() {
        $('#modal_operator').modal('show');
    }

    function open_modal_asisten() {
        $('#modal_asisten').modal('show');
    }

    function open_modal_add_observasi() {
        $('#modal_add_observasi').modal('show');
    }

    function open_modal_edit_observasi(param) {
        $.ajax({
            url: "{{ url('ajax_request/observasi_pasca_operasi/select') }}",
            data: {
                id: param
            },
            success: function(response) {
                if (response == null) {
                    return;
                }
                $('#edit_id').val(response.id);
                $('#edit_jam_menit').val(response.jam_menit);
                $('#edit_t').val(response.t);
                $('#edit_n').val(response.n);
                $('#edit_rr').val(response.rr);
                $('#edit_s').val(response.s);
                $('#edit_keterangan').val(response.keterangan);
                $('#modal_edit_observasi').modal('show');
            }
        });
    }

    function save_observasi() {
        if ($('#jam_menit').val() == '') {
            alert('Jam menit harus diisi');
            return
        }
        if ($('#t').val() == '') {
            alert('T harus diisi');
            return
        }
        if ($('#n').val() == '') {
            alert('N harus diisi');
            return
        }
        if ($('#rr').val() == '') {
            alert('RR harus diisi');
            return
        }
        if ($('#s').val() == '') {
            alert('S harus diisi');
            return
        }
        if ($('#keterangan').val() == '') {
            alert('Keterangan harus diisi');
            return
        }
        $('#msg_loading').html('<div class="alert alert-info">' + loading('Sedang menyimpan data...') + '</div>');
        $.ajax({
            url: '{{ url("ajax_request/observasi_pasca_operasi/create") }}',
            method: 'post',
            data: {
                '_token': '{{ csrf_token() }}',
                'dokumen': '{{ $dokumen->id }}',
                'jam_menit': $('#jam_menit').val(),
                't': $('#t').val(),
                'n': $('#n').val(),
                'rr': $('#rr').val(),
                's': $('#s').val(),
                'keterangan': $('#keterangan').val(),
            },
            success: function(response) {
                $('#msg_loading').html('');
                alert(response.message);
                if (response.status) {
                    $('#modal_add_observasi').modal('hide');
                }
                render_observasi();
            },
            error: function(err) {
                if (err.status == 422) { // when status code is 422, it's a validation issue
                    console.log(err.responseJSON);
                    var pesan_error = '';
                    pesan_error = err.responseJSON.errors.jam_menit ? err.responseJSON.errors.jam_menit[0] : pesan_error;
                    pesan_error = err.responseJSON.errors.t ? err.responseJSON.errors.t[0] : pesan_error;
                    pesan_error = err.responseJSON.errors.n ? err.responseJSON.errors.n[0] : pesan_error;
                    pesan_error = err.responseJSON.errors.rr ? err.responseJSON.errors.rr[0] : pesan_error;
                    pesan_error = err.responseJSON.errors.s ? err.responseJSON.errors.s[0] : pesan_error;
                    pesan_error = err.responseJSON.errors.keterangan ? err.responseJSON.errors.keterangan[0] : pesan_error;
                    $('#msg_loading').html('<div class="alert alert-danger">' + pesan_error + '</div>');
                }
            }
        })
    }

    function hapus_observasi(param) {
        if (!confirm('Yakin melanjutkan hapus observasai ? data yang dihapus tidak dapat dikembalikan')) {
            return;
        }

        $.ajax({
            url: "{{ url('ajax_request/observasi_pasca_operasi/delete') }}",
            data: {
                id: param
            },
            success: function(response) {
                alert(response)
                render_observasi();
            }
        });
    }

    function render_observasi() {
        $('#list_observasi').html('<tr class="text-center"><td colspan="7">' + loading('Sedang mengambil data...') + '</td></tr>');
        $.ajax({
            url: "{{ url('ajax_request/observasi_pasca_operasi') }}",
            data: {
                dokumen: "{{ $dokumen->id }}"
            },
            success: function(response) {
                if (!response.status) {
                    $('#list_observasi').html('<tr class="text-center"><td colspan="7">' + response.message + '</td></tr>');
                    return;
                }

                if (response.data.length < 1) {
                    $('#list_observasi').html('<tr class="text-center"><td colspan="7">Data tidak ditemukan.</td></tr>');
                    return;
                }
                var ins = '';
                for (let i = 0; i < response.data.length; i++) {
                    ins += '<tr>' +
                        '<td class="text-center">' + response.data[i].jam_menit + '</td>' +
                        '<td>' + response.data[i].t + '</td>' +
                        '<td>' + response.data[i].n + '</td>' +
                        '<td>' + response.data[i].rr + '</td>' +
                        '<td>' + response.data[i].s + '</td>' +
                        '<td>' + response.data[i].keterangan + '</td>' +
                        '<td style="text-align:center">' +
                        '<button class="btn btn-warning mr-1" onclick="open_modal_edit_observasi(' + "'" + response.data[i].id + "'" + ')"><i class="fa fa-pencil" style="color: #fff;"></i></button>' +
                        '<button onclick="hapus_observasi(' + "'" + response.data[i].id + "'" + ')" class="btn btn-danger"><i class="fa fa-trash" style="color: #fff;"></i></button>' +
                        '</td>' +
                        '</tr>';
                }
                $('#list_observasi').html(ins);
            }
        })
    }

    function ubah_observasi() {
        if ($('#edit_jam_menit').val() == '') {
            alert('Jam menit harus diisi');
            return
        }
        if ($('#edit_t').val() == '') {
            alert('T harus diisi');
            return
        }
        if ($('#edit_n').val() == '') {
            alert('N harus diisi');
            return
        }
        if ($('#edit_rr').val() == '') {
            alert('RR harus diisi');
            return
        }
        if ($('#edit_s').val() == '') {
            alert('S harus diisi');
            return
        }
        if ($('#edit_keterangan').val() == '') {
            alert('Keterangan harus diisi');
            return
        }
        $('#msg_ubah_loading').html('<div class="alert alert-info">' + loading('Sedang menyimpan data...') + '</div>');
        $.ajax({
            url: '{{ url("ajax_request/observasi_pasca_operasi/update") }}',
            method: 'post',
            data: {
                '_token': '{{ csrf_token() }}',
                '_method': 'put',
                'id': $('#edit_id').val(),
                'jam_menit': $('#edit_jam_menit').val(),
                't': $('#edit_t').val(),
                'n': $('#edit_n').val(),
                'rr': $('#edit_rr').val(),
                's': $('#edit_s').val(),
                'keterangan': $('#edit_keterangan').val(),
            },
            success: function(response) {
                $('#msg_ubah_loading').html('');
                alert(response.message);
                if (response.status) {
                    $('#modal_edit_observasi').modal('hide');
                }
                render_observasi();
            },
            error: function(err) {
                if (err.status == 422) { // when status code is 422, it's a validation issue
                    console.log(err.responseJSON);
                    var pesan_error = '';
                    pesan_error = err.responseJSON.errors.jam_menit ? err.responseJSON.errors.jam_menit[0] : pesan_error;
                    pesan_error = err.responseJSON.errors.t ? err.responseJSON.errors.t[0] : pesan_error;
                    pesan_error = err.responseJSON.errors.n ? err.responseJSON.errors.n[0] : pesan_error;
                    pesan_error = err.responseJSON.errors.rr ? err.responseJSON.errors.rr[0] : pesan_error;
                    pesan_error = err.responseJSON.errors.s ? err.responseJSON.errors.s[0] : pesan_error;
                    pesan_error = err.responseJSON.errors.keterangan ? err.responseJSON.errors.keterangan[0] : pesan_error;
                    $('#msg_ubah_loading').html('<div class="alert alert-danger">' + pesan_error + '</div>');
                }
            }
        })
    }

    function open_modal_verifikasi_operator() {
        $('#modal_verifikasi_operator').modal('show');
    }

    function cek_verifikasi_operator() {
        $('#hide_keluhan_utama').val($('#keluhan_utama').val());
        $('#hide_rps').val($('#rps').val());
        $('#hide_rpd').val($('#rpd').val());
        $('#hide_id_operator').val($('#id_operator').val());
        $('#hide_operator').val($('#operator').val());
        $('#hide_id_asisten').val($('#id_asisten').val());
        $('#hide_asisten').val($('#asisten').val());
        $('#hide_tanggal_operasi').val($('#tanggal_operasi').val());
        $('#hide_mulai_jam').val($('#mulai_jam').val());
        $('#hide_selesai_jam').val($('#selesai_jam').val());
        $('#hide_teknik_operasi').val($('#teknik_operasi').val());
        $('#hide_jenis_anestesi').val($('#jenis_anestesi').val());
        $('#hide_jenis_sedatif').val($('#jenis_sedatif').val());
        $('#hide_uraian').val($('#uraian').val());
        if (!confirm('Yakin melanjutkan verifikasi dokumen ?')) {
            return false;
        }
    }
</script>

</html>