<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Surat Keterangan Sakit</title>
    <style>
        #identitas,
        tr,
        th {
            text-align: left;
        }

        #identitas {
            border-collapse: collapse;
            width: 100%;
        }

        * {
            font-family: sans-serif;
        }
    </style>
</head>

<body>
    <div class="row pt-3 pb-3" style="width: 100%; margin-left: 0;">
        <div style="text-align: center; width:100%; display: flex; flex-direction: row; justify-content: center">
            <img src="{{ asset('filelogo/logo_new.png') }}" alt="" style="width: 15%; position: absolute">
            <p>
                <span style="text-transform: uppercase; font-weight:bold; font-size: 25px">KLINIK UTAMA DHARMAHUSADA
                    PREMIER</span><br>
                Jl. Raya Dharma Husada Indah No.26, Mojo, Kec. Gubeng, Surabaya<br>
                No. Telp : (031)5921101 | Whatsapp : 0852-3366-4118<br>
                Email: klinik.dharmahusadapremier@gmail.com | Website:dhpclinic.id
            </p>
        </div>
        <div class="col-md-12 mt-3" style="border:1px solid; border-width: 1px;">
        </div>
        <div class="col-md-12 pt-3">
            <h4 style="text-decoration: underline; text-align: center">Surat Keterangan Sakit</h4>
            <p style="text-align: center">{{ $nomor_surat }}</p>
        </div>
        <div class="col-md-12 pt-3">
            <p>Yang bertanda tangan dibawah ini, menerangkan bahwa : </p>
            <table id="identitas">
                <tr>
                    <th style="width: 30%">Nama</th>
                    <th style="width: 5%"> : </th>
                    <th style="width: 65%">{{ $pasien->nama }}</th>
                </tr>
                <tr>
                    <th>Tempat / Tanggal Lahir</th>
                    <th> : </th>
                    <th>{{ $pasien->tempat_lahir . ' / ' . date('d-m-Y', strtotime($pasien->tgl_lahir)) }}</th>
                </tr>
                <tr>
                    <th>Umur</th>
                    <th> : </th>
                    <th>{{ $pasien->umur . ' Tahun' }}</th>
                </tr>
                <tr>
                    <th>Jenis Kelamin</th>
                    <th> : </th>
                    <th>{{ $pasien->kelamin ? 'Perempuan' : 'Laki-Laki' }}</th>
                </tr>
                <tr>
                    <th>Alamat</th>
                    <th> : </th>
                    <th>{{ $pasien->alamat }}</th>
                </tr>
                <tr>
                    <th>Pekerjaan</th>
                    <th> : </th>
                    <th>
                        {{ $dokumen->surat_keterangan_sakit ? $dokumen->surat_keterangan_sakit->pekerjaan : '' }}
                    </th>
                </tr>
                <tr>
                    <th>Diagnosa</th>
                    <th> : </th>
                    <th>
                        {{ $dokumen->surat_keterangan_sakit ? $dokumen->surat_keterangan_sakit->diagnosa : '' }}
                    </th>
                </tr>
            </table>
            <div class="pt-3">
                <p>Oleh karena S A K I T, perlu diberikan I S T I R A H A T selama
                    {{ $dokumen->surat_keterangan_sakit ? $dokumen->surat_keterangan_sakit->hari : '' }}
                    hari</p>
                <p>terhitung mulai tanggal
                    {{ $dokumen->surat_keterangan_sakit ? date('d-m-Y', strtotime($dokumen->surat_keterangan_sakit->dari_tanggal)) : '' }}
                    s/d
                    {{ $dokumen->surat_keterangan_sakit ? date('d-m-Y', strtotime($dokumen->surat_keterangan_sakit->sampai_tanggal)) : '' }}
                </p>
                <p>Demikian surat keterangan ini dibuat dengan sebenarnya dan untuk digunakan semestinya.</p>
            </div>
        </div>
        <div style="width:75%; float:left;"></div>
        <div style="width:25%; float:left; text-align:center; padding-top:60px;">
            <?php
            switch (date('m')) {
                case '01':
                    echo date('d') . ' Januari ' . date('Y');
                    break;
                case '02':
                    echo date('d') . ' Februari ' . date('Y');
                    break;
                case '03':
                    echo date('d') . ' Maret ' . date('Y');
                    break;
                case '04':
                    echo date('d') . ' April ' . date('Y');
                    break;
                case '05':
                    echo date('d') . ' Mei ' . date('Y');
                    break;
                case '06':
                    echo date('d') . ' Juni ' . date('Y');
                    break;
                case '07':
                    echo date('d') . ' Juli ' . date('Y');
                    break;
                case '08':
                    echo date('d') . ' Agustus ' . date('Y');
                    break;
                case '09':
                    echo date('d') . ' September ' . date('Y');
                    break;
                case '10':
                    echo date('d') . ' Oktober ' . date('Y');
                    break;
                case '11':
                    echo date('d') . ' November ' . date('Y');
                    break;
                case '12':
                    echo date('d') . ' Desember ' . date('Y');
                    break;
            
                default:
                    echo '';
                    break;
            }
            ?>
            <br>
            Dokter yang memeriksa
            <a href="#" onclick="open_modal_verifikasi('{{ $dokumen->id }}')"
                style="width:100%; display: flex; justify-content: center; align-items: center; text-decoration: none; color:#111;">
                <img src="{{ env('SMIS_UPLOAD_URL') . '/' . $dokumen->ttd }}" style="height: 2.5cm; width: 5cm;"
                    alt="">
            </a>
            {{ $dokumen->nama_verifikator }}
        </div>
    </div>
</body>

</html>
