<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Pengkajian Awal Medis</title>
    <style>
        * {
            font-size: 12px;
        }

        .pagebreak {
            page-break-after: always;
        }

        /* Clear floats after the columns */
        .row:after {
            content: "";
            display: table;
            clear: both;
        }

        ul {
            list-style: none;
        }

        #tabel_diagnosa tr td{
            border: 1px solid transparent;
            font-size: 12px;
            vertical-align: top;
        }

        .table-bordered {
            border: 1px solid
        }

        .table-bordered td,
        .table-bordered th {
            border: 1px solid
        }

        .table-bordered thead td,
        .table-bordered thead th {
            border-bottom-width: 1px
        }

        .col-md-1 {
            width: 8%;
            float: left;
        }

        .col-md-2 {
            width: 16%;
            float: left;
        }

        .col-md-3 {
            width: 25%;
            float: left;
        }

        .col-md-4 {
            width: 33%;
            float: left;
        }

        .col-md-5 {
            width: 42%;
            float: left;
        }

        .col-md-6 {
            width: 50%;
            float: left;
        }

        .col-md-7 {
            width: 58%;
            float: left;
        }

        .col-md-8 {
            width: 66%;
            float: left;
        }

        .col-md-9 {
            width: 75%;
            float: left;
        }

        .col-md-10 {
            width: 83%;
            float: left;
        }

        .col-md-11 {
            width: 92%;
            float: left;
        }

        .col-md-12 {
            width: 100%;
            float: left;
        }

        #tabel_anamnesa_umum tr td {
            line-height: 2;
            vertical-align: top;
        }

        #tabel_data_umum tr td {
            padding-top: 10px;
            padding-bottom: 10px;
        }

        #tabel_pemeriksaan_fisik tr {
            vertical-align: top;
        }

        #tabel_pemeriksaan_fisik tr td {
            padding-bottom: 15px;
        }

        #tabel_lokalis tr td {
            border: 1px solid;
        }
    </style>
</head>

<body>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-3">
            <img src="{{ asset('filelogo/logo_new.png') }}" alt="" style="width: 100%; margin-top: -20px;">
        </div>
        <div class="col-md-4">
            <div style="display: flex; flex-direction: row;">
                <hr style="width: 40px; border:1px solid #111; margin-top: 18px; position: absolute; left: 5;">
                <span style="font-size: 20px; position: relative; left:45; top:5;">Klinik Utama</span>
                <hr
                    style="width: 40px; border:1px solid #111; margin-top: 18px; position: relative; right: -65; top:-17;">
            </div>
            <div>
                <p style="width: 100%; font-size: 20px; text-align: center; margin-top: -10px; font-weight:bold;">
                    Dharmahusada Premier
                </p>
                <p style="width: 100%; text-align: center; font-size: 10.3px; margin-top: -20px;">
                    Jl. Raya Dharmahusada Indah No. 26, Mojo,<br>Kec. Gubeng, Kota Surabaya, Jawa Timur, 60285.<br>
                    Telp : (031) 5921101 | 0851 3366 4118<br>
                    Email : klinik.dharmahusadaoremier@gmail.com
                </p>
            </div>
        </div>
        <div class="col-md-5" style="text-align: center;">
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-12 mt-3" style="border:1px solid; border-width: 1px;">
            <p style="text-align: center; font-weight:bold; padding-top: 7px;">
                PENGKAJIAN AWAL MEDIS
            </p>
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-12 pl-0">
            <p>
                Tanggal / Pukul :
                {{ $dokumen->pengkajian_awal_medis ? date('d-m-Y', strtotime($dokumen->pengkajian_awal_medis->tanggal)) : '' }}
                /
                {{ $dokumen->pengkajian_awal_medis ? date('H:i', strtotime($dokumen->pengkajian_awal_medis->tanggal)) : '' }}
            </p>
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-12">
            <p>
                <span style="font-weight: bold">I. ANAMNESA UMUM</span>
                <input style="margin-left: 30px"
                    {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->anamnesa_umum == 'autoanamnesa' ? 'checked' : '') : '' }}
                    type="checkbox" value="autoanamnesa" name="anamnesa_umum1" id="autoanamnesa" required> Autoanamnesa
                <input style="margin-left: 40px" name="anamnesa_umum2"
                    {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->anamnesa_umum == 'alloanamnesa' ? 'checked' : '') : '' }}
                    type="checkbox" value="alloanamnesa" id="alloanamnesa">
                Alloanamnesa diperoleh dari :
                {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->diperoleh_dari : '' }}
            </p>
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-12">
            <table id="tabel_anamnesa_umum" style="border-collapse: collapse; width: 100%;">
                <tr>
                    <td style="width: 3%">1. </td>
                    <td>Keluhan Utama :</td>
                </tr>
                <tr>
                    <td></td>
                    <td>{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->keluhan_utama : '' }}</td>
                </tr>
                <tr>
                    <td style="width: 3%">2. </td>
                    <td>Riwayat Penyakit Sekarang :</td>
                </tr>
                <tr>
                    <td></td>
                    <td>{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->riwayat_penyakit_sekarang : '' }}
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">3. </td>
                    <td>Riwayat Penyakit Dahulu :</td>
                </tr>
                <tr>
                    <td></td>
                    <td>{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->riwayat_penyakit_dahulu : '' }}
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">4. </td>
                    <td>Riwayat Obat-obatan Terdahulu :</td>
                </tr>
                <tr>
                    <td></td>
                    <td>{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->riwayat_obat_obatan : '' }}
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">5. </td>
                    <td>Riwayat Kebiasaan dan Pekerjaan :</td>
                </tr>
                <tr>
                    <td></td>
                    <td>{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->riwayat_kebiasaan_pekerjaan : '' }}
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">6. </td>
                    <td>Riwayat Alergi Obat / Makanan :</td>
                </tr>
                <tr>
                    <td></td>
                    <td>{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->riwayat_alergi_obat : '' }}
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">7. </td>
                    <td>Masalah Kejiwaan : Adakah masalah mental seperti kurang semangat, rasa tertekan, depresi, sulit
                        tidur, lekas lelah, kurang nafsu makan,
                        merasa bersalah, sulit konsentrasi, sulit berbicara, menggunakan obat penenang dan ada keinginan
                        bunuh diri ?</td>
                </tr>
                <tr>
                    <td></td>
                    <td>{{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->masalah_kejiwaan == '1' ? 'Ya' : 'Tidak') : '' }}
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-12">
            <p>
                <span style="font-weight: bold">II. Data Umum</span>
            </p>
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-12">
            <table id="tabel_data_umum" style="border-collapse: collapse; width:100%">
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top;">1.</td>
                    <td style="width: 14%; vertical-align: top;">Keadaan umum</td>
                    <td style="width: 3%; vertical-align: top;"> : </td>
                    <td style="width: 81%; vertical-align: top;">
                        <input style="margin-left: 20px"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->keadaan_umum == 'sakit_ringan' ? 'checked' : '') : '' }}
                            type="checkbox" name="keadaan_umum" value="sakit_ringan" required>
                        Sakit Ringan
                        <input style="margin-left: 20px"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->keadaan_umum == 'sakit_sedang' ? 'checked' : '') : '' }}
                            type="checkbox" name="keadaan_umum" value="sakit_sedang">
                        Sakit Sedang
                        <input style="margin-left: 20px"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->keadaan_umum == 'sakit_berat' ? 'checked' : '') : '' }}
                            type="checkbox" name="keadaan_umum" value="sakit_berat">
                        Sakit Berat
                    </td>
                </tr>
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top;">2.</td>
                    <td style="width: 14%; vertical-align: top;">Kesadaran</td>
                    <td style="width: 3%; vertical-align: top;"> : </td>
                    <td style="width: 81%; vertical-align: top;">
                        GCS : E : {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->gcs_e : '' }}
                        M : {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->gcs_m : '' }}
                        V : {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->gcs_v : '' }}
                        Total : {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->gcs_total : '' }}
                    </td>
                </tr>
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top;">3.</td>
                    <td style="width: 14%; vertical-align: top;">Tanda vital</td>
                    <td style="width: 3%; vertical-align: top;"> : </td>
                    <td style="width: 81%; vertical-align: top;">
                        Tekanan darah : ............../.............mmHg; Suhu : ..............°C
                    </td>
                </tr>
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top;"></td>
                    <td style="width: 14%; vertical-align: top; padding-left: 20px;">Nadi</td>
                    <td style="width: 3%; vertical-align: top;"> : </td>
                    <td style="width: 81%; vertical-align: top;">
                        .............. x/mnt;
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->nadi == 'reguler' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="checkbox" name="nadi" value="reguler" required>
                        Reguler
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->nadi == 'irreguler' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="checkbox" name="nadi" value="irreguler"> Irreguler
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->nadi == 'pulsus_defisit' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="checkbox" name="nadi" value="pulsus_defisit">
                        Pulsus Defisit
                    </td>
                </tr>
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top;"></td>
                    <td style="width: 14%; vertical-align: top; padding-left: 20px;">Pernafasan</td>
                    <td style="width: 3%; vertical-align: top;"> : </td>
                    <td style="width: 81%; vertical-align: top;">
                        .............. x/mnt;
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->pernafasan == 'reguler' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="checkbox" name="pernafasan" value="reguler" required>
                        Reguler
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->pernafasan == 'kussmaul' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="checkbox" name="pernafasan" value="kussmaul">
                        Kussmaul
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->pernafasan == 'chyene_stokes' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="checkbox" name="pernafasan" value="chyene_stokes">
                        Chyene-Stokes
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->pernafasan == 'lain_lain' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="checkbox" name="pernafasan" value="lain_lain"> Lain
                        lain :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->pernafasan_lain : '' }}
                    </td>
                </tr>
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top; "></td>
                    <td style="width: 14%; vertical-align: top;  padding-left: 20px;">Nyeri</td>
                    <td style="width: 3%; vertical-align: top; "> : </td>
                    <td style="width: 81%; vertical-align: top; ">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->nyeri == '0' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="checkbox" name="nyeri" value="0" required>
                        Tidak Ada
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->nyeri == '1' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="checkbox" name="nyeri" value="1"> Ada, Lokasi
                        : {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->lokasi_nyeri : '' }}
                        Skala Nyeri :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->skala_nyeri : '' }}
                        (1-10)
                    </td>
                </tr>
                <tr style="line-height: 1.5">
                    <td style="width: 2%; vertical-align: top; "></td>
                    <td style="width: 14%; vertical-align: top;  padding-left: 20px;">Jenis</td>
                    <td style="width: 3%; vertical-align: top; "> : </td>
                    <td style="width: 81%; vertical-align: top; ">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jenis == 'nosiseptik' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="checkbox" name="jenis" value="nosiseptik" required>
                        Nosiseptik
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jenis == 'neuropatik' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="checkbox" name="jenis" value="neuropatik">
                        Neuropatik
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jenis == 'kombinasi' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="checkbox" name="jenis" value="kombinasi"> Kombinasi
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jenis == 'lain_lain' ? 'checked' : '') : '' }}
                            style="margin-left: 20px;" type="checkbox" name="jenis" value="lain_lain"> Lain-lain :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->jenis_lain : '' }}
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="pagebreak"></div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-12">
            <p>
                <span style="font-weight: bold">III. Pemeriksaan Fisik : </span>
            </p>
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-12">
            <table style="border-collapse: collapse; width: 100%;" id="tabel_pemeriksaan_fisik">
                <tr>
                    <td style="width: 3%">1.</td>
                    <td style="width: 25%">Kepala</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->kepala == 'normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="kepala" value="normal" id="kepala" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->kepala == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="kepala" value="tidak_normal" id="kepala"> Tidak Normal,
                        Jelaskan :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_kepala : '' }}
                    </td>
                </tr>
                <tr>
                    <td style="width: 3%">2.</td>
                    <td style="width: 25%">Mata</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->mata == 'normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="mata" value="normal" id="mata" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->mata == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="mata" value="tidak_normal" id="mata"> Tidak Normal,
                        Jelaskan :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_mata : '' }}
                </tr>
                <tr>
                    <td style="width: 3%">3.</td>
                    <td style="width: 25%">THT</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->tht == 'normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="tht" value="normal" id="tht" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->tht == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="tht" value="tidak_normal" id="tht"> Tidak Normal,
                        Jelaskan : {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_tht : '' }}
                </tr>
                <tr>
                    <td style="width: 3%">4.</td>
                    <td style="width: 25%">Leher</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->leher == 'normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="leher" value="normal" id="leher" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->leher == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="leher" value="tidak_normal" id="leher"> Tidak Normal,
                        Jelaskan :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_leher : '' }}
                </tr>
                <tr>
                    <td style="width: 3%">5.</td>
                    <td style="width: 25%">Mulut</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->mulut == 'normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="mulut" value="normal" id="mulut" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->mulut == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="mulut" value="tidak_normal" id="mulut"> Tidak Normal,
                        Jelaskan :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_mulut : '' }}
                </tr>
                <tr>
                    <td style="width: 3%">6.</td>
                    <td style="width: 25%">Jantung dan Pembuluh Darah</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jantung == 'normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="jantung" value="normal" id="jantung" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->jantung == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="jantung" value="tidak_normal" id="jantung"> Tidak Normal,
                        Jelaskan :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_jantung : '' }}
                </tr>
                <tr>
                    <td style="width: 3%">7.</td>
                    <td style="width: 25%">Thoraks, Paru-paru dan Payudara</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->thoraks == 'normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="thoraks" value="normal" id="thoraks" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->thoraks == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="thoraks" value="tidak_normal" id="thoraks"> Tidak Normal,
                        Jelaskan :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_thoraks : '' }}
                </tr>
                <tr>
                    <td style="width: 3%">8.</td>
                    <td style="width: 25%">Abdomen</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->abdomen == 'normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="abdomen" value="normal" id="abdomen" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->abdomen == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="abdomen" value="tidak_normal" id="abdomen"> Tidak Normal,
                        Jelaskan :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_abdomen : '' }}
                </tr>
                <tr>
                    <td style="width: 3%">9.</td>
                    <td style="width: 25%">Kulit dan Sistem Limfatik</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->kulit == 'normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="kulit" value="normal" id="kulit" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->kulit == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="kulit" value="tidak_normal" id="kulit"> Tidak Normal,
                        Jelaskan :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_kulit : '' }}
                </tr>
                <tr>
                    <td style="width: 3%">10.</td>
                    <td style="width: 25%">Tulang Belakang dan Anggota Tubuh</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->tulang == 'normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="tulang" value="normal" id="tulang" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->tulang == 'tidak_normal' ? 'checked' : '') : '' }}
                            type="checkbox" name="tulang" value="tidak_normal" id="tulang"> Tidak Normal,
                        Jelaskan :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_tulang : '' }}
                </tr>
                <tr>
                    <td style="width: 3%">11.</td>
                    <td style="width: 25%">Sistem Saraf</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input type="checkbox"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->saraf == 'normal' ? 'checked' : '') : '' }}
                            name="saraf" value="normal" id="saraf" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input type="checkbox"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->saraf == 'tidak_normal' ? 'checked' : '') : '' }}
                            name="saraf" value="tidak_normal" id="saraf"> Tidak Normal,
                        Jelaskan :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_saraf : '' }}
                </tr>
                <tr>
                    <td style="width: 3%">12.</td>
                    <td style="width: 25%">Genitalia, anus dan rektum</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input type="checkbox"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->genitalia == 'normal' ? 'checked' : '') : '' }}
                            name="genitalia" value="normal" id="genitalia" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input type="checkbox"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->genitalia == 'tidak_normal' ? 'checked' : '') : '' }}
                            name="genitalia" value="tidak_normal" id="genitalia"> Tidak Normal,
                        Jelaskan :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_genitalia : '' }}
                </tr>
                <tr>
                    <td style="width: 3%">13.</td>
                    <td style="width: 25%">Ekstremitas</td>
                    <td style="width: 3%"> : </td>
                    <td style="width: 10%">
                        <input type="checkbox"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->ekstremitas == 'normal' ? 'checked' : '') : '' }}
                            name="ekstremitas" value="normal" id="ekstremitas" required> Normal
                    </td>
                    <td style="width: 59%">
                        <input type="checkbox"
                            {{ $dokumen->pengkajian_awal_medis ? ($dokumen->pengkajian_awal_medis->ekstremitas == 'tidak_normal' ? 'checked' : '') : '' }}
                            name="ekstremitas" value="tidak_normal" id="ekstremitas"> Tidak
                        Normal, Jelaskan :
                        {{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->tn_ekstremitas : '' }}
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-12">
            <table style="border-collapse: collapse; width:100%;" id="tabel_lokalis">
                <tr>
                    <td style="width: 35%; text-align:center; padding:10px; vertical-align:top;">
                        @if ($dokumen->pengkajian_awal_medis)
                            @if ($dokumen->pengkajian_awal_medis->gambar_status_lokalis != '')
                                <div
                                    style="background-repeat: no-repeat; width: 100%; background-image: url('{{ asset('images/status_lokalis.jpg') }}')">
                                    <img style="position: relative; top:0px; opacity: 0.5;"
                                    src="{{ asset('status_lokalis/' . $dokumen->pengkajian_awal_medis->gambar_status_lokalis) }}"
                                    alt="">
                                </div>
                                <!-- <img style="position: relative; border:1px solid; top:0px; left:0px; opacity: 0.5;"
                                    src="{{ asset('status_lokalis/' . $dokumen->pengkajian_awal_medis->gambar_status_lokalis) }}"
                                    alt="">
                                <img style="position: relative; top:-200px; z-index: -1; border:1px solid; width:100%"
                                    src="{{ asset('images/status_lokalis.jpg') }}" alt=""> -->
                                <p>Gambar lokasi</p>
                            @else
                                <img style="position: relative; top:0px; z-index: -1;"
                                    src="{{ asset('images/status_lokalis.jpg') }}" alt="">
                                <p style="position:relative; top:0px;">Gambar lokasi</p>
                            @endif
                        @endif
                    </td>
                    <td style="width: 75%; padding:10px; vertical-align: top">
                        <p>III. STATUS LOKALIS : </p>
                        <p>{{ $dokumen->pengkajian_awal_medis ? $dokumen->pengkajian_awal_medis->status_lokalis : '' }}
                        </p>
                        <p style="padding-top: 15px;">
                            IV. PEMERIKSAAN PENUNJANG :
                            @if ($dokumen->pesanan_lab)
                                @foreach ($dokumen->pesanan_lab as $pl)
                                    @php
                                        $iterasi_pesanan_lab = 0;
                                        $pesan = '';
                                    @endphp
                                    <?php $yang_dipesan = json_decode($pl->periksa); ?>
                                    @foreach ($pemeriksaan as $pem)
                                        @php
                                            $temp_slug = $pem->slug;
                                        @endphp
                                        @if ($yang_dipesan->$temp_slug == 1)
                                            @if ($iterasi_pesanan_lab > 0)
                                                @php
                                                    $pesan .= ', ' . $pem->nama;
                                                @endphp
                                            @else
                                                @php
                                                    $pesan .= $pem->nama;
                                                @endphp
                                            @endif
                                            @php
                                                $iterasi_pesanan_lab++;
                                            @endphp
                                        @endif
                                    @endforeach
                                    {{ $pl->no_lab }} - {{ $pesan }}
                                @endforeach
                            @endif
                        </p>
                        <table style="border-collapse: collapse" id="tabel_diagnosa">
                            <tr>
                                <td>V.</td>
                                <td>Diagnosa</td>
                                <td> : </td>
                                <td>
                                    {{ $layanan->diagnosa ? $layanan->diagnosa->kode_icd . ' - ' . $layanan->diagnosa->nama_icd : '' }}
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>
                                    <?php
                                    if ($layanan->diagnosa != null) {
                                        $temp = '';
                                        if ($layanan->diagnosa->diagnosa_sekunder1 != null) {
                                            $temp .= ($kode_sekunder1 ? $kode_sekunder1->icd : '') . ' - ' . $layanan->diagnosa->diagnosa_sekunder1;
                                        }
                                        if ($layanan->diagnosa->diagnosa_sekunder2 != null) {
                                            $temp .= '<br>' . ($kode_sekunder2 ? $kode_sekunder2->icd : '') . ' - ' . $layanan->diagnosa->diagnosa_sekunder2;
                                        }
                                        if ($layanan->diagnosa->diagnosa_sekunder3 != null) {
                                            $temp .= '<br>' . ($kode_sekunder3 ? $kode_sekunder3->icd : '') . ' - ' . $layanan->diagnosa->diagnosa_sekunder3;
                                        }
                                        echo $temp;
                                    }
                                    ?>
                                </td>
                            </tr>
                        </table>
                        <p style="padding-top: 15px;">VI. RENCANA DAN TERAPI : <br>
                            @foreach ($dokumen->resep as $r)
                                <span
                                    style="border-bottom: 2px solid; margin-left: 20px;">{{ 'R/ ' . $r->nomor_resep }}</span><br>
                                @if (isset($r->obat_jadi))
                                    @foreach ($r->obat_jadi as $oj)
                                        <span style="padding-left: 20px;">{{ '- ' . $oj->nama_obat }}</span><br>
                                    @endforeach
                                @endif
                                @if (isset($r->obat_racik))
                                    @foreach ($r->obat_racik as $or)
                                        @foreach ($or->bahan as $ba)
                                            <span style="padding-left: 20px;">{{ '- ' . $ba->nama_obat }}</span><br>
                                        @endforeach
                                    @endforeach
                                @endif
                                <br>
                                <br>
                            @endforeach
                        </p>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row" style="width: 100%; margin-left: 0;">
        <div style="width: 66%; float:left;">
        </div>
        <div style="width: 33%; float:right; text-align:center;">
            <p>Tandatangan dan nama<br>Dokter</p>
            <img src="{{ env('SMIS_UPLOAD_URL') . '/' . ($employee ? $employee->ttd : '') }}" alt=""
                style="height: 2.5cm; width: 5cm;">
            <p>{{ $dokumen->nama_verifikator }}</p>
        </div>
    </div>
</body>

</html>
