<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Informed Consent</title>

    <style>
        * {
            font-family: sans-serif;
        }

        .pagebreak {
            page-break-before: always;
        }

        /* Clear floats after the columns */
        .row:after {
            content: "";
            display: table;
            clear: both;
        }

        .data_diri tr th {
            text-align: left;
            font-size: 12px;
            padding: 5px;
        }

        .main_table tr th {
            border: 1px solid;
            padding: 5px;
            border-collapse: collapse;
        }

        .main_table {
            width: 100%;
            font-size: 12px;
            border-collapse: collapse;
        }

        .main_table tr td {
            border: 1px solid;
            padding: 5px;
            border-collapse: collapse;
        }
    </style>
</head>

<body>
    <div class="row pt-3" style="width: 101%; margin-left: 0;">
        <div style="width: 25%; float:left; margin-top:-50px;">
            {{-- <img src="{{ asset('filelogo/kotakihc.png') }}" alt="" style="width: 80%;"> --}}
        </div>
        <div style="width: 50%; float:left; margin-top:-20px;">
            <h3 style="text-transform: uppercase; text-align: center;">PT. ROLAS NUSANTARA MEDIKA<br>KLINIK ROLAS MEDIKA
            </h3>
        </div>
        <div style="width: 25%; float:left; margin-top:-50px;">
        </div>
        <!-- <div style="border:1px solid; border-width: 1px; width:100%;">
        </div> -->
    </div>
    <div class="row" style="border-bottom:2px solid; padding-bottom:20px;">
        <div style="width:100%; float:left;">
            <table style="border-collapse: collapse; text-align: left; font-size:11px; width:100%">
                <tr>
                    <th style="text-align: left;">Alamat Kantor</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th style="text-align: left;">Jl. Raya Dharma Husada Indah No.26 Surabaya</th>
                    <th style="padding-left: 30px;text-align: left;">E-mail</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th style="text-align: left;">klinik.dharmahusadapremier@gmail.com</th>
                </tr>
                <tr>
                    <th style="text-align: left;">Telepon</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th style="text-align: left;text-align: left;">+0315921101</th>
                    <th style="padding-left: 30px;text-align: left;">Whatsapp</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th style="text-align: left;">085233664118</th>
                </tr>
            </table>
        </div>
    </div>
    <div class="row" style="padding-top: 5px;">
        <div style="border: 2px solid; width:47.5%; float:left;">
            <table style="border-collapse: collapse; padding-bottom:24.5px;" class="data_diri">
                <tr>
                    <th>Tanggal Periksa</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        {{ date('d-m-Y', strtotime($dokumen->created_at)) }}
                    </th>
                </tr>
                <tr>
                    <th>Jam Awal Asesmen</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        {{ date('H:i', strtotime($dokumen->created_at)) }}
                    </th>
                </tr>
                <tr>
                    <th>Jam Akhir Asesmen</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        {{ date('H:i', strtotime($dokumen->tanggal_update)) }}
                    </th>
                </tr>
            </table>
        </div>
        <div style="width: 5%; float:left;"></div>
        <div style="border: 2px solid; width:47.5%; float:left;">
            <table style="border-collapse: collapse;" class="data_diri">
                <tr>
                    <th>Nama</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        {{ $layanan ? $layanan->nama_pasien : '' }}
                    </th>
                </tr>
                <tr>
                    <th>Tanggal Lahir</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        {{ date('d-m-Y', strtotime($pasien->tgl_lahir)) }}
                    </th>
                </tr>
                <tr>
                    <th>No. Rekam Medis</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        {{ $layanan ? $layanan->nrm : '' }}
                    </th>
                </tr>
                <tr>
                    <th>No. JKN</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th></th>
                </tr>
            </table>
        </div>
    </div>
    <div class="row pt-4" style="width: 100%; margin-left: 0;">
        <h3 style="text-align: center;">PENOLAKAN/PERSETUJUAN TINDAKAN KEDOKTERAN</h3>
    </div>
    <div class="row pt-3 pb-3" style="width: 100%; margin-left: 0; border:2px solid;">
        <table class="main_table">
            <tr>
                <th colspan="3" style="text-align: center;">PEMBERIAN INFORMASI</th>
            </tr>
            <tr>
                <td style="width: 50%;">Dokter Pelaksana Tindakan</td>
                <td style="width: 25%;">
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->dokter_pelaksana : '' }}
                </td>
                <td></td>
            </tr>
            <tr>
                <td style="width: 50%;">Pemberi Informasi</td>
                <td style="width: 25%;">
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->pemberi_informasi : '' }}
                </td>
                <td></td>
            </tr>
            <tr>
                <td style="width: 50%;" rowspan="2">Penerima Informasi / Pemberi Persetujuan</td>
                <td style="width: 25%;">
                    Nama
                </td>
                <td>
                    Hubungan Dengan Pasien
                </td>
            </tr>
            <tr>
                <td style="width: 25%;">
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->penerima_informasi : '' }}
                </td>
                <td>
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->hubungan : '' }}
                </td>
            </tr>
        </table>
        <table class="main_table">
            <tr>
                <th style="text-align: center; width:7%;">NO.</th>
                <th style="text-align: center; width:43%;">Masalah</th>
                <th style="text-align: center;">ISI INFORMASI</th>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">1.</td>
                <td style="width:43%;">Diagnosis<br>(Kerja dan Diagnosa Banding)</td>
                <td>
                    <ul id="list_diagnosa" style="list-style-type: numeric; margin-left: -15px;">
                        <li>
                            {{ $layanan->diagnosa ? $layanan->diagnosa->kode_icd . ' - ' . $layanan->diagnosa->nama_icd : '' }}
                        </li>
                        <li>
                            {{ $layanan->diagnosa ? $layanan->diagnosa->kode_icd_sekunder . ' - ' . $layanan->diagnosa->nama_icd_sekunder : '' }}
                        </li>
                    </ul>
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">2.</td>
                <td style="width:43%;">Dasar Diagnosis</td>
                <td>
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->dasar_diagnosis : '' }}
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">3.</td>
                <td style="width:43%;">Tindakan Kedokteran</td>
                <td>
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->tindakan_kedokteran : '' }}
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">4.</td>
                <td style="width:43%;">Indikasi Tindakan</td>
                <td>
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->indikasi_tindakan : '' }}
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">5.</td>
                <td style="width:43%;">Tata Cara</td>
                <td>
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->tata_cara : '' }}
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">6.</td>
                <td style="width:43%;">Tujuan</td>
                <td>
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->tujuan : '' }}
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">7.</td>
                <td style="width:43%;">Risiko</td>
                <td>
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->risiko : '' }}
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">8.</td>
                <td style="width:43%;">Komplikasi</td>
                <td>
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->komplikasi : '' }}
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">9.</td>
                <td style="width:43%;">Prognosis</td>
                <td>
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->prognosis : '' }}
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">10.</td>
                <td style="width:43%;">Alternatif & Resiko Lain-lain</td>
                <td>
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->alternatif_resiko : '' }}
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">11.</td>
                <td style="width:43%;">Lain-lain</td>
                <td>
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->lain_lain : '' }}
                </td>
            </tr>
        </table>
        <table class="main_table">
            <tr>
                <td style="width:70%;">Dengan ini menyatakan bahwa saya telah menerangkan hal-hal di atas secara benar
                    dan jelas dan memberikan kesempatan untuk bertanya dan / atau berdiskusi</td>
                <td style="text-align: center; vertical-align: top;">
                    Tandatangan
                    <div id="box_ttd_pemberi_informasi">
                        @if ($dokumen->status != 0)
                            <img src="{{ env('SMIS_UPLOAD_URL') . '/' . $dokumen->ttd }}"
                                style="height: 1.5cm; width: 3cm;" alt="">
                            <p>({{ $dokumen->nama_verifikator }})</p>
                        @endif
                    </div>
                </td>
            </tr>
            <tr>
                <td style="width:70%;">Dengan ini menyatakan bahwa saya telah menerima informasi sebagaimana di atas
                    yang saya beri tanda / paraf di kolom kanannya, dan telah memahaminya</td>
                <td style="text-align: center; vertical-align: top;">
                    Tandatangan
                    <div id="box_ttd_penerima_informasi">
                        @if (isset($dokumen->informed_consent))
                            <img src="{{ asset('signature_patient/' . $dokumen->informed_consent->signature) }}"
                                alt="" style="height: 1.5cm; width:3cm;">
                            <p style="font-size: 12px; font-weight: bold; text-transform:uppercase">
                                ({{ $dokumen->informed_consent->penerima_informasi }})</p>
                        @endif
                    </div>
                </td>
            </tr>
            <tr>
                <td colspan="2" style="font-style: italic;">Bila pasien tidak kompeten atau tidak mau menerima
                    informasi, maka penerima informasi adalah wali atau keluarga terdekat.</td>
            </tr>
        </table>
        <table class="main_table" style="margin-bottom: 50px;">
            <tr>
                <th style="text-align: center;">PENOLAKAN/PERSETUJUAN TINDAKAN KEDOKTERAN</th>
            </tr>
            <tr>
                <td>
                    Yang bertanda tangan dibawah ini saya, Nama :
                    {{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->nama : '') : '' }},
                    hubungan dengan pasien
                    <span
                        style="{{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? ($dokumen->informed_consent->persetujuan->hubungan != 'Pasien sendiri' ? 'text-decoration:line-through;' : '') : '') : '' }}">Pasien
                        sendiri</span>,
                    <span
                        style="{{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? ($dokumen->informed_consent->persetujuan->hubungan != 'Orang tua' ? 'text-decoration:line-through;' : '') : '') : '' }}">Orang
                        tua</span>,
                    <span
                        style="{{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? ($dokumen->informed_consent->persetujuan->hubungan != 'Anak' ? 'text-decoration:line-through;' : '') : '') : '' }}">Anak</span>,
                    <span
                        style="{{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? ($dokumen->informed_consent->persetujuan->hubungan != 'Istri' ? 'text-decoration:line-through;' : '') : '') : '' }}">Istri</span>,
                    <span
                        style="{{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? ($dokumen->informed_consent->persetujuan->hubungan != 'Suami' ? 'text-decoration:line-through;' : '') : '') : '' }}">Suami</span>,
                    <span
                        style="{{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? ($dokumen->informed_consent->persetujuan->hubungan != 'Saudara' ? 'text-decoration:line-through;' : '') : '') : '' }}">Saudara</span>,
                    <span
                        style="{{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? ($dokumen->informed_consent->persetujuan->hubungan != 'Pengantar' ? 'text-decoration:line-through;' : '') : '') : '' }}">Pengantar</span>,
                    Umur
                    {{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->umur : '') : '' }}
                    Tahun, <span
                        style="{{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? ($dokumen->informed_consent->persetujuan->kelamin != '0' ? 'text-decoration:line-through;' : '') : '') : '' }}">Laki-laki</span>
                    / <span
                        style="{{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? ($dokumen->informed_consent->persetujuan->kelamin != '1' ? 'text-decoration:line-through;' : '') : '') : '' }}">
                        perempuan</span>, alamat
                    {{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->alamat : '') : '' }}
                </td>
            </tr>
            <tr>
                <td>
                    Dengan ini menyatakan <span
                        style="{{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? ($dokumen->informed_consent->persetujuan->menyatakan != '0' ? 'text-decoration:line-through;' : '') : '') : '' }}">menolak</span>
                    / <span
                        style="{{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? ($dokumen->informed_consent->persetujuan->menyatakan != '1' ? 'text-decoration:line-through;' : '') : '') : '' }}">menyetujui</span>
                    untuk dilakukan tindakan
                    {{ $dokumen->informed_consent ? $dokumen->informed_consent->tindakan_kedokteran : '' }} Terhadap
                    <span
                        style="{{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? ($dokumen->informed_consent->persetujuan != 'Pasien sendiri' ? 'text-decoration:line-through;' : '') : '') : '' }}">saya</span>
                    <?php
                    if (isset($dokumen->informed_consent)) {
                        if (isset($dokumen->informed_consent->persetujuan)) {
                            if ($dokumen->informed_consent->persetujuan->hubungan == 'Suami') {
                                echo '/ Istri saya';
                            } elseif ($dokumen->informed_consent->persetujuan->hubungan == 'Istri') {
                                echo '/ Suami saya';
                            } elseif ($dokumen->informed_consent->persetujuan->hubungan == 'Orang tua') {
                                echo '/ Anak saya';
                            } elseif ($dokumen->informed_consent->persetujuan->hubungan == 'Anak') {
                                echo '/ Orang tua saya';
                            } elseif ($dokumen->informed_consent->persetujuan->hubungan == 'Suami') {
                                echo '/ yang saya antar';
                            } else {
                                echo '/ ' . $dokumen->informed_consent->persetujuan->hubungan . ' saya';
                            }
                        }
                    }
                    ?>
                    Bernama {{ $layanan->nama_pasien }}, Umur :
                    <?php
                    $date = new DateTime($pasien->tgl_lahir);
                    $now = new DateTime();
                    $age = $now->diff($date);
                    echo $age->y . ', ';
                    ?>
                    {{ $pasien->kelamin == 0 ? 'Laki-laki' : 'Perempuan' }}<br>
                    Alamat : {{ $pasien->alamat }}, {{ $pasien->nama_kelurahan }}, {{ $pasien->nama_kecamatan }},
                    {{ $pasien->nama_kabupaten }}
                </td>
            </tr>
            <tr>
                <td style="border-bottom: 1px solid transparent;">
                    Saya memahami betapa perlunya dan manfaat tindakan tersebut sebagaimana telah dijelaskan seperti di
                    atas kepada saya, termasuk risiko dan komplikasi yang mungkin timbul apabila tindakan tidak
                    dilakukan.<br>
                    Saya bertanggung jawab secara penuh atas segala akibat yang mungkin tinbul sebagai akibat tidak
                    dilakukan tindakan kedokteran tersebut.
                </td>
            </tr>
        </table>
        <div style="text-align: center; width:33.3%; float:left; font-size:14px;">
            <div id="box_saksi_satu">
                @if (isset($dokumen->informed_consent))
                    @if (isset($dokumen->informed_consent->persetujuan))
                        @if ($dokumen->informed_consent->persetujuan->signature_saksi_satu != '')
                            <br>
                            <p>Saksi 1 (Keluarga Pasien)</p>
                            <img src="{{ asset('signature_patient/' . $dokumen->informed_consent->persetujuan->signature_saksi_satu) }}"
                                alt="" style="height: 2.5cm; width:5cm;">
                        @else
                            <br>
                            <p>Saksi 2 (Keluarga Pasien)</p>
                            <br>
                            <br>
                            <div id="saksi_satu">Klik disini</div>
                            <br>
                            <br>
                        @endif
                    @else
                        <br>
                        <p>Saksi 2 (Keluarga Pasien)</p>
                        <br>
                        <br>
                        <div id="saksi_satu">Klik disini</div>
                        <br>
                        <br>
                    @endif
                @else
                    <br>
                    <p>Saksi 2 (Keluarga Pasien)</p>
                    <br>
                    <br>
                    <div id="saksi_satu">Klik disini</div>
                    <br>
                    <br>
                @endif
            </div>
            {{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->saksi_satu : '') : '' }}
        </div>
        <div style="text-align: center; width:33.3%; float:left; font-size:14px;">
            <div id="box_saksi_dua">
                @if (isset($dokumen->informed_consent))
                    @if (isset($dokumen->informed_consent->persetujuan))
                        @if ($dokumen->informed_consent->persetujuan->signature_saksi_dua != '')
                            <br>
                            <p>Saksi 2 (Keluarga Pasien)</p>
                            <img src="{{ asset('signature_patient/' . $dokumen->informed_consent->persetujuan->signature_saksi_dua) }}"
                                alt="" style="height: 2.5cm; width:5cm;">
                        @else
                            <br>
                            <p>Saksi 2 (Keluarga Pasien)</p>
                            <br>
                            <br>
                            <div id="saksi_dua">Klik disini</div>
                            <br>
                            <br>
                        @endif
                    @else
                        <br>
                        <p>Saksi 2 (Keluarga Pasien)</p>
                        <br>
                        <br>
                        <div id="saksi_dua">Klik disini</div>
                        <br>
                        <br>
                    @endif
                @else
                    <br>
                    <p>Saksi 2 (Keluarga Pasien)</p>
                    <br>
                    <br>
                    <div id="saksi_dua">Klik disini</div>
                    <br>
                    <br>
                @endif
            </div>
            {{ $dokumen->informed_consent ? ($dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->saksi_dua : '') : '' }}
        </div>
        <div style="text-align: center; width:33.3%; float:left; font-size:14px;">
            @if (isset($dokumen->informed_consent))
                @if (isset($dokumen->informed_consent->persetujuan))
                    <p>Surabaya, {{ date('d/m/Y', strtotime($dokumen->informed_consent->persetujuan->tanggal)) }} Pukul
                        {{ date('H:i', strtotime($dokumen->informed_consent->persetujuan->tanggal)) }} <br>Yang
                        menyatakan</p>
                    <img src="{{ asset('signature_patient/' . $dokumen->informed_consent->persetujuan->signature) }}"
                        alt="" style="height: 2.5cm; width:5cm;">
                    <p>{{ $dokumen->informed_consent->persetujuan->nama }}</p>
                @else
                    <p>Surabaya, .............Pukul...............<br>Yang menyatakan</p>
                    <br>
                    <br>
                    <p>Klik disini</p>
                    <br>
                    <br>
                    (..............................................................)
                @endif
            @else
                <p>Surabaya, .............Pukul...............<br>Yang menyatakan</p>
                <br>
                <br>
                <p>Klik disini</p>
                <br>
                <br>
                (..............................................................)
            @endif
        </div>
    </div>
</body>

</html>
