<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Catatan Perkembangan Pasien</title>
    <style>
        * {
            font-family: sans-serif;
            font-size: 12px;
        }

        /* Clear floats after the columns */
        .row:after {
            content: "";
            display: table;
            clear: both;
        }

        .table-bordered {
            border: 1px solid
        }

        .table-bordered td, .table-bordered th {
            border: 1px solid
        }

        .table-bordered thead td, .table-bordered thead th {
            border-bottom-width: 1px
        }
    </style>
</head>
<body>
<div class="row" style="width: 100%;">
    <div style="width: 50%; float: left;">
        <img src="{{ asset('filelogo/logo-dhp.png') }}" alt="" style="width: 70%;">
    </div>
    <div style="width: 50%; border: 1px solid; float: right;">
        <table style="border-collapse:collapse;">
            <tr>
                <td>Nama</td>
                <td style="padding-left:10px; padding-right:5px"> :</td>
                <td>{{ $pasien->nama }}</td>
            </tr>
            <tr>
                <td>No. RM</td>
                <td style="padding-left:10px; padding-right:5px"> :</td>
                <td>{{ $pasien->id }}</td>
            </tr>
            <tr>
                <td>Tempat, Tgl Lahir</td>
                <td style="padding-left:10px; padding-right:5px"> :</td>
                <td>{{ $pasien->tempat_lahir }}, {{ date('d-m-Y', strtotime($pasien->tgl_lahir)) }}</td>
            </tr>
            <tr>
                <td>Jenis Kelamin</td>
                <td style="padding-left:10px; padding-right:5px"> :</td>
                <td>{{ $pasien->kelamin ? 'Perempuan' : 'Laki-Laki' }}</td>
            </tr>
        </table>
    </div>
</div>
<div class="row" style="width: 100%; border:1px solid; text-align: center; background: #DCDCDC; margin-top: 50px;">
    <p style="margin: 0px;">CATATAN PERKEMBANGAN PASIEN TERINTEGRASI</p>
</div>
<div class="row" style="width: 100%; margin-top: 10px;">
    <table class="table-bordered" style="font-size: 12px; border-collapse: collapse;">
        <thead>
        <tr style="text-align: center; width: 100%;">
            <th style="vertical-align: middle; width: 10%">Tgl/Pkl</th>
            <th style="vertical-align: middle; width: 13%">PPA</th>
            <th style="vertical-align: middle; width: 37%">HASIL PEMERIKSAAN, ANALISA/ASESMEN
                RENCANA PENATALAKSANAAN PASIEN – IAR
                (tulis dengan format SOAP/ADIME, disertai
                sasaran, tulis nama dan Paraf, pada akhir catatan)
            </th>
            <th style="vertical-align: middle; width: 25%">
                Intruksi PPA termasuk Pasca
                Bedah (Instruksi ditulis dg rinci
                dan jelas)
            </th>
            <th style="vertical-align: middle; width: 15%">
                Verifikasi DPJP <br>
                (Nama, Paraf, <br>
                Tgl, dan Pkl)
            </th>
        </tr>
        </thead>
        <tbody>
        <tr class="text-center">
            <td style="vertical-align: top; text-align: left;">
                <p>
                    {{ $dokumen->catatan_perkembangan_pasien->tanggal }}
                </p>
            </td>
            <td style="vertical-align: top; text-align: left;">
                <p>
                    {{ $dokumen->catatan_perkembangan_pasien->ppa }}
                </p>
            </td>
            <td style="vertical-align: top; text-align: left;">
                <p>
                    {{ $dokumen->catatan_perkembangan_pasien->hasil_pemeriksaan }}
                </p>
            </td>
            <td style="vertical-align: top; text-align: left;">
                <p>
                    {{ $dokumen->catatan_perkembangan_pasien->intruksi_ppa }}
                </p>
            </td>
            <td style="vertical-align: top; text-align: center;">
                <a href="#" onclick="open_modal_verifikasi('{{ $dokumen->id }}')"
                   style="width:100%; height:120px; display: flex; justify-content: center; align-items: center; text-decoration: none; color:#111;">
                    <img src="{{ env('SMIS_UPLOAD_URL') . '/' . $employee->ttd }}"
                         style="height: 2.5cm; width: 5cm;" alt="">
                </a>
                {{ $dokumen->nama_verifikator }}
            </td>
        </tr>
        <tr>
            <td colspan="5" style="text-align: center">
                <p><b>PPA:&nbsp;&nbsp;&nbsp;&nbsp;Dr: Dokter&nbsp;&nbsp;&nbsp;&nbsp;Ns: Perawat
                        &nbsp;&nbsp;&nbsp;&nbsp;Fp: Fisioterapist&nbsp;&nbsp;&nbsp;&nbsp;Apt: Apoteker</b></p>
            </td>
        </tr>
        </tbody>
    </table>
</div>
</body>
</html>
