<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <title>Asesmen Medis Rawat Jalan</title>

    <link rel="stylesheet" href="{{ asset('app-assets/css/bootstrap.min.css') }}">
    <style>
        #main_tabel>thead>tr>th {
            border: 1px solid;
        }

        #main_tabel>tbody>tr>td {
            border: 1px solid;
            padding-left: 10px;
            padding-right: 10px;
            vertical-align: top;
        }
    </style>
</head>

<body>
    <div class="modal fade" id="modal_verifikasi" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Verifikasi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ url('medical_record/e_rekam_medis/verifikasi_dokumen_kunjungan') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" name="id_dokumen" id="id_dokumen">
                        <input type="hidden" name="slug_dokumen"
                            value="{{ strtolower(str_replace(' ', '_', $dokumen->nama_dokumen)) }}">
                        <div class="form-group">
                            <label for="">Password</label>
                            <input type="password" placeholder="Masukkan password untuk melanjutkan"
                                class="form-control" name="password" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Verifikasi</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="container pt-4">
        <p style="font-weight: bold; font-size:30px; text-align: center">ASESMEN MEDIS RAWAT JALAN</p>
        <table style="border-collapse: collapse; width:100%;" id="main_tabel">
            <thead>
                <tr class="text-center">
                    <th style="width:12%">Tanggal</th>
                    <th style="width:12%">Keluhan Utama</th>
                    <th style="width:12%">Pemeriksaan Fisik</th>
                    <th style="width:12%">Pemeriksaan Penunjang</th>
                    <th style="width:12%">Diagnosa / Kode ICD</th>
                    <th style="width:12%">Tindakan Dokter</th>
                    <th style="width:12%">Terapi</th>
                    <th style="width:12%">Dokter Jaga</th>
                </tr>
            </thead>
            <tbody>
                @if ($layanan)
                    <tr>
                        <td class="text-center">{{ date('d-m-Y', strtotime($layanan->tanggal_diagnosa)) }}</td>
                        <td>{{ $layanan->keluhan }}</td>
                        <td>
                            Tensi : {{ $layanan->sistole . '/' . $layanan->diastole }} mmHg<br>
                            Nadi : {{ $layanan->nadi }} x/menit<br>
                            Respirasi : {{ $layanan->rr }} x/menit<br>
                            Suhu : {{ $layanan->suhu }} °C<br>
                            Pemeriksaan Fisik : {{ $layanan->anamnesa }}
                        </td>
                        <td>
                            <ul style="margin-left: -25px; list-style-type: lower-alpha;">
                                <?php
                                if($layanan->periksa != '' && $layanan->periksa != null){
                                    $lab = json_decode($layanan->periksa, true);
                                    if ($lab != null) {
                                        foreach ($lab as $key => $value) {
                                            if ($value == 1) {
                                ?>
                                <li style="text-transform: capitalize;">{{ str_replace('_', ' ', $key) }}</li>
                                <?php
                                            }
                                        }
                                    }
                                }
                                ?>
                            </ul>
                        </td>
                        <td>{{ $layanan->nama_icd . ' / ' . $layanan->kode_icd }}</td>
                        <td>
                            @if (isset($layanan->tindakan))
                                @if ($layanan->tindakan != null)
                                    {{ $layanan->tindakan->nama_tindakan }}
                                @endif
                            @endif
                            {{ $layanan->terapi_non_obat }}
                        </td>
                        <td>
                            @foreach ($layanan->resep as $r)
                                <span style="border-bottom: 2px solid;">{{ 'R/ ' . $r->nomor_resep }}</span><br>
                                @if (isset($r->obat_jadi))
                                    @foreach ($r->obat_jadi as $oj)
                                        <span>{{ '- ' . $oj->nama_obat }}</span><br>
                                    @endforeach
                                @endif
                                @if (isset($r->obat_racik))
                                    @foreach ($r->obat_racik as $or)
                                        @foreach ($or->bahan as $ba)
                                            <span>{{ '- ' . $ba->nama_obat }}</span><br>
                                        @endforeach
                                    @endforeach
                                @endif
                                <br>
                                <br>
                            @endforeach
                        </td>
                        <td>
                            {{ $layanan->nama_dokter }}<br>
                            @if ($dokumen->id_verifikator != 0)
                                <img src="{{ env('SMIS_UPLOAD_URL') . '/' . $layanan->ttd }}" alt=""
                                    style="height: 2.5cm; width: 5cm;">
                            @endif
                        </td>
                    </tr>
                @else
                    <tr>
                        <td colspan="8">Data tidak ditemukan</td>
                    </tr>
                @endif
            </tbody>
        </table>
        <div class="row pt-2" style="width: 100%; margin-left: 0;">
            @if (Session::has('success'))
                <div class="col-lg-12 pl-0 pr-0">
                    <div class="alert alert-success">{{ Session::get('success') }}</div>
                </div>
            @endif
            @if (Session::has('failed'))
                <div class="col-lg-12 pl-0 pr-0">
                    <div class="alert alert-danger">{{ Session::get('failed') }}</div>
                </div>
            @endif
            <div class="col-lg-4"></div>
            <a href="#" onclick="open_modal_verifikasi('{{ $dokumen->id }}')" class="col-lg-4 pt-3"
                style="text-decoration:none; color:#111; border: 1px solid; justify-content: center; align-items: center; display: flex; height:200px;">
                <p style="font-weight: bold; font-size: 25px;">Klik disini untuk verifikasi</p>
            </a>
            <div class="col-lg-4"></div>
            @if ($dokumen->status == 1)
                <div class="col-lg-12 text-center pt-3">
                    <a href="{{ url('medical_record/e_rekam_medis/asesmen_medis_rawat_jalan/pdf?dokumen=' . $dokumen->id) }}"
                        target="_blank" class="btn btn-success">Download Pdf</a>
                </div>
            @endif
        </div>
    </div>
</body>

</html>
<script src="https://code.jquery.com/jquery-3.3.1.min.js"
    integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script src="{{ asset('app-assets/js/bootstrap.min.js') }}"></script>
<script>
    function open_modal_verifikasi(id_dokumen) {
        $('#id_dokumen').val(id_dokumen);
        $('#modal_verifikasi').modal('show');
    }
</script>
