@extends('layouts.app')
@section('content')
    <div class="modal fade" id="modalAdd" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header" style="margin-top: -15px;">
                    <h5 class="modal-title text-primary" id="exampleModalLongTitle">Tambah Kelurahan</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('kelurahan.store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body mt-3">
                        <div class="form-group">
                            <label for="">Provinsi</label>
                            <select class="form-control kabupaten" name="prop_id" id="prop_id">
                                <option value="">-- Silahkan Pilih Pilihan --</option>
                                @foreach ($provinsi as $prov)
                                    <option value="{{ $prov->id }}">{{ $prov->nama }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Kabupaten</label>
                            <select class="form-control kabupaten" name="kabupaten" id="kabupaten">
                                <option value="">-- Silahkan Pilih Pilihan --</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Kecamatan</label>
                            <select class="form-control kabupaten" name="kecamatan" id="kecamatan">
                                <option value="">-- Silahkan Pilih Pilihan --</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Nama Kelurahan</label>
                            <input class="form-control" type="text" value="" name="nama" id="nama" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modalEdit" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header" style="margin-top: -15px;">
                    <h5 class="modal-title text-primary" id="exampleModalLongTitle">Ubah Kelurahan</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('kelurahan.update', 0) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <input type="text" hidden id="id_edit" name="id">
                    <div class="modal-body mt-3">
                        <div class="form-group">
                            <label for="">Provinsi</label>
                            <select class="form-control kabupaten-edit" name="prop_id" id="prop_id_edit">
                                <option value="">-- Silahkan Pilih Pilihan --</option>
                                @foreach ($provinsi as $prov)
                                    <option value="{{ $prov->id }}">{{ $prov->nama }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Kabupaten</label>
                            <select class="form-control" name="kabupaten" id="kabupaten_edit">
                                <option value="">-- Silahkan Pilih Pilihan --</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Kecamatan</label>
                            <select class="form-control kabupaten" name="kecamatan" id="kecamatan_edit">
                                <option value="">-- Silahkan Pilih Pilihan --</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">Nama Kelurahan</label>
                            <input class="form-control" type="text" value="" name="nama" id="nama_edit" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Data Induk Pendaftaran</h1>
            </div>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="section-body">
                <div class="card">
                    @include('data_induk_pendaftaran.nav_tab')
                    <h4></h4>
                    <div class="card-body">
                        <div class="card-header" style="margin-left: -25px;">
                            <div class="card-header-form">
                                <form method="get" action="{{ route('kelurahan.search') }}">
                                    <div class="input-group">
                                        <input type="text" name="keyword" class="form-control" placeholder="Search"
                                            value="{{ $keyword ?? '' }}">
                                        <div class="input-group-btn ml-2">
                                            <button type="submit" class="btn btn-primary"><i
                                                    class="fas fa-search"></i></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped" style="width:100%;">
                                <thead>
                                    <tr class="">
                                        <th>No</th>
                                        <th>ID</th>
                                        <th>Nama</th>
                                        <th>Kecamatan</th>
                                        <th>Kabupaten</th>
                                        <th>Provinsi</th>
                                        <th>
                                            <div class="row">
                                                <button class="btn btn-primary" data-toggle="modal"
                                                    data-target="#modalAdd"><i class="fas fa-plus"></i></button>
                                                <button onclick="downloadExcel()"class="btn btn-info"
                                                    style="margin-left:3px ;"><i style="font-size:12pt;"
                                                        class="fa fa-print"></i></button>
                                            </div>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($data as $key => $dt)
                                        <tr class="">
                                            <td>{{ $key + $data->firstItem() }}</td>
                                            <td>{{ $dt->id }}</td>
                                            <td>{{ $dt->kelurahan }}</td>
                                            <td>{{ $dt->kecamatan }}</td>
                                            <td>{{ $dt->kabupaten }}</td>
                                            <td>{{ $dt->provinsi }}</td>
                                            <td style="width:5%;">
                                                <div style="display: flex; flex-direction: row;">
                                                    <button onclick="showEditModal('{{ $dt->id }}')"
                                                        class="btn btn-warning mr-1"><i class="fa fa-pencil"></i></button>
                                                    <form action="{{ route('kelurahan.destroy', $dt->id) }}"
                                                        method="post" enctype="multipart/form-data">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button
                                                            onclick="return confirm('Yakin melanjutkan hapus data {{ $dt->kelurahan }} ?')"
                                                            class="btn btn-danger"><i class="fas fa-trash"></i></button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr class="text-center">
                                            <td colspan="10">Data tidak ditemukan</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="row mt-3" style="width: 100%; margin-left:0;">
                            <div class="col-lg-6" style="display: flex; align-items: center;">
                                @if (sizeof($data) > 0)
                                    Showing data {{ $data->firstItem() }} to {{ $data->lastItem() }}, Page
                                    {{ $data->currentPage() }} of {{ $data->lastPage() }} @if ($keyword != '')
                                        (Filtered)
                                    @endif
                                @else
                                    Empty result @if ($keyword != '')
                                        (Filtered)
                                    @endif
                                @endif
                            </div>
                            <div class="col-lg-6" style="justify-content: flex-end; display: flex;">
                                {{ $data->appends(Request::only('keyword'))->links('pagination::bootstrap-4') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script></script>
    <script src="https://code.jquery.com/jquery-3.3.1.min.js"
        integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
    <script>
        var idKabupaten = 0;

        function getIdKabupaten(param) {
            idKabupaten = param;
        }

        var idKecamatan = 0;

        function getIdKecamatan(param) {
            idKecamatan = param;
        }

        function showEditModal(param) {
            var url = "{{ route('kelurahan.edit', ':id') }}";
            url = url.replace(':id', param);

            $.ajax({
                url: url,
                type: 'GET',
                success: function(response) {
                    if (response == null) {
                        return;
                    }
                    getIdKabupaten(response.no_kab);
                    getIdKecamatan(response.no_kec);
                    $('#id_edit').val(response.id);
                    $('#nama_edit').val(response.kelurahan);
                    $('#prop_id_edit').val(response.no_prop).trigger('change');
                    $('#modalEdit').modal('show');
                },
                error: function(request, status, error) {
                    alert("Terjadi error saat edit data, silahkan hubungi admin");
                }
            })
        }

        function downloadExcel() {

            var keyword = $('input[name=keyword]').val();
            var url = "{{ route('kelurahan.download') }}/?keyword=" + keyword;
            if (confirm("Apakah anda ingin melanjutkan download ?")) {
                window.location.href = url;
            } else {
                return false;
            }
        }
    </script>
@endsection
@push('scripts')
    <script charset="utf-8">
        $(document).ready(function() {
            function setKecamatan(selectedValue) {
                var url = "{{ route('kelurahan.get_kecamatan', ':id') }}";
                url = url.replace(':id', selectedValue);
                // Mengirim permintaan AJAX
                $.ajax({
                    url: url,
                    method: 'GET',
                    success: function(response) {
                        var dynamicSelect = $('#kecamatan_edit');
                        dynamicSelect.empty(); // Mengosongkan opsi sebelum mengisi yang baru

                        // Iterasi melalui data respons dan menambahkan opsi ke elemen select
                        dynamicSelect.append('<option value="">-- Silahkan Pilih Pilihan --</option>');
                        for (var i = 0; i < response.length; i++) {
                            dynamicSelect.append('<option value="' + response[i].id + '"' + (
                                    idKecamatan === response[i].id ? ' selected' : '') + '>' +
                                response[i].nama + '</option>');
                        }

                        // Memperbarui tampilan Select2 jika digunakan
                        dynamicSelect.select2({
                            dropdownParent: $("#modalEdit"),
                            templateSelection: function(data) {
                                var $result = $(
                                    '<span class="select2-selection__rendered pt-1">' +
                                    data.text +
                                    '</span>'
                                );
                                return $result;
                            }
                        });
                    },
                    error: function(xhr, status, error) {
                        // Tangani kesalahan jika ada
                        console.log(error);
                    }
                });
            }
            //Select Kecamatan 
            $('#kabupaten').on('change', function() {
                var selectedValue = $(this).val(); // Mendapatkan nilai yang dipilih dari elemen lain
                var url = "{{ route('kelurahan.get_kecamatan', ':id') }}";
                url = url.replace(':id', selectedValue);
                // Mengirim permintaan AJAX
                $.ajax({
                    url: url,
                    method: 'GET',
                    //data: { selectedValue: selectedValue }, // Kirim data ke endpoint jika diperlukan
                    success: function(response) {
                        var dynamicSelect = $('#kecamatan');
                        dynamicSelect.empty(); // Mengosongkan opsi sebelum mengisi yang baru

                        // Iterasi melalui data respons dan menambahkan opsi ke elemen select
                        dynamicSelect.append(
                            '<option value="">-- Silahkan Pilih Pilihan --</option>');
                        for (var i = 0; i < response.length; i++) {
                            dynamicSelect.append('<option value="' + response[i].id + '">' +
                                response[i].nama + '</option>');
                        }

                        // Memperbarui tampilan Select2 jika digunakan
                        dynamicSelect.select2({
                            dropdownParent: $("#modalAdd"),
                            templateSelection: function(data) {
                                var $result = $(
                                    '<span class="select2-selection__rendered pt-1">' +
                                    data.text +
                                    '</span>'
                                );
                                return $result;
                            }
                        });
                    },
                    error: function(xhr, status, error) {
                        // Tangani kesalahan jika ada
                        console.log(error);
                    }
                });
            });

            //Select Kabupaten 
            $('#prop_id_edit').on('change', function() {

                setKecamatan(idKabupaten);
                var selectedValue = $(this).val(); // Mendapatkan nilai yang dipilih dari elemen lain
                var url = "{{ route('kecamatan.get_kabupaten', ':id') }}";
                url = url.replace(':id', selectedValue);
                // Mengirim permintaan AJAX
                $.ajax({
                    url: url,
                    method: 'GET',
                    success: function(response) {
                        var dynamicSelect = $('#kabupaten_edit');
                        dynamicSelect.empty(); // Mengosongkan opsi sebelum mengisi yang baru

                        // Iterasi melalui data respons dan menambahkan opsi ke elemen select
                        for (var i = 0; i < response.length; i++) {
                            dynamicSelect.append('<option value="' + response[i].id + '"' + (
                                    idKabupaten === response[i].id ? ' selected' : '') +
                                '>' +
                                response[i].nama + '</option>');
                        }

                        // Memperbarui tampilan Select2 jika digunakan
                        dynamicSelect.select2({

                            dropdownParent: $("#modalEdit"),
                            templateSelection: function(data) {
                                var $result = $(
                                    '<span class="select2-selection__rendered pt-1">' +
                                    data.text +
                                    '</span>'
                                );
                                return $result;
                            }
                        });
                    },
                    error: function(xhr, status, error) {
                        // Tangani kesalahan jika ada
                        console.log(error);
                    }
                });
            });


            $('#prop_id').on('change', function() {
                var selectedValue = $(this).val(); // Mendapatkan nilai yang dipilih dari elemen lain
                var url = "{{ route('kecamatan.get_kabupaten', ':id') }}";
                url = url.replace(':id', selectedValue);
                // Mengirim permintaan AJAX
                $.ajax({
                    url: url,
                    method: 'GET',
                    //data: { selectedValue: selectedValue }, // Kirim data ke endpoint jika diperlukan
                    success: function(response) {
                        var dynamicSelect = $('#kabupaten');
                        dynamicSelect.empty(); // Mengosongkan opsi sebelum mengisi yang baru

                        // Iterasi melalui data respons dan menambahkan opsi ke elemen select
                        dynamicSelect.append(
                            '<option value="">-- Silahkan Pilih Pilihan --</option>');
                        for (var i = 0; i < response.length; i++) {
                            dynamicSelect.append('<option value="' + response[i].id + '">' +
                                response[i].nama + '</option>');
                        }

                        // Memperbarui tampilan Select2 jika digunakan
                        dynamicSelect.select2({

                            dropdownParent: $("#modalAdd"),
                            templateSelection: function(data) {
                                var $result = $(
                                    '<span class="select2-selection__rendered pt-1">' +
                                    data.text +
                                    '</span>'
                                );
                                return $result;
                            }
                        });
                    },
                    error: function(xhr, status, error) {
                        // Tangani kesalahan jika ada
                        console.log(error);
                    }
                });
            });


            $('.kabupaten-edit').select2({
                dropdownParent: $("#modalEdit"),
                templateSelection: function(data) {
                    var $result = $(
                        '<span class="select2-selection__rendered pt-1">' +
                        data.text +
                        '</span>'
                    );
                    return $result;
                },
            });

            $('.kabupaten').select2({
                dropdownParent: $("#modalAdd"),
                templateSelection: function(data) {
                    var $result = $(
                        '<span class="select2-selection__rendered pt-1">' +
                        data.text +
                        '</span>'
                    );
                    return $result;
                },
            });

        });
    </script>
@endpush
