@extends('layouts.app')
@section('content')
    <div class="modal fade" id="modalAdd" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header" style="margin-top: -15px;">
                    <h5 class="modal-title text-primary" id="exampleModalLongTitle">Tambah Fasilitas Kesehatan</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('fasilitas_kesehatan.store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body mt-3">
                        <div class="col-lg-12 row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="">Nama</label>
                                    <input type="text" class="form-control" required name="nama" id="nama"
                                        placeholder="" value="{{ old('nama') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">Kode</label>
                                    <input type="text" class="form-control" required name="kode" id="kode"
                                        placeholder="" value="{{ old('kode') }}">
                                </div>
                                <div class="form-group">
                                    <div class="control-label">Default</div>
                                    <label class="custom-switch mt-2">
                                        <input type="checkbox" name="default" id="default" class="custom-switch-input">
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Default</span>
                                    </label>
                                </div>
                                <div class="form-group">
                                    <label for="">Unit Kerja</label>
                                    <select class="form-control" name="unit_kerja" id="unit_kerja">
                                        <option value="">--Silahkan Pilh Pilhan---</option>
                                        @foreach ($unit_kerja as $uk)
                                            <option value="{{ $uk->klinik }}">{{ $uk->klinik }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="">Prefix ID</label>
                                    <input type="text" class="form-control" required name="prefix_id" id="prefix_id"
                                        placeholder="" value="{{ old('prefix_id') }}">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="control-label">Bridging</div>
                                    <label class="custom-switch mt-2">
                                        <input type="checkbox" name="bridging" id="bridging" class="custom-switch-input">
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Bridging</span>
                                    </label>
                                </div>
                                <div class="form-group">
                                    <label for="">Last NRM</label>
                                    <input type="text" class="form-control" required name="last_nrm" id="last_nrm"
                                        placeholder="" value="{{ old('last_nrm') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">Alamat</label>
                                    <input type="text" class="form-control" required name="alamat" id="alamat"
                                        placeholder="" value="{{ old('alamat') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">No. Ijin</label>
                                    <input type="text" class="form-control" required name="no_ijin" id="no_ijin"
                                        placeholder="" value="{{ old('no_ijin') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">Telpon</label>
                                    <input type="text" class="form-control" required name="telpon" id="telpon"
                                        placeholder="" value="{{ old('telpon') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modalEdit" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header" style="margin-top: -15px;">
                    <h5 class="modal-title text-primary" id="exampleModalLongTitle">Ubah Jenis Kunjungan</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('fasilitas_kesehatan.update', 0) }}" method="post"
                    enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <input type="text" hidden id="id_edit" name="id">
                    <div class="modal-body mt-3">
                        <div class="col-lg-12 row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label for="">Nama</label>
                                    <input type="text" class="form-control" required name="nama" id="nama_edit"
                                        placeholder="" value="{{ old('nama') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">Kode</label>
                                    <input type="text" class="form-control" required name="kode" id="kode_edit"
                                        placeholder="" value="{{ old('kode') }}">
                                </div>
                                <div class="form-group">
                                    <div class="control-label">Default</div>
                                    <label class="custom-switch mt-2">
                                        <input type="checkbox" name="default" id="default_edit"
                                            class="custom-switch-input">
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Default</span>
                                    </label>
                                </div>
                                <div class="form-group">
                                    <label for="">Unit Kerja</label>
                                    <select class="form-control" name="unit_kerja" id="unit_kerja_edit">
                                        <option value="">--Silahkan Pilh Pilhan---</option>
                                        @foreach ($unit_kerja as $uk)
                                            <option value="{{ $uk->klinik }}">{{ $uk->klinik }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="">Prefix ID</label>
                                    <input type="text" class="form-control" required name="prefix_id"
                                        id="prefix_id_edit" placeholder="" value="{{ old('prefix_id') }}">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <div class="control-label">Bridging</div>
                                    <label class="custom-switch mt-2">
                                        <input type="checkbox" name="bridging" id="bridging_edit"
                                            class="custom-switch-input">
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Bridging</span>
                                    </label>
                                </div>
                                <div class="form-group">
                                    <label for="">Last NRM</label>
                                    <input type="text" class="form-control" required name="last_nrm"
                                        id="last_nrm_edit" placeholder="" value="{{ old('last_nrm') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">Alamat</label>
                                    <input type="text" class="form-control" required name="alamat" id="alamat_edit"
                                        placeholder="" value="{{ old('alamat') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">No. Ijin</label>
                                    <input type="text" class="form-control" required name="no_ijin" id="no_ijin_edit"
                                        placeholder="" value="{{ old('no_ijin') }}">
                                </div>
                                <div class="form-group">
                                    <label for="">Telpon</label>
                                    <input type="text" class="form-control" required name="telpon" id="telpon_edit"
                                        placeholder="" value="{{ old('telpon') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Data Induk Pendaftaran</h1>
            </div>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="section-body">
                <div class="card">
                    @include('data_induk_pendaftaran.nav_tab')
                    <h4></h4>
                    <div class="card-body">
                        <div class="card-header" style="margin-left: -25px;">
                            <div class="card-header-form">
                                <form method="get" action="{{ route('fasilitas_kesehatan.search') }}">
                                    <div class="input-group">
                                        <input type="text" name="keyword" class="form-control" placeholder="Search"
                                            value="{{ $keyword ?? '' }}">
                                        <div class="input-group-btn ml-2">
                                            <button type="submit" class="btn btn-primary"><i
                                                    class="fas fa-search"></i></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped" style="width:100%;">
                                <thead>
                                    <tr class="">
                                        <th>No</th>
                                        <th>Nama</th>
                                        <th>Kode</th>
                                        <th>Unit Kerja</th>
                                        <th>
                                            <div class="row">
                                                <button class="btn btn-primary" data-toggle="modal"
                                                    data-target="#modalAdd"><i class="fas fa-plus"></i></button>
                                                <button onclick="downloadExcel()"class="btn btn-info"
                                                    style="margin-left:3px ;"><i style="font-size:12pt;"
                                                        class="fa fa-print"></i></button>
                                            </div>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($data as $key => $dt)
                                        <tr class="">
                                            <td>{{ $key + $data->firstItem() }}</td>
                                            <td>{{ $dt->nama }}</td>
                                            <td>{{ $dt->kode }}</td>
                                            <td>{{ $dt->unitkerja }}</td>
                                            </td>
                                            <td style="width:5%;">
                                                <div style="display: flex; flex-direction: row;">
                                                    <button onclick="showEditModal('{{ $dt->id }}')"
                                                        class="btn btn-warning mr-1"><i class="fa fa-pencil"></i></button>
                                                    <form action="{{ route('fasilitas_kesehatan.destroy', $dt->id) }}"
                                                        method="post" enctype="multipart/form-data">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button
                                                            onclick="return confirm('Yakin melanjutkan hapus data {{ $dt->nama }} ?')"
                                                            class="btn btn-danger"><i class="fas fa-trash"></i></button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr class="text-center">
                                            <td colspan="10">Data tidak ditemukan</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <div class="row mt-3" style="width: 100%; margin-left:0;">
                            <div class="col-lg-6" style="display: flex; align-items: center;">
                                @if (sizeof($data) > 0)
                                    Showing data {{ $data->firstItem() }} to {{ $data->lastItem() }}, Page
                                    {{ $data->currentPage() }} of {{ $data->lastPage() }} @if ($keyword != '')
                                        (Filtered)
                                    @endif
                                @else
                                    Empty result @if ($keyword != '')
                                        (Filtered)
                                    @endif
                                @endif
                            </div>
                            <div class="col-lg-6" style="justify-content: flex-end; display: flex;">
                                {{ $data->appends(Request::only('keyword'))->links('pagination::bootstrap-4') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script></script>
    <script src="https://code.jquery.com/jquery-3.3.1.min.js"
        integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
    <script>
        $(document).ready(function() {
            // saat input1 berubah ke input-input
            $('#nama, #nama_edit').on('change', function() {
                var text = $(this).val().toLowerCase().replace(/ /g, "-").replace(/\//g, "-");
                $('#slug, #slug_edit').val(text);
            });
        });


        function showEditModal(param) {
            var url = "{{ route('fasilitas_kesehatan.edit', ':id') }}";
            url = url.replace(':id', param);

            $.ajax({
                url: url,
                type: 'GET',
                success: function(response) {
                    if (response == null) {
                        return;
                    }
                    $('#id_edit').val(response.id);
                    $('#nama_edit').val(response.nama);
                    $('#kode_edit').val(response.kode);
                    $("#default_edit").prop("checked", response.df == 0 ? false : true);
                    $('#unit_kerja_edit').val(response.unitkerja);
                    $('#prefix_id_edit').val(response.prefix_id);
                    $("#bridging_edit").prop("checked", response.bridging == 0 ? false : true);
                    $('#last_nrm_edit').val(response.last_nrm);
                    $('#alamat_edit').val(response.alamat);
                    $('#no_ijin_edit').val(response.no_ijin);
                    $('#telpon_edit').val(response.no_ijin);
                    $('#modalEdit').modal('show');
                },
                error: function(request, status, error) {
                    alert("Terjadi error saat edit data, silahkan hubungi admin");
                }
            })
        }

        function downloadExcel() {

            var keyword = $('input[name=keyword]').val();
            var url = "{{ route('fasilitas_kesehatan.download') }}/?keyword=" + keyword;
            if (confirm("Apakah anda ingin melanjutkan download ?")) {
                window.location.href = url;
            } else {
                return false;
            }
        }
    </script>
@endsection
