<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class SuratKeteranganSehatSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $faker = Faker::create('id_ID');
        $nrmList = ['2021110003', '2021110004', '2021110005', '2022057066', '2022108361'];

        for ($i = 1; $i <= 50; $i++) {
            DB::table('surat_keterangan_sehats')->insert([
                'prop' => '',
                'nrm' => $faker->randomElement($nrmList),
                'no_surat' => $faker->text(10),
                'tgl_periksa' => $faker->date('d F Y'),
                'keperluan' => $faker->sentence(5),
                'tinggi_badan' => $faker->numberBetween(150, 200),
                'berat_badan' => $faker->numberBetween(50, 100),
                'suhu_badan' => $faker->randomFloat(2, 36, 40),
                'tekanan_darah' => $faker->text(16),
                'golongan_darah' => $faker->text(8),
                'respirasi' => $faker->numberBetween(10, 30),
                'nadi' => $faker->numberBetween(50, 120),
                'tgl_ttd' => $faker->date('d F Y'),
                'nama_dokter' => $faker->name()
            ]);
        }
    }
}
