<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSmisDocPendaftaranRawatJalanTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smis_doc_pendaftaran_rawat_jalan', function (Blueprint $table) {
            $table->id();
            $table->integer('id_dokumen');
            $table->string('nomor_identitas_lain', 64)->default('');
            $table->string('tempat_lahir', 64)->default('');
            $table->string('nama_ibu_kandung', 64)->default('');
            $table->string('jenis_kelamin', 32)->default('');
            $table->string('no_bpjs_kesehatan', 32)->default('');
            $table->string('no_bpjs_tk', 32)->default('');
            $table->string('status_perkawinan', 32)->default('');
            $table->string('agama_kepercayaan', 32)->default('');
            $table->string('suku', 32)->default('');
            $table->string('bahasa', 32)->default('');
            $table->string('alamat_sesuai_identitas')->default('');
            $table->string('alamat_domisili')->default('');
            $table->string('no_telepon_rumah', 32)->default('');
            $table->string('no_telepon_seluler', 32)->default('');
            $table->string('pendidikan', 32)->default('');
            $table->text('pekerjaan')->nullable();
            $table->string('nama_tempat_kerja', 64)->default('');
            $table->string('alamat_tempat_kerja')->default('');
            $table->string('telepon_tempat_kerja', 32)->default('');
            $table->string('nama_keluarga', 64)->default('');
            $table->string('hubungan_keluarga', 64)->default('');
            $table->string('alamat_keluarga')->default('');
            $table->string('telepon_keluarga', 32)->default('');
            $table->integer('id_petugas')->default(0);
            $table->string('nama_petugas', 64)->default('');
            $table->string('nama_pasien', 64)->default('');
            $table->string('ttd_pasien', 64)->default('');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('smis_doc_pendaftaran_rawat_jalan');
    }
}
