<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSmisDocAsesmenMedisAwalRawatJalanGigiTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smis_doc_asesmen_medis_awal_rawat_jalan_gigi', function (Blueprint $table) {
            $table->id();
            $table->integer('id_dokumen')->unsigned();
            $table->integer('id_diagnosa')->default(0)->unsigned();
            $table->integer('id_lab')->default(0)->unsigned();
            $table->integer('id_resep')->default(0)->unsigned();
            $table->string('keluhan_utama')->default('');
            $table->string('riwayat_penyakit_sekarang')->default('');
            $table->string('riwayat_penyakit_dahulu')->default('');
            $table->string('riwayat_penyakit_kronis')->default('');
            $table->string('riwayat_penyakit_keluarga')->default('');
            $table->string('riwayat_alergi_obat')->default('');
            $table->string('wajah')->default('');
            $table->string('bibir')->default('');
            $table->string('getah_bening')->default('');
            $table->string('palatum')->default('');
            $table->string('lidah')->default('');
            $table->string('dasar_mulut')->default('');
            $table->string('mukosa_pipi')->default('');
            $table->string('lain_lain')->default('');
            $table->string('penunjang_lain')->default('');
            $table->string('tindak_lanjut')->default('');
            $table->string('status_pulang', 10)->default('');
            $table->text('signature')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('smis_doc_asesmen_medis_awal_rawat_jalan_gigi');
    }
}
