<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSmisDocAsesmenMedisAwalRawatJalanTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smis_doc_asesmen_medis_awal_rawat_jalan', function (Blueprint $table) {
            $table->id();
            $table->integer('id_dokumen')->unsigned();
            $table->integer('id_diagnosa')->default(0)->unsigned();
            $table->integer('id_lab')->default(0)->unsigned();
            $table->integer('id_resep')->default(0)->unsigned();
            $table->string('keluhan_utama', 255)->default('');
            $table->string('riwayat_penyakit_sekarang', 255)->default('');
            $table->string('riwayat_penyakit_dahulu', 255)->default('');
            $table->string('riwayat_penyakit_kronis', 255)->default('');
            $table->string('riwayat_penyakit_keluarga', 255)->default('');
            $table->string('riwayat_alergi_obat', 255)->default('');
            $table->string('kepala', 255)->default('');
            $table->string('tn_kepala')->nullable();
            $table->string('thorax', 255)->default('');
            $table->string('tn_thorax')->nullable();
            $table->string('abdomen', 255)->default('');
            $table->string('tn_abdomen')->nullable();
            $table->string('ekstremitas', 255)->default('');
            $table->string('tn_ekstremitas')->nullable();
            $table->string('lain_lain', 255)->default('');
            $table->string('penunjang_lain', 255)->default('');
            $table->string('tindak_lanjut')->default('');
            $table->string('tindakan_medis')->default('');
            $table->string('status_pulang', 64)->default('');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('smis_doc_asesmen_medis_awal_rawat_jalan');
    }
}
