<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSmisDocPengkajianAwalMedisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smis_doc_pengkajian_awal_medis', function (Blueprint $table) {
            $table->id();
            $table->integer('id_dokumen')->unsigned();
            $table->datetime('tanggal');
            $table->string('anamnesa_umum', 64);
            $table->string('diperoleh_dari', 64)->default('');
            $table->text('keluhan_utama');
            $table->text('riwayat_penyakit_sekarang');
            $table->text('riwayat_penyakit_dahulu');
            $table->text('riwayat_obat_obatan');
            $table->text('riwayat_kebiasaan_pekerjaan');
            $table->text('riwayat_alergi_obat');
            $table->tinyInteger('masalah_kejiwaan')->unsigned();
            $table->string('keadaan_umum', 64);
            $table->double('gcs_e');
            $table->double('gcs_v');
            $table->double('gcs_m');
            $table->double('gcs_total');
            $table->string('nadi', 64);
            $table->string('pernafasan', 64);
            $table->string('pernafasan_lain');
            $table->string('nyeri', 64);
            $table->string('lokasi_nyeri');
            $table->integer('skala_nyeri')->unsigned();
            $table->string('jenis', 64);
            $table->string('jenis_lain');
            $table->string('kepala', 32);
            $table->string('tn_kepala')->default('');
            $table->string('mata', 32);
            $table->string('tn_mata')->default('');
            $table->string('tht', 32);
            $table->string('tn_tht')->default('');
            $table->string('leher', 32);
            $table->string('tn_leher')->default('');
            $table->string('mulut', 32);
            $table->string('tn_mulut')->default('');
            $table->string('jantung', 32);
            $table->string('tn_jantung')->default('');
            $table->string('thoraks', 32);
            $table->string('tn_thoraks')->default('');
            $table->string('abdomen', 32);
            $table->string('tn_abdomen')->default('');
            $table->string('kulit', 32);
            $table->string('tn_kulit')->default('');
            $table->string('tulang', 32);
            $table->string('tn_tulang')->default('');
            $table->string('saraf', 32);
            $table->string('tn_saraf')->default('');
            $table->string('genitalia', 32);
            $table->string('tn_genitalia')->default('');
            $table->string('ekstremitas', 32);
            $table->string('tn_ekstremitas')->default('');
            $table->text('status_lokalis');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        
    }
}
