<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSmisDocInformedConsentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smis_doc_informed_consent', function (Blueprint $table) {
            $table->id();
            $table->integer('id_dokumen');
            $table->dateTime('tanggal');
            $table->string('signature', 64);
            $table->string('dokter_pelaksana', 64);
            $table->string('pemberi_informasi', 64);
            $table->string('penerima_informasi', 64);
            $table->string('hubungan', 64);
            $table->string('diagnosis');
            $table->string('dasar_diagnosis');
            $table->string('tindakan_kedokteran');
            $table->string('indikasi_tindakan');
            $table->string('tata_cara');
            $table->string('tujuan');
            $table->string('risiko');
            $table->string('komplikasi');
            $table->string('prognosis');
            $table->string('alternatif_resiko');
            $table->string('lain_lain');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('smis_doc_informed_consent');
    }
}
