<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSuratKeteranganSehatsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('surat_keterangan_sehats', function (Blueprint $table) {
            $table->id();
            $table->string('prop', 8);
            $table->bigInteger('nrm');
            $table->string('no_surat');
            $table->string('tgl_periksa', 32);
            $table->string('keperluan');
            $table->integer('tinggi_badan');
            $table->integer('berat_badan');
            $table->integer('suhu_badan');
            $table->string('tekanan_darah', 16);
            $table->string('golongan_darah', 8);
            $table->integer('respirasi');
            $table->integer('nadi');
            $table->string('tgl_ttd', 32);
            $table->string('nama_dokter');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('surat_keterangan_sehats');
    }
}
