<?php

namespace App\Services\MedicalRecord;

use App\Models\DokumenKunjungan;
use App\Models\ERekamMedis;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ERekamMedisService
{
    function verifikasi_erm($req)
    {
        $verif = ERekamMedis::where('id', $req->id_dokumen ?? $req->dokumen)->update([
            'status' => 1,
            'id_verifikator' => Auth::user()->id,
            'nama_verifikator' => Auth::user()->realname,
            'tanggal_update' => date('Y-m-d H:i:s', strtotime('now'))
        ]);
        return $verif;
    }

    function verifikasi_dokumen_kunjungan($req)
    {
        $verif = DokumenKunjungan::where('id', $req->id_dokumen ?? $req->dokumen)->update([
            'status' => 1,
            'id_verifikator' => Auth::user()->id,
            'nama_verifikator' => Auth::user()->realname,
            'tanggal_update' => date('Y-m-d H:i:s', strtotime('now'))
        ]);
        return $verif;
    }

    function get_dokumen_kunjungan_sebelumnya($req)
    {
        $dokumen = DokumenKunjungan::findOrFail($req->dokumen);
        $all_kunjungan = DB::table('smis_rg_layananpasien')->where('nrm', $dokumen->nrm)
            ->where('id', 'like', '%' . env('slug_klinik') . '%')
            ->orderBy('id', 'desc')->get();

        $kunjungan_sebelumnya = isset($all_kunjungan[1]) ? $all_kunjungan[1] : null;

        if (is_null($kunjungan_sebelumnya)) {
            return [
                'asesmen_medis_awal_rawat_jalan' => null,
                'asesmen_medis_awal_rawat_jalan_gigi' => null,
                'catatan_perkembangan_pasien' => null,
            ];
        }

        $asesmen_medis_awal_rajal = DokumenKunjungan::where('noreg', $kunjungan_sebelumnya->id)->where('prop', '')->where('nama_dokumen', 'Asesmen Medis Awal Rawat Jalan')->first();

        if ($asesmen_medis_awal_rajal) {
            return [
                'asesmen_medis_awal_rawat_jalan' => DB::table('smis_doc_asesmen_medis_awal_rawat_jalan')->where('id_dokumen', $asesmen_medis_awal_rajal->id)->first(),
                'asesmen_medis_awal_rawat_jalan_gigi' => null,
                'catatan_perkembangan_pasien' => null,
            ];
        }

        $asesmen_medis_awal_rajal_gigi = DokumenKunjungan::where('noreg', $kunjungan_sebelumnya->id)->where('prop', '')->where('nama_dokumen', 'Asesmen Medis Awal Rawat Jalan (Gigi)')->first();

        if ($asesmen_medis_awal_rajal_gigi) {
            return [
                'asesmen_medis_awal_rawat_jalan' => null,
                'asesmen_medis_awal_rawat_jalan_gigi' => DB::table('smis_doc_asesmen_medis_awal_rawat_jalan_gigi')->where('id_dokumen', $asesmen_medis_awal_rajal_gigi->id)->first(),
                'catatan_perkembangan_pasien' => null,
            ];
        }

        $dokumen_cppt = DokumenKunjungan::where('noreg', $kunjungan_sebelumnya->id)->where('prop', '')->where('nama_dokumen', 'Catatan Perkembangan Pasien')->first();

        $cppt = null;

        if ($dokumen_cppt) {
            $cppt = DB::table('smis_doc_catatan_perkembangan_pasien')->where('id_dokumen', $dokumen_cppt->id)->first();
        }

        if ($cppt) {
            return [
                'asesmen_medis_awal_rawat_jalan' => null,
                'asesmen_medis_awal_rawat_jalan_gigi' => null,
                'catatan_perkembangan_pasien' => $cppt,
            ];
        }

        return [
            'asesmen_medis_awal_rawat_jalan' => null,
            'asesmen_medis_awal_rawat_jalan_gigi' => null,
            'catatan_perkembangan_pasien' => null,
        ];
    }

    function upload_signature($req)
    {
        $folderPath = public_path('signature_patient/');
        $image_parts = explode(";base64,", $req->signed);

        $image_type_aux = explode("image/", $image_parts[0]);

        $image_type = $image_type_aux[1];

        $image_base64 = base64_decode($image_parts[1]);

        $fileName = uniqid() . '.' . $image_type;
        $file = $folderPath . $fileName;
        file_put_contents($file, $image_base64);
        return $fileName;
    }
}
