<?php

namespace App\Services\MedicalRecord\ERekamMedis\DokumenPasien;

use App\Services\MedicalRecord\ERekamMedisService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class PendaftaranRawatJalanService
{
    function data($req)
    {
        $dokumen = DB::table('e_rekam_medis_pasien')->where('id', $req->dokumen)->first();
        $data = DB::table('smis_doc_pendaftaran_rawat_jalan')->where('id_dokumen', $dokumen->id)->first();
        return [
            'dokumen' => $dokumen,
            'pasien' => DB::table('smis_rg_patient')->where('nrm', $dokumen->nrm)->where('id', 'like', '%'.env('slug_klinik').'%')->first(),
            'data' => $data,
            'employee' => DB::table('smis_hrd_employee')->where('nama', $data->nama_petugas ?? '')->first()
        ];
    }

    function store($req)
    {
        $id_dokumen = $req->dokumen;

        $arrInsert = $req->all();

        unset($arrInsert['_token']);
        unset($arrInsert['dokumen']);
        unset($arrInsert['password']);

        if ($arrInsert['jenis_verifikasi'] != 'pasien') {
            unset($arrInsert['nama_pasien']);
        }

        switch ($arrInsert['jenis_verifikasi']) {
            case 'petugas':
                $arrInsert['id_petugas'] = Auth::user()->id;
                $arrInsert['nama_petugas'] = Auth::user()->realname;

                (new ERekamMedisService)->verifikasi_erm($req);
                break;
            case 'pasien':
                $result = (new ERekamMedisService)->upload_signature($req);
                $arrInsert['ttd_pasien'] = $result;
                break;

            default:
                # code...
                break;
        }

        unset($arrInsert['signed']);
        unset($arrInsert['jenis_verifikasi']);

        foreach ($arrInsert as $state => $value) {
            $arrInsert[$state] = $arrInsert[$state] ?? '';
        }

        DB::table('smis_doc_pendaftaran_rawat_jalan')->updateOrInsert([
            'id_dokumen' => $id_dokumen
        ], $arrInsert);

        return DB::table('smis_doc_pendaftaran_rawat_jalan')->where('id_dokumen', $id_dokumen)->first();
    }
}