<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;

/**
 * Class Services
 * @author rivald 
 */
class JasaDokterBpjsService
{
    public function getTindakan($tindakan, $nilai)
    {
        $tindakanArr = [
            'ECHOCARDIOGRAFI ' => ['operator' => 90000, 'referal' => 200000],
            'TREADMILL ' => ['operator' => 80000, 'referal' => 75000],
            'JASA DOKTER ' => ['operator' => $nilai, 'referal' => 75000],
        ];

        foreach ($tindakanArr as $key => $key_value) {
            if ($tindakan == $key) {
                return $key_value;
            }
        }
    }

    public function getDataByFilter($param)
    {
        //$tindakan = ['ECHOCARDIOGRAFI', 'TREADMILL', 'VASCULAR SCREANING (ABICAVI)', 'DOPPLER VASCULAR 1 KAKI', 'DOPPLER VASCULAR 2 KAKI', 'RAWAT LUKA KECIL', 'RAWAT LUKA SEDANG', 'RAWAT LUKA BESAR', 'HIPNOTERAPI', 'TEST MMPI'];
        $getData = DB::table('smis_rg_layananpasien as pasien')
            ->join(
                DB::raw("(SELECT nama_dokter, noreg_pasien, ruangan, SUBSTR(nama_tagihan, 1, INSTR(nama_tagihan, 'Oleh') - 1) as nama_tagihan, nilai FROM smis_ksr_kolektif 
                        WHERE SUBSTR(nama_tagihan, 1, INSTR(nama_tagihan, 'Oleh') - 1) IN(
                            'ECHOCARDIOGRAFI', 
                            'TREADMILL',
                            'JASA DOKTER') AND ruangan <> 'laboratory' and prop = ' ' ) as kolektif"),
                'pasien.id',
                '=',
                'kolektif.noreg_pasien'
            )
            ->select(
                'pasien.tanggal',
                'pasien.nama_pasien',
                'kolektif.nama_dokter',
                'kolektif.nama_tagihan',
                'kolektif.nilai'
            )
            ->where([
                ['pasien.prop', ' '],
                ['pasien.selesai', 1],
                ['pasien.selesai', '<>', 'Tidak Datang'],
                ['pasien.carabayar', 'bpjs_kesehatan'],
                [DB::raw('DATE(pasien.tanggal)'), '>=', $param->tanggal_dari_conv],
                [DB::raw('DATE(pasien.tanggal)'), '<=', $param->tanggal_sampai_conv],
                ['kolektif.nama_dokter', $param->nama_dokter],
            ])
            ->orderBy('pasien.tanggal', 'ASC');

        return $getData;
    }
}
