<?php

namespace App\Services;

use App\Models\CatatanPerkembanganPasien;
use App\Models\DokumenKunjungan;
use App\Models\ERekamMedis;
use App\Models\InformedConsent;
use App\Models\JawabanKonsultasiPoliLain;
use App\Models\KonsultasiPoliLain;
use App\Models\ObservasiPascaOperasi;
use App\Models\PembedahanOperasiKecil;
use App\Models\PersetujuanTindakanDokter;
use App\Models\SMIS_DFM_Penjualan_Resep;
use App\Models\Smis_Doc_Pengkajian_Awal_Medis;
use App\Models\Smis_Lab_Hasil;
use App\Models\Smis_Lab_Layanan;
use App\Models\Smis_Lab_Pesanan;
use App\Models\SMIS_LayananPasien;
use App\Models\Smis_Mjm_Kelas;
use App\Models\Smis_Mr_Icd;
use App\Models\SMIS_Pasien;
use App\Models\SmisAdmPrototype;
use App\Models\SmisAdmSettings;
use App\Models\SmisHrdEmployee;
use App\Models\SuratKeteranganSakit;
use App\Models\SuratSakit;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Auth;

/**
 * Class Services
 * @author rivald
 */
class ERekamMedisService
{
    function create_dokumen_kunjungan($req)
    {
        $layanan = SMIS_LayananPasien::findOrFail($req->noreg);
        $query = DokumenKunjungan::updateOrCreate([
            'noreg' => $layanan->id,
            'nama_dokumen' => $req->jenis_dokumen,
        ], [
            'nama_pasien' => $layanan->nama_pasien,
            'tanggal' => $layanan->tanggal,
            'nrm' => $layanan->nrm,
            'prop' => '',
            'status' => 0,
            'id_verifikator' => 0,
            'nama_verifikator' => '',
            'tanggal_update' => date('Y-m-d H:i:s', strtotime('+7 hours'))
        ]);

        return $query;
    }

    function update_signature_erm($namafile, $req)
    {
        $query = ERekamMedis::where('id', $req->dokumen)->update([
            'signature_pasien' => $namafile
        ]);
        return $query;
    }

    function dokumen_identitas($req)
    {
        $rm = ERekamMedis::findOrFail($req->dokumen);
        $pasien = SMIS_Pasien::where('id', $rm->nrm)->first();
        $data['pasien'] = SMIS_Pasien::get_pasien_with_asuransi($rm);
        $data['dokumen'] = $req->dokumen;
        $data['rm'] = $rm;
        $data['employee'] = SmisHrdEmployee::where('nama', $rm->nama_verifikator)->first();
        // dd($data['klinik']);
        return $data;
    }

    function verifikasi_dokumen_kunjungan($req)
    {
        $verif = DokumenKunjungan::where('id', $req->id_dokumen ?? $req->dokumen)->update([
            'status' => 1,
            'id_verifikator' => Auth::user()->id,
            'nama_verifikator' => Auth::user()->realname,
            'tanggal_update' => date('Y-m-d H:i:s', strtotime('+7 hours'))
        ]);
        return $verif;
    }

    function verifikasi_erm($req)
    {
        $verif = ERekamMedis::where('id', $req->dokumen)->update([
            'status' => 1,
            'id_verifikator' => Auth::user()->id,
            'nama_verifikator' => Auth::user()->realname,
            'tanggal_update' => date('Y-m-d H:i:s', strtotime('now'))
        ]);
        return $verif;
    }

    function upload_signature($data, $tipe)
    {
        $folderPath = public_path('signature_patient/');

        switch ($tipe) {
            case 'signed':
                $image_parts = explode(";base64,", $data->signed);
                break;
            case 'signed_satu':
                $image_parts = explode(";base64,", $data->sign_saksi_satu);
                break;
            case 'signed_dua':
                $image_parts = explode(";base64,", $data->sign_saksi_dua);
                break;
            case 'signed_menyatakan':
                $image_parts = explode(";base64,", $data->sign_menyatakan);
                break;
            default:
                break;
        }

        $image_type_aux = explode("image/", $image_parts[0]);

        $image_type = $image_type_aux[1];

        $image_base64 = base64_decode($image_parts[1]);

        $fileName = uniqid() . '.' . $image_type;
        $file = $folderPath . $fileName;
        file_put_contents($file, $image_base64);
        return $fileName;
    }

    function select_asesmen_medis_rawat_jalan($req)
    {
        $dokumen = DokumenKunjungan::findOrFail($req->dokumen);
        $query = SMIS_LayananPasien::join('smis_mr_diagnosa', 'smis_mr_diagnosa.noreg_pasien', 'smis_rg_layananpasien.id')
            ->leftJoin('smis_lab_pesanan', 'smis_lab_pesanan.noreg_pasien', 'smis_rg_layananpasien.id')
            ->leftJoin('smis_hrd_employee', 'smis_rg_layananpasien.id_dokter', 'smis_hrd_employee.id')
            ->select(
                'smis_lab_pesanan.periksa',
                'smis_rg_layananpasien.jenislayanan',
                'smis_rg_layananpasien.id',
                'smis_rg_layananpasien.id_dokter',
                'smis_mr_diagnosa.tanggal as tanggal_diagnosa',
                'smis_mr_diagnosa.keluhan',
                'smis_mr_diagnosa.sistole',
                'smis_mr_diagnosa.diastole',
                'smis_mr_diagnosa.nadi',
                'smis_mr_diagnosa.rr',
                'smis_mr_diagnosa.suhu',
                'smis_mr_diagnosa.kode_icd',
                'smis_mr_diagnosa.nama_icd',
                'smis_mr_diagnosa.terapi_non_obat',
                'smis_mr_diagnosa.anamnesa',
                'smis_mr_diagnosa.nama_dokter',
                'smis_hrd_employee.ttd',
            )
            ->where('smis_rg_layananpasien.id', $dokumen->noreg)->first();
        if ($query) {
            $query->tindakan = DB::table('smis_rwt_tindakan_dokter_' . $query->jenislayanan)->where('noreg_pasien', $dokumen->noreg)->first();
            $query->resep = SMIS_DFM_Penjualan_Resep::with(['obat_jadi', 'obat_racik.bahan'])->where('noreg_pasien', $dokumen->noreg)->get();
        }
        $data['dokumen'] = $dokumen;
        $data['layanan'] = $query;
        return $data;
    }

    function get_asesmen_medis_rawat_jalan($req)
    {
        $dokumen = DokumenKunjungan::findOrFail($req->dokumen);
        $query = SMIS_LayananPasien::join('smis_mr_diagnosa', 'smis_mr_diagnosa.noreg_pasien', 'smis_rg_layananpasien.id')
            ->leftJoin('smis_lab_pesanan', 'smis_lab_pesanan.noreg_pasien', 'smis_rg_layananpasien.id')
            ->leftJoin('smis_hrd_employee', 'smis_rg_layananpasien.id_dokter', 'smis_hrd_employee.id')
            ->select(
                'smis_lab_pesanan.periksa',
                'smis_rg_layananpasien.jenislayanan',
                'smis_rg_layananpasien.id',
                'smis_rg_layananpasien.id_dokter',
                'smis_mr_diagnosa.tanggal as tanggal_diagnosa',
                'smis_mr_diagnosa.keluhan',
                'smis_mr_diagnosa.sistole',
                'smis_mr_diagnosa.diastole',
                'smis_mr_diagnosa.nadi',
                'smis_mr_diagnosa.rr',
                'smis_mr_diagnosa.suhu',
                'smis_mr_diagnosa.kode_icd',
                'smis_mr_diagnosa.nama_icd',
                'smis_mr_diagnosa.terapi_non_obat',
                'smis_mr_diagnosa.anamnesa',
                'smis_mr_diagnosa.nama_dokter',
                'smis_hrd_employee.ttd',
            )
            ->whereDate('smis_rg_layananpasien.tanggal', '<=', $dokumen->tanggal)
            ->where('smis_rg_layananpasien.nrm', $dokumen->nrm)
            ->get();

        foreach ($query as $q) {
            $q->tindakan = DB::table('smis_rwt_tindakan_dokter_' . $q->jenislayanan)->where('noreg_pasien', $q->id)->first();
            $q->resep = SMIS_DFM_Penjualan_Resep::with(['obat_jadi', 'obat_racik.bahan'])->where('noreg_pasien', $q->id)->get();
        }

        $data['dokumen'] = $dokumen;
        $data['layanan'] = $query;
        return $data;
    }

    function konsultasi_poli_lain($req)
    {
        $dokumen = DokumenKunjungan::with('konsultasi_poli_lain.jawaban')->leftJoin('smis_adm_user', 'smis_adm_user.id', 'dokumen_kunjungan_pasien.id_verifikator')
            ->select('dokumen_kunjungan_pasien.*', 'smis_adm_user.username')->where('dokumen_kunjungan_pasien.id', $req->dokumen)->first();
        $data['layanan'] = SMIS_LayananPasien::with('diagnosa')->where('id', $dokumen->noreg)->first();
        $data['pasien'] = SMIS_Pasien::where('id', $dokumen->nrm)->where('prop', '')->first();
        $data['dokumen'] = $dokumen;
        return $data;
    }

    function save_konsultasi_poli_lain($req)
    {
        $query = KonsultasiPoliLain::updateOrCreate([
            'id_dokumen' => $req->dokumen
        ], [
            'id_user' => Auth::user()->id,
            'nama_user' => Auth::user()->realname,
            'tanggal' => $req->tanggal . ' ' . $req->jam,
            'jenis' => $req->jenis,
            'id_kepada' => $req->id_kepada,
            'kepada' => $req->kepada,
            'keterangan' => $req->keterangan,
        ]);
        return $query;
    }

    function save_jawaban_konsultasi_poli_lain($req)
    {
        KonsultasiPoliLain::findOrFail($req->konsultasi);

        $query = JawabanKonsultasiPoliLain::updateOrCreate([
            'id_konsultasi' => $req->konsultasi
        ], [
            'jawaban' => $req->jawaban,
            'saran' => $req->saran,
        ]);

        return $query;
    }

    function informed_consent($req)
    {
        $dokumen = DokumenKunjungan::with('informed_consent.persetujuan')->leftJoin('smis_adm_user', 'smis_adm_user.id', 'dokumen_kunjungan_pasien.id_verifikator')
            ->leftJoin('smis_hrd_employee', 'smis_adm_user.realname', 'smis_hrd_employee.nama')
            ->select('smis_hrd_employee.ttd', 'dokumen_kunjungan_pasien.*', 'smis_adm_user.username')->where('dokumen_kunjungan_pasien.id', $req->dokumen)->first();
        $data['layanan'] = SMIS_LayananPasien::with('diagnosa')->where('id', $dokumen->noreg)->first();
        $data['dokumen'] = $dokumen;
        $data['pasien'] = SMIS_Pasien::where('id', $dokumen->nrm)->where('prop', '')->first();
        return $data;
    }

    function save_informed_consent($data)
    {
        $query = InformedConsent::updateOrCreate([
            'id_dokumen' => $data->id_dokumen
        ], [
            'dokter_pelaksana' => $data->dokter_pelaksana,
            'tanggal' => $data->tanggal . ' ' . $data->jam_awal,
            'id_pemberi_informasi' => $data->id_pemberi_informasi,
            'id_dokter_pelaksana' => $data->id_dokter_pelaksana,
            'pemberi_informasi' => $data->pemberi_informasi,
            'penerima_informasi' => $data->penerima_informasi,
            'hubungan' => $data->hubungan,
            'dasar_diagnosis' => $data->dasar_diagnosis,
            'tindakan_kedokteran' => $data->tindakan_kedokteran,
            'indikasi_tindakan' => $data->indikasi_tindakan,
            'tata_cara' => $data->tata_cara,
            'tujuan' => $data->tujuan,
            'risiko' => $data->risiko,
            'komplikasi' => $data->komplikasi,
            'prognosis' => $data->prognosis,
            'alternatif_resiko' => $data->alternatif_resiko,
            'lain_lain' => $data->lain_lain,
            'signature' => ''
        ]);

        return $query;
    }

    function save_persetujuan_tindakan_dokter_informed_consent($data, $ttd, $saksi1, $saksi2)
    {
        $query = PersetujuanTindakanDokter::updateOrCreate([
            'id_informed' => $data->informed
        ], [
            'tanggal' => date('Y-m-d H:i:s', strtotime('now')),
            'nama' => $data->nama_wali,
            'hubungan' => $data->hubungan_wali,
            'umur' => $data->usia_wali,
            'kelamin' => $data->kelamin_wali,
            'alamat' => $data->alamat_wali,
            'menyatakan' => $data->wali_menyatakan,
            'signature' => $ttd,
            'saksi_satu' => $data->saksi_satu ? $data->saksi_satu : '',
            'saksi_dua' => $data->saksi_dua ? $data->saksi_dua : '',
            'signature_saksi_satu' => $saksi1,
            'signature_saksi_dua' => $saksi2,
        ]);

        return $query;
    }

    function save_signature_informed_consent($filename, $id)
    {
        $query = InformedConsent::where('id', $id)->update([
            'signature' => $filename
        ]);
        return $query;
    }

    function pembedahan_operasi_kecil($req)
    {
        $dokumen = DokumenKunjungan::with(['pembedahan_operasi_kecil', 'observasi_pasca_operasi'])->leftJoin('smis_adm_user', 'smis_adm_user.id', 'dokumen_kunjungan_pasien.id_verifikator')
            ->leftJoin('smis_hrd_employee', 'smis_adm_user.realname', 'smis_hrd_employee.nama')
            ->select('smis_hrd_employee.ttd', 'dokumen_kunjungan_pasien.*', 'smis_adm_user.username')->where('dokumen_kunjungan_pasien.id', $req->dokumen)->first();
        $data['layanan'] = SMIS_LayananPasien::with('diagnosa')->where('id', $dokumen->noreg)->first();
        $data['dokumen'] = $dokumen;
        $data['pasien'] = SMIS_Pasien::where('id', $dokumen->nrm)->where('prop', '')->first();
        return $data;
    }

    function observasi_pasaca_operasi_create($data)
    {
        DokumenKunjungan::findOrFail($data->dokumen);

        $query = ObservasiPascaOperasi::create([
            'id_dokumen' => $data->dokumen,
            'jam_menit' => $data->jam_menit,
            't' => $data->t,
            'n' => $data->n,
            'rr' => $data->rr,
            's' => $data->s,
            'keterangan' => $data->keterangan,
        ]);

        return $query;
    }

    function observasi_pasaca_operasi_update($data)
    {
        $query = ObservasiPascaOperasi::where('id', $data->id)->update([
            'jam_menit' => $data->jam_menit,
            't' => $data->t,
            'n' => $data->n,
            'rr' => $data->rr,
            's' => $data->s,
            'keterangan' => $data->keterangan,
        ]);

        return $query;
    }

    function observasi_pasaca_operasi_get_by_dokumen($data)
    {
        DokumenKunjungan::findOrFail($data->dokumen);

        $query = ObservasiPascaOperasi::where('id_dokumen', $data->dokumen)->get();
        return $query;
    }

    function observasi_pasaca_operasi_delete($data)
    {
        $query = ObservasiPascaOperasi::where('id', $data->id)->delete();
        return $query;
    }

    function observasi_pasaca_operasi_select($data)
    {
        $query = ObservasiPascaOperasi::findOrFail($data->id);
        return $query;
    }

    function save_pembedahan_operasi_kecil($data)
    {
        DokumenKunjungan::findOrFail($data->id_dokumen);

        $query = PembedahanOperasiKecil::updateOrCreate([
            'id_dokumen' => $data->id_dokumen
        ], [
            'keluhan_utama' => $data->keluhan_utama,
            'rps' => $data->rps,
            'rpd' => $data->rpd,
            'id_operator' => $data->id_operator,
            'operator' => $data->operator,
            'id_asisten' => $data->id_asisten,
            'asisten' => $data->asisten,
            'tanggal_operasi' => $data->tanggal_operasi,
            'mulai_jam' => $data->mulai_jam,
            'selesai_jam' => $data->selesai_jam,
            'teknik_operasi' => $data->teknik_operasi,
            'jenis_anestesi' => $data->jenis_anestesi,
            'jenis_sedatif' => $data->jenis_sedatif,
            'uraian' => $data->uraian,
        ]);

        return $query;
    }

    function surat_keterangan_sakit($req)
    {
        $dokumen = DokumenKunjungan::with('surat_keterangan_sakit')->where('id', $req->dokumen)->first();
        $data['pasien'] = SMIS_Pasien::where('id', $dokumen->nrm)->first();
        $data['layanan'] = SMIS_LayananPasien::where('id', $dokumen->noreg)->first();
        $data['dokumen'] = $dokumen;
        $data['employee'] = SmisHrdEmployee::where('nama', $dokumen->nama_verifikator)->first();
        $data['nomor_surat'] = $this->get_no_surat_sakit();
        return $data;
    }

    function save_surat_keterangan_sakit($req)
    {
        $dokumen = DokumenKunjungan::findOrFail($req->id_dokumen);
        $query = SuratKeteranganSakit::updateOrCreate([
            'id_dokumen' => $req->id_dokumen,
        ], [
            'nrm' => $dokumen->nrm,
            'no_surat' => $req->no_surat,
            'dari_tanggal' => $req->dari,
            'sampai_tanggal' => $req->sampai,
            'hari' => $req->hari,
            'pekerjaan' => $req->pekerjaan,
            'diagnosa' => $req->diagnosa,
            'tgl_ttd' => date('Y-m-d'),
            'nama_dokter' => Auth::user()->realname
        ]);
        return $query;
    }

    public function get_no_surat_sakit()
    {
        $number = SuratKeteranganSakit::select('no_surat', DB::raw("SUBSTRING_INDEX(`no_surat`, '/', -1) AS `nomor`"))->where([
            [DB::raw("SUBSTRING_INDEX(SUBSTRING_INDEX(`no_surat`, '/', 2), '/', -1)"), date('d.m.Y')]
        ])->orderBy('no_surat', 'DESC')->first();

        if (!isset($number->no_surat)) {
            return "SK.SEHAT/" . date('d.m.Y') . "/1";
        }
        $explode = explode("/", $number->no_surat);

        return $explode[0] . "/" . $explode[1] . "/" . ($explode[2] + 1) ?? "failed get number";
    }

    function catatan_perkembangan_pasien($req)
    {
        $dokumen = DokumenKunjungan::with('catatan_perkembangan_pasien')->where('id', $req->dokumen)->first();
        $data['pasien'] = SMIS_Pasien::where('id', $dokumen->nrm)->first();
        $data['layanan'] = SMIS_LayananPasien::where('id', $dokumen->noreg)->first();
        $data['dokumen'] = $dokumen;
        $data['employee'] = SmisHrdEmployee::where('nama', $dokumen->nama_verifikator)->first();
        $data['ppa'] = SmisHrdEmployee::leftjoin('smis_hrd_job', 'smis_hrd_employee.jabatan', 'smis_hrd_job.id')
            ->whereIn('smis_hrd_job.slug', ['apoteker', 'dokter', 'perawat', 'fisioterapi'])
            ->get();
        return $data;
    }

    function save_catatan_perkembangan_pasien($req)
    {
        $dokumen = DokumenKunjungan::findOrFail($req->id_dokumen);
        $query = CatatanPerkembanganPasien::updateOrCreate([
            'id_dokumen' => $req->id_dokumen,
        ], [
            'nrm' => $req->nrm,
            'tanggal' => $req->tanggal,
            'id_ppa' => (int)$req->id_ppa,
            'ppa' => $req->ppa,
            'hasil_pemeriksaan' => $req->hasil_pemeriksaan,
            'intruksi_ppa' => $req->intruksi_ppa,
            'tgl_ttd' => date('Y-m-d'),
            'nama_dokter' => Auth::user()->realname
        ]);
        return $query;
    }

    function save_pengkajian_awal_medis($req)
    {
        $dokumen = DokumenKunjungan::findOrFail($req->dokumen);
        $query = Smis_Doc_Pengkajian_Awal_Medis::updateOrCreate([
            'id_dokumen' => $req->dokumen,
        ], [
            'tanggal' => $req->tanggal . ' ' . $req->pukul . ':00',
            'anamnesa_umum' => $req->anamnesa_umum,
            'diperoleh_dari' => $req->diperoleh_dari ? $req->diperoleh_dari : '',
            'keluhan_utama' => $req->keluhan_utama,
            'riwayat_penyakit_sekarang' => $req->riwayat_penyakit_sekarang,
            'riwayat_penyakit_dahulu' => $req->riwayat_penyakit_dahulu,
            'riwayat_obat_obatan' => $req->riwayat_obat_obatan,
            'riwayat_kebiasaan_pekerjaan' => $req->riwayat_kebiasaan_pekerjaan,
            'riwayat_alergi_obat' => $req->riwayat_alergi_obat,
            'masalah_kejiwaan' => $req->masalah_kejiwaan,
            'keadaan_umum' => $req->keadaan_umum,
            'gcs_e' => $req->gcs_e,
            'gcs_v' => $req->gcs_v,
            'gcs_m' => $req->gcs_m,
            'gcs_total' => $req->gcs_total,
            'nadi' => $req->nadi,
            'pernafasan' => $req->pernafasan,
            'pernafasan_lain' => $req->pernafasan_lain ? $req->pernafasan_lain : '',
            'nyeri' => $req->nyeri,
            'lokasi_nyeri' => $req->lokasi_nyeri ? $req->lokasi_nyeri : '',
            'skala_nyeri' => $req->skala_nyeri,
            'jenis' => $req->jenis,
            'jenis_lain' => $req->jenis_lain ? $req->jenis_lain : '',
            'kepala' => $req->kepala,
            'tn_kepala' => $req->tn_kepala ? $req->tn_kepala : '',
            'mata' => $req->mata,
            'tn_mata' => $req->tn_mata ? $req->tn_mata : '',
            'tht' => $req->tht,
            'tn_tht' => $req->tn_tht ? $req->tn_tht : '',
            'leher' => $req->leher,
            'tn_leher' => $req->tn_leher ? $req->tn_leher : '',
            'mulut' => $req->mulut,
            'tn_mulut' => $req->tn_mulut ? $req->tn_mulut : '',
            'jantung' => $req->jantung,
            'tn_jantung' => $req->tn_jantung ? $req->tn_jantung : '',
            'thoraks' => $req->thoraks,
            'tn_thoraks' => $req->tn_thoraks ? $req->tn_thoraks : '',
            'abdomen' => $req->abdomen,
            'tn_abdomen' => $req->tn_abdomen ? $req->tn_abdomen : '',
            'kulit' => $req->kulit,
            'tn_kulit' => $req->tn_kulit ? $req->tn_kulit : '',
            'tulang' => $req->tulang,
            'tn_tulang' => $req->tn_tulang ? $req->tn_tulang : '',
            'saraf' => $req->saraf,
            'tn_saraf' => $req->tn_saraf ? $req->tn_saraf : '',
            'genitalia' => $req->genitalia,
            'tn_genitalia' => $req->tn_genitalia ? $req->tn_genitalia : '',
            'ekstremitas' => $req->ekstremitas,
            'tn_ekstremitas' => $req->tn_ekstremitas ? $req->tn_ekstremitas : '',
            'status_lokalis' => $req->status_lokalis,
        ]);
        return $query;
    }

    function save_gambar_lokasi_pengkajian_awal_medis($req)
    {
        $folderPath = public_path('status_lokalis/');

        $image_parts = explode(";base64,", $req->signed);

        $image_type_aux = explode("image/", $image_parts[0]);

        $image_type = $image_type_aux[1];

        $image_base64 = base64_decode($image_parts[1]);

        $fileName = uniqid() . '.' . $image_type;
        $file = $folderPath . $fileName;
        file_put_contents($file, $image_base64);

        $query = Smis_Doc_Pengkajian_Awal_Medis::where('id_dokumen', $req->dokumen)->update([
            'gambar_status_lokalis' => $fileName
        ]);

        return $query;
    }

    function data_pengkajian_awal_medis($req)
    {
        DokumenKunjungan::findOrFail($req->dokumen);
        $dokumen = DokumenKunjungan::with('pengkajian_awal_medis', 'diagnosa', 'pesanan_lab')->where('id', $req->dokumen)->first();
        $dokumen->resep = SMIS_DFM_Penjualan_Resep::with(['obat_jadi', 'obat_racik.bahan'])->where('noreg_pasien', $dokumen->noreg)->get();
        $user = User::where('id', $dokumen->id_verifikator)->first();
        $layanan = SMIS_LayananPasien::with('diagnosa')->join('smis_rg_patient', 'smis_rg_patient.id', 'smis_rg_layananpasien.nrm')
            ->select('smis_rg_patient.telpon', 'smis_rg_patient.ibu', 'smis_rg_patient.nama', 'smis_rg_patient.tgl_lahir', 'smis_rg_patient.alamat', 'smis_rg_patient.rt', 'smis_rg_patient.rw', 'smis_rg_patient.nama_kelurahan', 'smis_rg_patient.nama_kecamatan', 'smis_rg_patient.nama_kabupaten', 'smis_rg_layananpasien.*')
            ->where('smis_rg_layananpasien.id', $dokumen->noreg)->first();
        if ($layanan) {
            if ($layanan->diagnosa) {
                if ($layanan->diagnosa->diagnosa_sekunder1) {
                    $data['kode_sekunder1'] = Smis_Mr_Icd::where('nama', $layanan->diagnosa->diagnosa_sekunder1)->first();
                }
                if ($layanan->diagnosa->diagnosa_sekunder2) {
                    $data['kode_sekunder2'] = Smis_Mr_Icd::where('nama', $layanan->diagnosa->diagnosa_sekunder2)->first();
                }
                if ($layanan->diagnosa->diagnosa_sekunder3) {
                    $data['kode_sekunder3'] = Smis_Mr_Icd::where('nama', $layanan->diagnosa->diagnosa_sekunder3)->first();
                }
            }
        }
        $data['employee'] = $user ? SmisHrdEmployee::where('nama', $user->realname)->first() : [];
        $data['pemeriksaan'] = Smis_Lab_Layanan::where('prop', '')->get();
        $data['kelas'] = SmisAdmSettings::where('name', 'smis-rs-kelas-' . $layanan->last_ruangan)->first();
        $data['ruangan'] = SmisAdmPrototype::where('prop', '')->get();
        $data['list_kelas'] = Smis_Mjm_Kelas::where('prop', '')->get();
        $data['master_hasil'] = Smis_Lab_Hasil::where('prop', '')->orderBy('grup')->get();
        $data['dokumen'] = $dokumen;
        $data['layanan'] = $layanan;
        return $data;
    }

    function pesanan_lab($noreg)
    {
        $data = DB::table('smis_lab_pesanan')->where([
            'noreg_pasien' => $noreg,
            'prop' => ''
        ])->get();
        return $data;
    }

    public function lab_pesanan_store($req)
    {
        $pesanan = Smis_Lab_Pesanan::where('noreg_pasien', $req->noreg)->where('prop', '')->first();
        $hapusan_darah = '<p>' .
            '<br>' .
            '</p>' .
            '<table class="table table-bordered">' .
            '<tbody>' .
            '<tr>' .
            '<td>' .
            '<span style="font-weight: bold;">Jenis Sel</span>' .
            '</td>' .
            '<td>' .
            '<span style="font-weight: bold;">Hasil Pemeriksaan</span>' .
            '</td>' .
            '</tr>' .
            '<tr>' .
            '<td>Eritrosit</td>' .
            '<td>-</td>' .
            '</tr>' .
            '<tr>' .
            '<td>Leukosit</td>' .
            '<td>-</td>' .
            '</tr>' .
            '<tr>' .
            '<td>Trombosit</td>' .
            '<td>-</td>' .
            '</tr>' .
            '<tr>' .
            '<td>' .
            '<span style="font-weight: bold;">Kesimpulan</span>' .
            '</td>' .
            '<td>-</td>' .
            '</tr>' .
            '</tbody>' .
            '</table>' .
            '<p>' .
            '<br>' .
            '</p>';

        $jumlah_pesanan = Smis_Lab_Pesanan::where('noreg_pasien', $req->noreg)->whereMonth('tanggal', date('m', strtotime($req->tanggal)))->count();
        $layanan_pasien = SMIS_LayananPasien::where('id', $req->noreg)->first();
        $map_layanan = [];
        $map_harga = [];
        $map_hasil = [];
        $total = 0;
        $layanan = Smis_Lab_Layanan::where('prop', '')->get();
        $list_hasil = Smis_Lab_Hasil::where('prop', '')->get();
        $setting_harga = SmisAdmSettings::where('name', 'smis_lab_harga')->where('prop', '')->first();
        $ruangan = SmisAdmPrototype::where('slug', $req->ruangan)->first();
        $list_harga = $setting_harga ? $setting_harga->value : [];
        $temp = json_decode($list_harga, true);
        $key = array_keys($temp);

        foreach ($layanan as $lay) {
            if (in_array($lay->slug, $req->pemeriksaan)) {
                $map_layanan[$lay->slug] = 1;
            } else {
                $map_layanan[$lay->slug] = 0;
            }
        }

        for ($i = 0; $i < sizeof($key); $i++) {
            if (strpos($key[$i], $req->kelas . '_') !== false) {
                $map_harga[$key[$i]] = $temp[$key[$i]];
                $decrease = str_replace($req->kelas . '_', '', $key[$i]);
                if (array_key_exists($decrease, $map_layanan)) {
                    if ($map_layanan[$decrease] == 1) {
                        $total += $temp[$key[$i]];
                    }
                }
            }
        }

        foreach ($list_hasil as $lh) {
            $map_hasil[$lh->slug] = "";
        }

        $umur = substr($req->umur, 0, 2);
        $umur = trim($umur);

        $no_lab = $this->format_no_lab($jumlah_pesanan);

        $pasien = SMIS_Pasien::where('id', $req->nrm)->first();

        $data = [
            'periksa_lain' => '',
            'total_biaya' => $total,
            'biaya_lain' => 0,
            'input_di' => $ruangan ? strtoupper($ruangan->nama) : '',
            'operator' => Auth::user()->realname,
            'cetak_hasil_ke' => 0,
            'keterangan_hasil' => '',
            'setting_kelas' => '',
            'prop' => '',
            'id_paket' => null,
            'tanggal' => $req->tanggal,
            'nama_pasien' => $req->nama_pasien,
            'nrm_pasien' => $req->nrm,
            'noreg_pasien' => $req->noreg,
            'jk' => $pasien ? $pasien->kelamin : 0,
            'kelas' => $req->kelas,
            'umur' => $req->umur,
            'alamat' => $req->alamat,
            'ibu' => $req->ibu ? $req->ibu : '',
            'limapuluh' => $umur >= 50 ? 1 : 0,
            'carabayar' => $req->jenis_pasien,
            'id_marketing' => 0,
            'marketing' => '',
            'ruangan' => $req->ruangan,
            'no_lab' => 'L' . $no_lab . '/' . $this->romawi(date('m')) . '-' . $this->dua_digit_tahun(date('Y')) . '/LSRB',
            'id_dokter' => $req->id_dokter,
            'nama_dokter' => $req->dokter,
            'id_konsultan' => $req->id_konsultan ? $req->id_konsultan : 0,
            'nama_konsultan' => $req->konsultan ? $req->konsultan : '',
            'id_petugas' => $req->id_petugas ? $req->id_petugas : 0,
            'nama_petugas' => $req->petugas ? $req->petugas : '',
            'periksa' => json_encode($map_layanan),
            'hasil' => json_encode($map_hasil),
            'hapusan_darah' => $hapusan_darah,
            'harga' => json_encode($map_harga),
            'biaya' => $total,
            'pembagian' => '',
            'selesai' => 0,
            'waktu_daftar' => date('Y-m-d H:i:s'),
            'waktu_ditangani' => '0000-00-00 00:00:00',
            'waktu_selesai' => '0000-00-00 00:00:00',
            'waktu_ditangani_hapusan' => '0000-00-00 00:00:00',
            'waktu_selesai_hapusan' => '0000-00-00 00:00:00',
            'uri' => $layanan_pasien ? $layanan_pasien->uri : '',
            'cetak_1' => '',
            'cetak_2' => '',
            'cetak_3' => '',
            'cetak_gabung' => '',
            'response_time' => 0,
            'response_time_hapusan' => 0,
            'diagnosa' => $req->diagnosa ? $req->diagnosa : '',
            'file' => '',
            'akunting' => 0,
            'autonomous' => '',
            'duplicate' => 0,
            'origin' => '',
            'origin_id' => 0,
            'time_updated' => 0,
            'origin_updated' => ''
        ];
        if ($pesanan) {
            $insert = DB::table('smis_lab_pesanan')->where('no_lab', $pesanan->no_lab)->update($data);
        } else {
            $insert = DB::table('smis_lab_pesanan')->insert($data);
        }
        return $insert;
    }

    function format_no_lab($jumlah)
    {
        $temp = $jumlah + 1;
        if ($temp < 10) {
            return '000' . $temp;
        } else if ($temp > 9 && $temp < 100) {
            return '00' . $temp;
        } else {
            return '0' . $temp;
        }
    }

    function dua_digit_tahun($thn)
    {
        $temp = str_split($thn);
        return $temp[sizeof($temp) - 2] . $temp[sizeof($temp) - 1];
    }

    function romawi($bln)
    {
        switch ($bln) {
            case 1:
                return "I";
                break;
            case 2:
                return "II";
                break;
            case 3:
                return "III";
                break;
            case 4:
                return "IV";
                break;
            case 5:
                return "V";
                break;
            case 6:
                return "VI";
                break;
            case 7:
                return "VII";
                break;
            case 8:
                return "VIII";
                break;
            case 9:
                return "IX";
                break;
            case 10:
                return "X";
                break;
            case 11:
                return "XI";
                break;
            case 12:
                return "XII";
                break;
        }
    }
}
