<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;

/**
 * Class Services
 * @author yourname
 */
class DiskonPenjualanObatDokterService
{

    public function getStokObat($id, $label)
    {
        if ($label == "jadi") {
            return DB::table('smis_dfm_stok_pakai_obat_jadi')->select('jumlah')->where([['id_penjualan_obat_jadi', $id], ['prop', ' ']])->get()->sum('jumlah');
        } else {
            return DB::table('smis_dfm_stok_pakai_bahan')->select('jumlah')->where([['id_bahan', $id], ['prop', ' ']])->get()->sum('jumlah');
        }
    }

    public function getDiskon($id)
    {
        $diskonPersen = 0;
        $diskonNominal = 0;

        $diskon = DB::table('smis_fr_dobat_masuk')->where([['id', $id], ['prop', ' ']])->first();

        if ($diskon != null) {
            if ($diskon->t_diskon == "persen") {
                $diskonPersen = $diskon->diskon;
            }
            if ($diskon->t_diskon == "nominal") {
                $diskonNominal = $diskon->diskon;
            }
        }

        return ['persen' => $diskonPersen, 'nominal' => $diskonNominal, 'konversi' => $diskon->konversi, 'jumlah' => $diskon->jumlah];
    }

    public function getPenjualanResep($param) //get untuk kolom 1-4
    {
        $namaDokter = "'$param->nama_dokter'";
        $tanggalDari = "'$param->tanggal_dari_conv'";
        $tanggalSampai = "'$param->tanggal_sampai_conv'";

        $dataResult = DB::table(DB::raw(
            "(select obat_jadi.label, obat_jadi.nama_obat, resep.nomor_resep, resep.tanggal, resep.nama_pasien, resep.nama_dokter, obat_jadi.id_qty, obat_jadi.jumlah, obat_jadi.harga
              from (select * from smis_dfm_penjualan_resep where prop = ' ' and dibatalkan = 0 and nama_dokter=" . $namaDokter . " and date(tanggal) >= " . $tanggalDari . " and date(tanggal) <= " . $tanggalSampai . ") as resep
                left join
                  (SELECT s_racikan.id_penjualan_resep,s_racikan.harga, s_racikan.jumlah, s_bahan_racikan.id as id_qty, s_bahan_racikan.nama_obat,s_bahan_racikan.id_obat, 'racikan' as label
                    FROM smis_dfm_penjualan_obat_racikan as s_racikan
                    INNER JOIN smis_dfm_bahan_pakai_obat_racikan as s_bahan_racikan
                    ON s_racikan.id = s_bahan_racikan.id_penjualan_obat_racikan
                    WHERE s_racikan.prop = ' ' and s_bahan_racikan.prop = ' '
                    UNION ALL
                    SELECT id_penjualan_resep, harga,jumlah, id as id_qty, nama_obat, id_obat, 'jadi' as label FROM smis_dfm_penjualan_obat_jadi WHERE prop = ' ') as obat_jadi
                on resep.id = obat_jadi.id_penjualan_resep) as table_resep"
        ))->join(DB::raw('(select stok_obat.hna, stok_obat.ppn, stok_obat.id_dobat_masuk, sub_join.id_penjualan_obat_jadi
                from smis_fr_stok_obat as stok_obat
                inner join
                    (SELECT jadi.id_stok_obat, jadi.id_penjualan_obat_jadi FROM
                    (SELECT stok_obat.f_id, obat_jadi.id_stok_obat, obat_jadi.prop, obat_jadi.id_penjualan_obat_jadi
                    FROM smis_dfm_stok_pakai_obat_jadi as obat_jadi
                    JOIN smis_dfm_stok_obat as stok_obat on obat_jadi.id_stok_obat = stok_obat.id) as jadi
                    INNER JOIN smis_fr_stok_obat_keluar as keluar ON jadi.f_id = keluar.id where jadi.prop = " " and keluar.prop = " "
                    UNION ALL
                    SELECT bahan.id_stok_obat, bahan.id_bahan as id_penjualan_obat_jadi FROM smis_dfm_stok_pakai_bahan as bahan
                                INNER JOIN smis_fr_stok_obat_keluar as keluar
                                ON bahan.id_bahan = keluar.id where bahan.prop = " " and keluar.prop = " ") as sub_join
                on sub_join.id_stok_obat = stok_obat.id) as harga_tb'), 'harga_tb.id_penjualan_obat_jadi', 'table_resep.id_qty');

        return $dataResult;
    }
}
