<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;

/**
 * Class Services
 * @author rivald 
 */
class DataIndukPendaftaranService
{
    public function getKopExcel()
    {
        $title = DB::table('smis_adm_settings')->where('name', 'smis_autonomous_title')->first();
        $address = DB::table('smis_adm_settings')->where('name', 'smis_autonomous_address')->first();

        return [
            'title' => $title->value,
            'address' => $address->value
        ];
    }

    public function getDataById($id, $table)
    {
        return DB::table($table)->where([
            ['id', $id],
            ['prop', ' '],
        ])->first();
    }

    public function getData($table)
    {
        return DB::table($table)->where('prop', " ");
    }

    public function deleteData($id, $table)
    {
        try {
            DB::table($table)
                ->where('id', $id)
                ->update([
                    'prop' => "del",
                    'time_updated' => date('Y-m-d H:i:s')
                ]);
            return 'sukses';
        } catch (Exception $th) {
            return $th->getMessage();
        }
    }

    //Action Jenis Kunjungan
    public function createJenisKunjungan($request)
    {
        try {
            DB::table('smis_rg_jenis_kunjungan')->insert([
                'nama' => $request->nama,
                'keluar' => isset($request->keluar) ? 1 : 0,
                'is_sakit' => $request->is_sakit,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateJenisKunjungan($request)
    {
        try {
            DB::table('smis_rg_jenis_kunjungan')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'keluar' => isset($request->keluar) ? 1 : 0,
                    'is_sakit' => $request->is_sakit,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchJenisKunjungan($request)
    {
        $data = DB::table('smis_rg_jenis_kunjungan')
            ->where([
                ['prop', ' '],
                ['nama', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    //Jenis Kontak
    public function createJenisKontak($request)
    {
        try {
            DB::table('smis_rg_jenis_kontak')->insert([
                'nama' => $request->nama,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateJenisKontak($request)
    {
        try {
            DB::table('smis_rg_jenis_kontak')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchJenisKontak($request)
    {
        $data = DB::table('smis_rg_jenis_kontak')
            ->where([
                ['prop', ' '],
                ['nama', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    //Bahasa
    public function createJenisBahasa($request)
    {
        try {
            DB::table('smis_rg_bahasa')->insert([
                'nama' => $request->nama,
                'indoasing' => isset($request->indoasing) ? 1 : 0,
                'keterangan' => $request->keterangan ?? " ",
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateBahasa($request)
    {
        try {
            DB::table('smis_rg_bahasa')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'indoasing' => isset($request->indoasing) ? 1 : 0,
                    'keterangan' => $request->keterangan ?? " ",
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchBahasa($request)
    {
        $data = DB::table('smis_rg_bahasa')
            ->where([
                ['prop', ' '],
                ['nama', 'like', '%' . $request->keyword . '%']
            ])->orWhere([
                ['prop', ' '],
                ['keterangan', 'like', '%' . $request->keyword . '%']
            ]);


        return $data;
    }

    // Suku
    public function createSuku($request)
    {
        try {
            DB::table('smis_rg_suku')->insert([
                'nama' => $request->nama,
                'propinsi' => $request->propinsi,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchSuku($request)
    {
        $data = DB::table('smis_rg_suku')
            ->where([
                ['prop', ' '],
                ['nama', 'like', '%' . $request->keyword . '%']
            ])->orWhere([
                ['prop', ' '],
                ['propinsi', 'like', '%' . $request->keyword . '%']
            ]);;

        return $data;
    }

    public function updateSuku($request)
    {
        try {
            DB::table('smis_rg_suku')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'propinsi' => $request->propinsi,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    //Perusahaan
    public function createPerusahaan($request)
    {
        try {
            DB::table('smis_rg_perusahaan')->insert([
                'nama' => $request->nama,
                'alamat' => $request->alamat,
                'telpon' => $request->telpon,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updatePerusahaan($request)
    {
        try {
            DB::table('smis_rg_perusahaan')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'alamat' => $request->alamat,
                    'telpon' => $request->telpon,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchPerusahaan($request)
    {
        $data = DB::table('smis_rg_perusahaan')
            ->where([
                ['prop', ' '],
                ['nama', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['alamat', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['telpon', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }
    //PPK Rujukan 
    public function createPpkRujukan($request)
    {
        try {
            DB::table('smis_rg_ppk_rujukan')->insert([
                'nama' => $request->nama,
                'alamat' => $request->alamat,
                'telpon' => $request->telpon,
                'operator' => $request->operator,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updatePpkRujukan($request)
    {
        try {
            DB::table('smis_rg_ppk_rujukan')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'alamat' => $request->alamat,
                    'telpon' => $request->telpon,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchPpkRujukan($request)
    {
        $data = DB::table('smis_rg_ppk_rujukan')
            ->where([
                ['prop', ' '],
                ['nama', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['alamat', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['telpon', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['operator', 'like', '%' . $request->keyword . '%']

            ]);

        return $data;
    }

    //Speisalis PPK
    public function createPpkSpesialis($request)
    {
        $explode = explode(',', $request->nama_ppk_rujukan);
        $nama_rujukan = $explode[0];
        $id_rujukan = $explode[1];
        //dd($nama_rujukan, $id_rujukan);
        try {
            DB::table('smis_rg_ppk_spesialis')->insert([
                'spesialis' => $request->nama_spesialis,
                'operator' => $request->operator,
                'nama_ppk_rujukan' => $nama_rujukan,
                'id_ppk_rujukan' => $id_rujukan,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updatePpkSpesialis($request)
    {
        $explode = explode(',', $request->nama_ppk_rujukan);
        $nama_rujukan = $explode[0];
        $id_rujukan = $explode[1];
        try {
            DB::table('smis_rg_ppk_spesialis')
                ->where('id', $request->id)
                ->update([
                    'spesialis' => $request->nama_spesialis,
                    'nama_ppk_rujukan' => $nama_rujukan,
                    'id_ppk_rujukan' => $id_rujukan,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchPpkSpesialis($request)
    {
        $data = DB::table('smis_rg_ppk_spesialis')
            ->where([
                ['prop', ' '],
                ['spesialis', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['nama_ppk_rujukan', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['operator', 'like', '%' . $request->keyword . '%']

            ]);

        return $data;
    }

    // Asuransi 
    public function createAsuransi($request)
    {
        try {
            DB::table('smis_rg_asuransi')->insert([
                'nama' => $request->nama,
                'alamat' => $request->alamat,
                'telpon' => $request->telpon,
                'akhir_kontrak' => date('Y-m-d', strtotime($request->akhir_kontrak)),
                'awal_kontrak' => date('Y-m-d', strtotime($request->awal_kontrak)),
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateAsuransi($request)
    {
        try {
            DB::table('smis_rg_asuransi')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'alamat' => $request->alamat,
                    'telpon' => $request->telpon,
                    'akhir_kontrak' => date('Y-m-d', strtotime($request->akhir_kontrak)),
                    'awal_kontrak' => date('Y-m-d', strtotime($request->awal_kontrak)),
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchAsuransi($request)
    {
        $data = DB::table('smis_rg_asuransi')
            ->where([
                ['prop', ' '],
                ['nama', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['alamat', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['telpon', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    public function createJenisPasien($request)
    {
        try {
            DB::table('smis_rg_jenispasien')->insert([
                'nama' => $request->nama,
                'slug' => $request->slug,
                'keterangan' => $request->keterangan ?? " ",
                'nobpjs' => $request->bpjs,
                'asuransi' => $request->asuransi,
                'nama_perusahaan' => $request->perusahaan,
                'plafon' => $request->plafon,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateJenisPasien($request)
    {
        try {
            DB::table('smis_rg_jenispasien')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'slug' => $request->slug,
                    'keterangan' => $request->keterangan ?? " ",
                    'nobpjs' => $request->bpjs,
                    'asuransi' => $request->asuransi,
                    'nama_perusahaan' => $request->perusahaan,
                    'plafon' => $request->plafon,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchJenisPasien($request)
    {
        $data = DB::table('smis_rg_jenispasien')
            ->where([
                ['prop', ' '],
                ['nama', 'like', '%' . $request->keyword . '%']
            ])
            ->where([
                ['prop', ' '],
                ['slug', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['keterangan', 'like', '%' . $request->keyword . '%']
            ]);


        return $data;
    }

    //Fasilitas Kesehatan

    public function getUnitKerja()
    {
        return DB::table('smis_rg_pcare_settings')->where('prop', '')->select('klinik')->get();
    }

    public function createFasilitasKesehatan($request)
    {
        //dd($request->all());
        try {
            DB::table('smis_rg_faskes')->insert([
                'nama' => $request->nama,
                'kode' => $request->kode,
                'df' => isset($request->default) ? 1 : 0,
                'bridging' => isset($request->bridging) ? 1 : 0,
                'alamat' => $request->alamat,
                'no_ijin' => $request->no_ijin,
                'telpon' => $request->telpon,
                'unitkerja' => $request->unit_kerja,
                'prefix_id' => $request->prefix_id,
                'last_nrm' => $request->last_nrm,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateFasilitasKesehatan($request)
    {
        try {
            DB::table('smis_rg_faskes')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'kode' => $request->kode,
                    'df' => isset($request->default) ? 1 : 0,
                    'bridging' => isset($request->bridging) ? 1 : 0,
                    'alamat' => $request->alamat,
                    'no_ijin' => $request->no_ijin,
                    'telpon' => $request->telpon,
                    'unitkerja' => $request->unit_kerja,
                    'prefix_id' => $request->prefix_id,
                    'last_nrm' => $request->last_nrm,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchFasilitasKesehatan($request)
    {
        $data = DB::table('smis_rg_faskes')
            ->where([
                ['prop', ' '],
                ['nama', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['kode', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['unitkerja', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }
    // Provinsi
    public function createProvinsi($request)
    {
        try {
            DB::table('smis_rg_propinsi')->insert([
                'nama' => $request->nama,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateProvinsi($request)
    {
        try {
            DB::table('smis_rg_propinsi')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchProvinsi($request)
    {
        $data = DB::table('smis_rg_propinsi')
            ->where([
                ['prop', ' '],
                ['nama', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    // Kabupaten
    public function getDataKab()
    {
        return DB::table('smis_rg_kabupaten as kab')
            ->join('smis_rg_propinsi as prov', 'kab.no_prop', 'prov.id')
            ->select('kab.id', 'prov.nama as provinsi', 'kab.nama as kabupaten')
            ->where('kab.prop', " ");
    }

    public function createKabupaten($request)
    {
        try {
            DB::table('smis_rg_kabupaten')->insert([
                'nama' => $request->nama,
                'no_prop' => $request->prop_id,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateKabupaten($request)
    {
        try {
            DB::table('smis_rg_kabupaten')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'no_prop' => $request->prop_id,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchKabupaten($request)
    {
        $data = DB::table('smis_rg_kabupaten as kab')
            ->join('smis_rg_propinsi as prov', 'kab.no_prop', 'prov.id')
            ->select('kab.id', 'prov.nama as provinsi', 'kab.nama as kabupaten')
            ->where([
                ['kab.prop', ' '],
                ['kab.nama', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    // Kabupaten
    public function getKabupatenByProvinsi($id_provinsi)
    {
        return DB::table('smis_rg_kabupaten')->where([
            ['no_prop', $id_provinsi],
            ['prop', ' '],
        ])->get();
    }

    public function createKecamatan($request)
    {
        try {
            DB::table('smis_rg_kec')->insert([
                'nama' => $request->nama,
                'no_prop' => $request->prop_id,
                'no_kab' => $request->kabupaten,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function updateKecamatan($request)
    {
        try {
            DB::table('smis_rg_kec')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'no_prop' => $request->prop_id,
                    'no_kab' => $request->kabupaten,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getDataKec()
    {
        return DB::table('smis_rg_kabupaten as kab')
            ->join('smis_rg_propinsi as prov', 'kab.no_prop', 'prov.id')
            ->join('smis_rg_kec as kec', 'kab.id', 'kec.no_kab')
            ->select('kec.id', 'prov.nama as provinsi', 'kab.nama as kabupaten', 'kec.nama as kecamatan')
            ->where('kec.prop', "");
    }

    public function getSearchKecamatan($request)
    {
        $data = DB::table('smis_rg_kabupaten as kab')
            ->join('smis_rg_propinsi as prov', 'kab.no_prop', 'prov.id')
            ->join('smis_rg_kec as kec', 'kab.id', 'kec.no_kab')
            ->select('kec.id', 'prov.nama as provinsi', 'kab.nama as kabupaten', 'kec.nama as kecamatan')
            ->where([
                ['kec.prop', ' '],
                ['kec.nama', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['kec.prop', ' '],
                ['kab.nama', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    public function getDataKecById($id)
    {
        return DB::table('smis_rg_kabupaten as kab')
            ->join('smis_rg_propinsi as prov', 'kab.no_prop', 'prov.id')
            ->join('smis_rg_kec as kec', 'kab.id', 'kec.no_kab')
            ->select('kec.no_prop', 'kec.no_kab', 'kec.id', 'prov.nama as provinsi', 'kab.nama as kabupaten', 'kec.nama as kecamatan')
            ->where([
                ['kec.prop', " "],
                ['kec.id', $id]
            ])->first();
    }

    public function getDataKelurahan()
    {
        return DB::table('smis_rg_propinsi as prov')
            ->join('smis_rg_kabupaten as kab', 'kab.no_prop', 'prov.id')
            ->join('smis_rg_kec as kec', 'kec.no_kab', 'kab.id')
            ->join('smis_rg_kelurahan as lurah', 'lurah.no_kec', 'kec.id')
            ->select('lurah.id', 'lurah.nama as kelurahan', 'prov.nama as provinsi', 'kab.nama as kabupaten', 'kec.nama as kecamatan')
            ->where('lurah.prop', "0");
    }

    public function getSearchKelurahan($request)
    {
        $data = DB::table('smis_rg_kabupaten as kab')
            ->join('smis_rg_propinsi as prov', 'kab.no_prop', 'prov.id')
            ->join('smis_rg_kec as kec', 'kab.id', 'kec.no_kab')
            ->join('smis_rg_kelurahan as lurah', 'lurah.no_kec', 'kec.id')
            ->select('lurah.id', 'lurah.nama as kelurahan', 'prov.nama as provinsi', 'kab.nama as kabupaten', 'kec.nama as kecamatan')
            ->where([
                ['lurah.prop', '<>', 'del'],
                ['kec.nama', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['lurah.prop', '<>', 'del'],
                ['kab.nama', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['lurah.prop', '<>', 'del'],
                ['lurah.nama', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    public function getKecamatanByKabupaten($id_kecamatan)
    {
        return DB::table('smis_rg_kec')->where([
            ['no_kab', $id_kecamatan],
            ['prop', ''],
        ])->get();
    }

    public function createKelurahan($request)
    {
        try {
            DB::table('smis_rg_kelurahan')->insert([
                'nama' => $request->nama,
                'no_kec' => $request->kecamatan,
                'no_prop' => $request->prop_id,
                'no_kab' => $request->kabupaten,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getDataKelurahanById($id)
    {
        return DB::table('smis_rg_propinsi as prov')
            ->join('smis_rg_kabupaten as kab', 'kab.no_prop', 'prov.id')
            ->join('smis_rg_kec as kec', 'kec.no_kab', 'kab.id')
            ->join('smis_rg_kelurahan as lurah', 'lurah.no_kec', 'kec.id')
            ->select('lurah.nama as kelurahan', 'lurah.no_prop', 'lurah.no_kec', 'lurah.no_kab', 'lurah.id', 'prov.nama as provinsi', 'kab.nama as kabupaten', 'kec.nama as kecamatan')
            ->where([
                ['kec.prop', " "],
                ['lurah.id', $id]
            ])->first();
    }

    public function updateKelurahan($request)
    {
        try {
            DB::table('smis_rg_kelurahan')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'no_kec' => $request->kecamatan,
                    'no_prop' => $request->prop_id,
                    'no_kab' => $request->kabupaten,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    //Perujuk
    public function createPerujuk($request)
    {
        try {
            DB::table('smis_rg_perujuk')->insert([
                'nama' => $request->nama,
                'alamat' => $request->alamat,
                'instansi' => $request->instansi,
                'prop' =>  " ",
                'autonomous' => " ",
                'duplicate' => 0,
                'origin' => " ",
                'origin_id' => 0,
                'time_updated' => date('Y-m-d H:i:s'),
                'origin_updated' => ''
            ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function getSearchPerujuk($request)
    {
        $data = DB::table('smis_rg_perujuk')
            ->where([
                ['prop', ' '],
                ['nama', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['alamat', 'like', '%' . $request->keyword . '%']
            ])
            ->orWhere([
                ['prop', ' '],
                ['instansi', 'like', '%' . $request->keyword . '%']
            ]);

        return $data;
    }

    public function updatePerujuk($request)
    {
        try {
            DB::table('smis_rg_perujuk')
                ->where('id', $request->id)
                ->update([
                    'nama' => $request->nama,
                    'alamat' => $request->alamat,
                    'instansi' => $request->instansi,
                    'time_updated' => date('Y-m-d H:i:s')
                ]);

            return 'sukses';
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }
}
