<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SMIS_LayananPasien extends Model
{
    use HasFactory;

    protected $table = 'smis_rg_layananpasien';

    public $incrementing = false;

    protected $keyType = 'string';

    function diagnosa(){
        return $this->hasOne('App\Models\SMIS_Diagnosa', 'noreg_pasien', 'id');
    }

    function laborat(){
        return $this->hasOne('App\Models\SMIS_LabPesanan', 'noreg_pasien', 'id');
    }

    function hpp(){
        return $this->hasMany('App\Models\KSR_Kolektif', 'noreg_pasien', 'id')->where('prop', '');
    }

    function dokumen_kunjungan(){
        return $this->hasMany('App\Models\DokumenKunjungan', 'noreg', 'id')->where('prop', '');
    }
}
