<?php

namespace App\Http\Requests;

use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class TukarTandaTerimaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'tanggal' => 'required | date_format:d-m-Y',
            'no' => 'required',
            'nama_supplier' => 'required',
            'username' => 'required'
        ];
    }

    protected function passedValidation()
    {
        $this->merge([
            'tanggal' => Carbon::parse($this->tanggal)->format('Y-m-d'),
            'updated_at' => date('Y-m-d H:i:s')
        ]);
    }
}
