<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SuratKeteranganSakitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'diagnosa' => 'required',
            'pekerjaan' => 'required',
            'hari' => 'required',
            'dari' => 'required',
            'sampai' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'diagnosa.required' => 'Pilih diagnosa dahulu',
            'pekerjaan.required' => 'Pekerjaan harus diisi',
            'hari.required' => 'Lama hari harus diisi',
            'dari.required' => 'Pilih tanggal darir dahulu',
            'sampai.required' => 'Pilih tanggal sampai dahulu',
        ];
    }
}
