<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PembedahanOperasiKecilRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'keluhan_utama' => 'required',
            'rps' => 'required',
            'rpd' => 'required',
            'id_operator' => 'required',
            'operator' => 'required',
            'id_asisten' => 'required',
            'asisten' => 'required',
            'tanggal_operasi' => 'required|date_format:"Y-m-d"',
            'mulai_jam' => 'required',
            'selesai_jam' => 'required',
            'teknik_operasi' => 'required',
            'jenis_anestesi' => 'required',
            'jenis_sedatif' => 'required',
            'uraian' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'keluhan_utama.required' => 'Keluhan utama harus diisi',
            'rps.required' => 'RPS utama harus diisi',
            'rpd.required' => 'RPD utama harus diisi',
            'id_operator.required' => 'Pilih operator dahulu',
            'operator.required' => 'Pilih operator dahulu',
            'id_asisten.required' => 'Pilih asisten dahulu',
            'asisten.required' => 'Pilih asisten dahulu',
            'tanggal_operasi.required' => 'Pilih tanggal operasi dahulu',
            'tanggal_operasi.date_format' => 'Format tanggal operasi tidak sesuai',
            'mulai_jam.required' => 'Pilih mulai jam dahulu',
            'selesai_jam.required' => 'Pilih selesai jam dahulu',
            'teknik_operasi.required' => 'Teknik operasi harus diisi',
            'jenis_anestesi.required' => 'Jenis anestesi harus diisi',
            'jenis_sedatif.required' => 'Jenis sedatif harus diisi',
            'uraian.required' => 'Uraian harus diisi',
        ];
    }
}
