<?php

namespace App\Http\Controllers;

use App\Services\LaporanTindakanDetailDokterService;
use App\Services\SuratKeteranganSehatService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use PDF;
use RealRashid\SweetAlert\Facades\Alert;
use Yajra\DataTables\DataTables;

class SuratKeteranganSehatController extends Controller
{

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $menu = json_decode(Auth::user()->menu);
            if (property_exists($menu, 'medical_record')) {
                $arr = (array) $menu->medical_record;
                if ($arr['surat_keterangan_sehat'] == 0) {
                    return redirect('home');
                }
            } else {
                return redirect('home');
            }
            return $next($request);
        });
    }

    public function index(Request $request, SuratKeteranganSehatService $suratKeteranganSehatService)
    {
        return view('surat_keterangan_sehat.index', [
            'datas' => $suratKeteranganSehatService->getSurateKetSehat($request->keyword)->paginate(10),
            'keyword' => $request->keyword ?? ""
        ]);
    }

    public function create(SuratKeteranganSehatService $suratKeteranganSehatService, LaporanTindakanDetailDokterService $laporanTindakanDetailDokterService)
    {
        return view('surat_keterangan_sehat.add_edit', [
            'datas' => $suratKeteranganSehatService->getPatient()->paginate(10),
            'dokters' => $laporanTindakanDetailDokterService->getDokterName(),
            'no_surat' => $suratKeteranganSehatService->getNoSk(),
            'tanggal' => $suratKeteranganSehatService->konversiTanggal(date('d-m-Y'))
        ]);
    }

    public function store(Request $request, SuratKeteranganSehatService $suratKeteranganSehatService)
    {
        $createData = $suratKeteranganSehatService->store($request);
        if ($createData == "sukses") {
            Alert::success("Sukses", "Data Berhasil Diperbarui");
            return redirect(route('surat_keterangan_sehat.index'));
        }
        return redirect()->back()->withErrors($createData);
    }

    public function edit($id, SuratKeteranganSehatService $suratKeteranganSehatService, LaporanTindakanDetailDokterService $laporanTindakanDetailDokterService)
    {
        $data_surat = $suratKeteranganSehatService->getSurateKetSehatById($id);
        return view('surat_keterangan_sehat.add_edit', [
            'datas' => $suratKeteranganSehatService->getPatient()->paginate(10),
            'dokters' => $laporanTindakanDetailDokterService->getDokterName(),
            'data_surat' => $data_surat,
            'no_surat' => $data_surat->no_surat,
            'tanggal' => $suratKeteranganSehatService->konversiTanggal(date('d-m-Y'))
        ]);
    }

    public function destroy($id, SuratKeteranganSehatService $suratKeteranganSehatService)
    {
        $deleteData = $suratKeteranganSehatService->delete($id);
        if ($deleteData == "sukses") {
            Alert::success("Sukses", "Data Berhasil Dihapus");
            return redirect(route('surat_keterangan_sehat.index'));
        }
        return redirect()->back()->withErrors($updateData);
    }

    public function download($id, SuratKeteranganSehatService $suratKeteranganSehatService)
    {
        $alamat = $suratKeteranganSehatService->getAddress();
        $data_surat = $suratKeteranganSehatService->getSurateKetSehatById($id);
        PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
        $pdf = PDF::loadView('surat_keterangan_sehat.pdf', ['address' => $alamat, 'data_surat' => $data_surat])->setPaper('legal', 'portrait')->setWarnings(false);
        //return $pdf->stream();
        return $pdf->download('Surat Keterangan Sehat ' . $data_surat->nama . '.pdf');
    }

    public function getPasien(SuratKeteranganSehatService $suratKeteranganSehatService)
    {
        $data = $suratKeteranganSehatService->getPatient();
        return DataTables::of($data)->addIndexColumn()->make(true);
    }
}
