<?php

namespace App\Http\Controllers\DataIndukKepegawaian;

use App\Exports\DataIndukKepegawaian\PendidikanProfesiExport;
use App\Http\Controllers\Controller;
use App\Services\DataIndukKepegawaianService;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use RealRashid\SweetAlert\Facades\Alert;

class PendidikanProfesiController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return view('data_induk_kepegawaian.pendidikan_profesi', [
            'role' => 'pendidikan_profesi',
            'keyword' => '',
            'data' => $dataIndukKepegawaianService->getData('smis_hrd_pendidikan_profesi')->paginate(10)
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $store = $dataIndukKepegawaianService->createPendidikanProfesi($request);
        if ($store == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Kepegawaian Pendidikan Profesi berhasil ditambahkan');
        } else {
            Alert::error('Gagal', $store);
        }
        return redirect()->route('pendidikan_profesi.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return response()->json($dataIndukKepegawaianService->getDataById($id, 'smis_hrd_pendidikan_profesi'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $update = $dataIndukKepegawaianService->updatePendidikanProfesi($request);
        if ($update == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Kepegawaian Pendidikan Profesi berhasil diperbarui');
        } else {
            Alert::error('Gagal', $update);
        }
        return redirect()->route('pendidikan_profesi.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $delete = $dataIndukKepegawaianService->deleteData($id, 'smis_hrd_pendidikan_profesi');
        if ($delete == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Pendidikan Profesi berhasil dihapus');
        } else {
            Alert::error('Gagal', $delete);
        }
        return redirect()->route('pendidikan_profesi.index');
    }

    public function search(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return view('data_induk_kepegawaian.pendidikan_profesi', [
            'data' => $dataIndukKepegawaianService->getSearchPendidikanProfesi($request)->paginate(10),
            'keyword' => $request->keyword,
            'role' => 'pendidikan_profesi'
        ]);
    }

    public function download(Request $request)
    {
        return Excel::download(new PendidikanProfesiExport($request), 'Data_Induk_Pendidikan_Profesi.xlsx');
    }
}
