<?php

namespace App\Http\Controllers\DataIndukKepegawaian;

use App\Exports\DataIndukKepegawaian\BagianExport;
use App\Http\Controllers\Controller;
use App\Services\DataIndukKepegawaianService;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use RealRashid\SweetAlert\Facades\Alert;

class BagianController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return view('data_induk_kepegawaian.bagian', [
            'role' => 'bagian',
            'keyword' => '',
            'data' => $dataIndukKepegawaianService->getData('smis_hrd_job')->paginate(10)
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $store = $dataIndukKepegawaianService->createBagian($request);
        if ($store == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Kepegawaian Bagian berhasil ditambahkan');
        } else {
            Alert::error('Gagal', $store);
        }
        return redirect()->route('bagian.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return response()->json($dataIndukKepegawaianService->getDataById($id, 'smis_hrd_job'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $update = $dataIndukKepegawaianService->updateBagian($request);
        if ($update == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Kepegawaian Bagian berhasil diperbarui');
        } else {
            Alert::error('Gagal', $update);
        }
        return redirect()->route('bagian.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        $delete = $dataIndukKepegawaianService->deleteData($id, 'smis_hrd_job');
        if ($delete == 'sukses') {
            Alert::success('Berhasil', 'Data Induk Bagian berhasil dihapus');
        } else {
            Alert::error('Gagal', $delete);
        }
        return redirect()->route('bagian.index');
    }

    public function search(Request $request, DataIndukKepegawaianService $dataIndukKepegawaianService)
    {
        return view('data_induk_kepegawaian.bagian', [
            'data' => $dataIndukKepegawaianService->getSearchBagian($request)->paginate(10),
            'keyword' => $request->keyword,
            'role' => 'bagian'
        ]);
    }

    public function download(Request $request)
    {
        return Excel::download(new BagianExport($request), 'Data_Induk_Bagian.xlsx');
    }
}
