<?php

namespace App\Http\Controllers;

use App\Services\AplicareService;
use Illuminate\Support\Facades\Auth;

class AplicareController extends Controller
{
    function __construct()
    {
        $this->middleware(function ($request, $next) {
            $menu = json_decode(Auth::user()->menu);
            if (property_exists($menu, 'aplicare')) {
                $arr = (array) $menu->aplicare;
                if ($arr['aplicare'] == 0) {
                    return redirect('home');
                }
                if ($arr['credentials'] == 0) {
                    return redirect('home');
                }
            } else {
                return redirect('home');
            }
            return $next($request);
        });
    }

    public function BedBpjs(AplicareService $aplicareService)
    {
        return $aplicareService->available_beds();
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(AplicareService $aplicareService)
    {
        return view('aplicare.aplicare.index', $aplicareService->getData());
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(AplicareService $aplicareService)
    {
        return $aplicareService->create_beds();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(AplicareService $aplicareService)
    {
        return $aplicareService->update_beds();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(AplicareService $aplicareService)
    {
        return $aplicareService->delete_beds();
    }
}
