<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Antrian;
use App\Models\RsCredential;
use App\Models\SmisAdmPrototype;
use App\Models\SmisHrdEmployee;
use App\Models\SmisAdmSettings;
use App\Models\JadwalPoli;
use Auth;
use GuzzleHttp\Client;

class AntrianPoliController extends Controller
{
    function __construct()
    {
        $this->middleware(function ($request, $next) {
            $menu = json_decode(Auth::user()->menu);
            if (property_exists($menu, 'antrian')) {
                $arr = (array) $menu->antrian;
                if ($arr['poli'] == 0) {
                    return redirect('home');
                }
            } else {
                return redirect('home');
            }
            return $next($request);
        });
    }

    function index()
    {
        $poli_local = [];
        $proto = SmisAdmPrototype::where('parent', 'rawat')->where('prop', '<>', 'del')->where('slug', 'like', '%' . env('slug_klinik') . '%')->get();
        foreach ($proto as $pro) {
            $cek = SmisAdmSettings::where('name', 'smis-rs-urjip-' . $pro->slug)->select('value')->first();
            if ($cek) {
                if ($cek->value == 'URJ') {
                    array_push($poli_local, $pro);
                }
            }
        }
        $data['poli'] = $poli_local;
        $data['dokter'] = SmisHrdEmployee::where('jabatan', 2)->orWhere('jabatan', 1)->orWhere('jabatan', 22)->orWhere('jabatan', 23)->select('nama')->get();
        return view('antrian.poli', $data);
    }

    function filter(Request $req)
    {
        $query = Antrian::where('tanggalperiksa', date('Y-m-d'))
            ->where('antrians.unit_kerja', env('NAMA_KLINIK'));
        if ($req->dokter != null) {
            $query->where('namadokter', 'like', '%' . $req->dokter . '%');
        }
        if ($req->poli != null) {
            $query->where('namapoli', 'like', '%' . $req->poli . '%');
        }
        $hasil = $query->where('taskid', '<=', 4)->where('antrians.keterangan', '!=', 'farmasi')->orderBy('angkaantrean')->get();
        return response()->json($hasil);
    }

    function layani_antrian(Request $req)
    {
        $antrian = Antrian::findOrFail($req->id);

        $waktu = strtotime(now()) . '000';

        // $obj_bpjs = new CheckinController();
        // $hit_bpjs = $obj_bpjs->update_waktu_antrian(4, $antrian->kodebooking, $waktu);

        Antrian::where('id', $req->id)->update([
            'taskid' => 4,
            'waktu_taskid_empat' => $waktu,
            'updated_at' => date('Y-m-d H:i:s', strtotime('+7 hours'))
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Ok'
        ]);
    }

    function selesai_antrian(Request $req)
    {
        $antrian = Antrian::findOrFail($req->id);

        $waktu = strtotime(now()) . '000';

        // $obj_bpjs = new CheckinController();
        // $hit_bpjs = $obj_bpjs->update_waktu_antrian(5, $antrian->kodebooking, $waktu);

        if ($req->lanjut == 0) {
            Antrian::where('id', $req->id)->update([
                'taskid' => 5,
                'waktu_taskid_lima' => $waktu,
                'updated_at' => date('Y-m-d H:i:s', strtotime('now'))
            ]);
        } else {
            Antrian::where('id', $req->id)->update([
                'taskid' => 5,
                'waktu_taskid_lima' => $waktu,
                'keterangan' => 'farmasi',
                'updated_at' => date('Y-m-d H:i:s', strtotime('now'))
            ]);
        }

        return response()->json([
            'status' => true,
            'message' => 'Ok'
        ]);
    }

    function batal_antrian(Request $req)
    {
        try {
            $antrian = Antrian::findOrFail($req->id);
            $jadwal = JadwalPoli::where('id', $antrian->jadwal_id)->first();

            if ($antrian->carabayar == 'bpjs') {
                $client = new Client([
                    'verify' => false
                ]);

                $credentials = RsCredential::where('layanan', 'antrian')->where('slug_klinik', env('slug_klinik'))->first();

                if (is_null($credentials)) {
                    return redirect()->back()->with('gagal', 'RS Credential tidak valid');
                }

                date_default_timezone_set('UTC');
                $timeStamp = strval(time() - strtotime('1970-01-01 00:00:00'));
                $signature = (new GuestRegistrationController())->get_signature($timeStamp, $credentials->cons_id, $credentials->cons_secret);

                $response = $client->request('post', $credentials->base_url . '/antrean/batal', [
                    'headers' => [
                        'x-cons-id'     => $credentials->cons_id,
                        'x-timestamp'  => $timeStamp,
                        'x-signature'   => $signature,
                        'user_key' => $credentials->user_key,
                    ],
                    'body' => json_encode([
                        'tanggalperiksa' => $antrian->tanggalperiksa,
                        'kodepoli' => $jadwal->kodepoli_bpjs,
                        "nomorkartu" => $antrian->nobpjs,
                        "alasan" => $req->keterangan
                    ])
                ])->getBody()->getContents();
                $result = json_decode($response);
                if ($result->metadata->code == 200) {
                    Antrian::where('id', $req->id)->update(['taskid' => 99, 'keterangan' => $req->keterangan]);
                    return response()->json([
                        'status' => true,
                        'message' => $result->metadata->message
                    ]);
                }
                return response()->json([
                    'status' => false,
                    'message' => isset($result->metadata->message) ? $result->metadata->message : $response
                ]);
            } else {
                Antrian::where('id', $req->id)->update(['taskid' => 99, 'keterangan' => $req->keterangan]);
                return response()->json([
                    'status' => true,
                    'message' => 'Ok'
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage()
            ]);
        }
    }
}
