<?php

namespace App\Helpers;

use App\Models\Antrian;
use App\Models\JadwalPoli;

class GeneralHelper
{
	public static function generateAntrean($dokter, $jadwal_id, $kodepoli, $tanggalperiksa)
	{
		$alpha = [
			'A', 'B', 'C', 'D', 'E', 'F', 'G',
			'H', 'I', 'J', 'K', 'L', 'M', 'N', 
			'O', 'P', 'Q', 'R', 'S', 'T', 'U', 
			'V', 'W', 'X', 'Y', 'Z'
		];

		$jadwal = JadwalPoli::where('id', $jadwal_id)->where('prop', '')->first();
		$nomor = Antrian::where("jadwal_id", $jadwal_id)->whereDate("tanggalperiksa", $tanggalperiksa)->count() + 1;
		$nom = str_pad($nomor, 4, '0', STR_PAD_LEFT);
		$tanggalperiksa = date("dmY", strtotime($tanggalperiksa));

		$nomorantrean = self::cek_kode_poli($jadwal->kodepoli_bpjs);

		$antrian = [
			"nomorantrean" => $alpha[$nomorantrean-1] . $nomor,
			"angkaantrean" => $nomor,
			"kodebooking" => $tanggalperiksa . $kodepoli . $dokter . $nom,
		];
		return $antrian;
	}

	static function cek_kode_poli($kode){
		if ($kode[1] == '0') {
			if ($kode[0] == '0') {
				return $kode[2];
			}else{
				return $kode;
			}
		}else if ($kode[0] == '0') {
			if ($kode[1] == '0') {
				return $kode[2];
			}else{
				return $kode[1].$kode[2];
			}
		}
		return $kode;
	}
}
