<?php

namespace App\Exports;

use App\Services\PenerimaanKasirService;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Sheet;
use Maatwebsite\Excel\Concerns\WithEvents;

class PenerimaanKasirExport implements FromView, WithEvents
{
    private $requestData;
    function __construct($data)
    {
        $this->requestData = $data;
    }

    public function view(): View
    {
        $penerimaanKasirService = new PenerimaanKasirService();
        return view('laporan_penerimaan_kasir.excel', [
            'tanggal_dari' => $this->requestData->tanggal_dari,
            'tanggal_sampai' => $this->requestData->tanggal_sampai,
            'data' => $penerimaanKasirService->getByFilter($this->requestData)->get(),
            'rekap_tindakan_dokter' => $penerimaanKasirService->getRekapTindakanDokter($this->requestData)->get()
        ]);
    }

    public function registerEvents(): array
    {
        Sheet::macro('styleCells', function (Sheet $sheet, string $cellRange, array $style) {
            $sheet->getDelegate()->getStyle($cellRange)->applyFromArray($style);
        });

        return [
            AfterSheet::class => function (AfterSheet $event) {

                $event->sheet->getColumnDimension('A')->setWidth(10);
                $event->sheet->getColumnDimension('B')->setWidth(14);
                $event->sheet->getColumnDimension('C')->setWidth(22);
                $event->sheet->getColumnDimension('D')->setWidth(19);
                $event->sheet->getColumnDimension('E')->setWidth(11);
                $event->sheet->getColumnDimension('F')->setWidth(30);
                $event->sheet->getColumnDimension('G')->setWidth(25);
                $event->sheet->getColumnDimension('H')->setWidth(11);
                $event->sheet->getColumnDimension('I')->setWidth(15);
                $event->sheet->getColumnDimension('J')->setWidth(10);
                $event->sheet->getColumnDimension('K')->setWidth(10);
                $event->sheet->getColumnDimension('L')->setWidth(10);
                $event->sheet->getColumnDimension('M')->setWidth(10);
                $event->sheet->getColumnDimension('N')->setWidth(10);
                $event->sheet->getColumnDimension('O')->setWidth(10);
            },
        ];
    }
}
