<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class AntrianEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */

     public $nomor;
    public $loket;
    public $bagian;
    public $manual;
    public $antrian;
    public $pasien_baru;

    public $pasien;

    public function __construct($loket, $nomor, $bagian, $pasien ,$antrian, $pasien_baru, $manual)
    {
        $this->nomor = $nomor;
        $this->loket = $loket;
        $this->bagian = $bagian;
        $this->manual = $manual;
        $this->antrian = $antrian;
        $this->pasien_baru = $pasien_baru;
        $this->pasien = $pasien;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return ['my-channel'];
    }

    public function broadcastAs()
    {
        return 'my-event';
    }
}
