<?php

namespace App\Console\Commands\SatuSehat;

use App\Models\SMIS_LayananPasien;
use App\Services\SatuSehat\RawatJalanService;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SendLayanan extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'satu_sehat:send_layanan';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Scheduling untuk mengirim layanan pasien ke satu sehat';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try {
            $layanan = SMIS_LayananPasien::whereNotIn('carapulang', ['Tidak Datang', 'Rawat Inap'])
            ->join('smis_rg_patient', 'smis_rg_layananpasien.id_pasien', 'smis_rg_patient.id')
            ->where([
                ['smis_rg_patient.prop', ''],
                ['smis_rg_layananpasien.prop', ''],
                ['uri', 0],
                ['selesai', 1],
                [DB::raw('date(smis_rg_layananpasien.tanggal)'), date('Y-m-d', strtotime('-1 days'))],
                ['jenislayanan', 'like', '%poli%'],
                ['smis_rg_layananpasien.id', 'like', '%'.env('slug_klinik').'%']
            ])
            ->select(
                'smis_rg_layananpasien.id',
                'smis_rg_layananpasien.nrm',
            )
            ->get();

            foreach ($layanan as $lay) {
                try {
                    $result = (new RawatJalanService)->send($lay->id);
                    Log::channel('satu_sehat')->info('Noreg (' . $lay->id . ') NRM (' . $lay->nrm . ') : ' . $result['message']);
                } catch (\Throwable $th) {
                    Log::channel('satu_sehat')->info('Error (' . $lay->id . ') NRM (' . $lay->nrm . ') : ' . $result['message']);
                }
            }

            Log::channel('satu_sehat')->info('===== Kirim Selesai =====');
        } catch (\Throwable $th) {
            Log::channel('satu_sehat')->info('Error : '.$th->getMessage());
        }
    }
}
