@extends('layouts.app')
@section('content')
    <div class="modal fade" id="modal_pasien" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Pilih Pasien</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-12 table-responsive">
                            <table class="table table-hover table-striped" style="font-size: 13px;" id="tabelListPasien">
                                <thead>
                                    <tr>
                                        <th scope="col">No. RM</th>
                                        <th scope="col">Nama</th>
                                        <th scope="col">Tempat Lahir</th>
                                        <th scope="col">Tanggal Lahir</th>
                                        <th scope="col">Jenis Kelamin</th>
                                        <th scope="col">Alamat</th>
                                        <th scope="col">Pekerjaan</th>
                                        <th scope="col">Umur</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Surat Keterangan Sehat</h1>
            </div>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="section-body">
                <div class="card">
                    <form action="{{ route('surat_keterangan_sehat.store') }}" method="POST">
                        @csrf
                        <input type="hidden" value="{{ $data_surat->id ?? '' }}" name="nrm" id="nrm" />
                        <input type="hidden" value="{{ $data_surat->id_surat ?? '' }}" name="id" id="id" />
                        <div class="col-lg-12 row mt-4 ">
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>No</label>
                                    <input class="form-control" type="text" value="{{ $no_surat }}" name="no_surat"
                                        id="no_surat" readonly />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Nama</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" onclick="openPasienModal()"
                                            id="nama" name="nama" value="{{ $data_surat->nama ?? '' }}"
                                            disabled style="width: 300px;">
                                        <a href="#" class="btn btn-info" onclick="openPasienModal()"
                                            data-toggle="tooltip" title="Pilih Klien"><i class="fas fa-list"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Tempat/Tgl Lahir & Umur</label>
                                    <input class="form-control" type="text"
                                        value="{{ ($data_surat->tempat_lahir ?? '') . ' ' . date('d-m-Y', strtotime($data_surat->tgl_lahir ?? '')) . ' & ' . ($data_surat->age ?? '') }}"
                                        name="ttl_umur" id="ttl_umur" disabled />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Jenis Kelamin</label>
                                    <input class="form-control" type="text"
                                        value="{{ $data_surat->kelamin ?? '' == 1 ? 'Perempuan' : 'Laki-laki' }} "
                                        name="kelamin" id="kelamin" disabled />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Alamat</label>
                                    <input class="form-control" type="text" value="{{ $data_surat->alamat ?? '' }}"
                                        name="alamat" id="alamat" disabled />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Pekerjaan</label>
                                    <input class="form-control" type="text" value="{{ $data_surat->pekerjaan ?? '' }}"
                                        name="pekerjaan" id="pekerjaan" disabled />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Tanggal Periksa</label>
                                    <input class="form-control dateformat" type="text"
                                        value="{{ $data_surat->tgl_periksa ?? $tanggal }}" name="tgl_periksa" id="tgl_periksa" />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Untuk Keperluan</label>
                                    <input class="form-control" type="text" value="{{ $data_surat->keperluan ?? '' }}"
                                        name="keperluan" id="keperluan" />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Tinggi Badan</label>
                                    <div class="input-group mb-2">
                                        <input type="number" class="form-control" placeholder=""
                                            aria-describedby="basic-addon2" name="tinggi_badan"
                                            value="{{ $data_surat->tinggi_badan ?? '' }}">
                                        <div class="input-group-append">
                                            <span class="input-group-text" id="basic-addon2">cm</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Berat Badan</label>
                                    <div class="input-group mb-2">
                                        <input type="number" class="form-control" placeholder=""
                                            aria-describedby="basic-addon2" name="berat_badan"
                                            value="{{ $data_surat->berat_badan ?? '' }}">
                                        <div class="input-group-append">
                                            <span class="input-group-text" id="basic-addon2">kg</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Suhu Badan</label>
                                    <div class="input-group mb-2">
                                        <input type="number" class="form-control" placeholder=""
                                            aria-describedby="basic-addon2" name="suhu_badan"
                                            value="{{ $data_surat->suhu_badan ?? '' }}">
                                        <div class="input-group-append">
                                            <span class="input-group-text" id="basic-addon2">°C</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Tekanan Darah</label>
                                    <div class="input-group mb-2">
                                        <input type="text" class="form-control" placeholder=""
                                            aria-describedby="basic-addon2" name="tekanan_darah"
                                            value="{{ $data_surat->tekanan_darah ?? '' }}">
                                        <div class="input-group-append">
                                            <span class="input-group-text" id="basic-addon2">mm/Hg</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Golongan Darah</label>
                                    <select class="form-control" name="golongan_darah" id="gol_darah">
                                        <option {{( $data_surat->golongan_darah  ?? '' ) == "" ? "selected" : ""}} value="">--Silahkan Pilih--</option>
                                        <option {{ ($data_surat->golongan_darah ?? '') == 'A' ? 'selected' : '' }}
                                            value="A">A</option>
                                        <option {{ ($data_surat->golongan_darah ?? '') == 'AB' ? 'selected' : '' }}
                                            value="AB">AB</option>
                                        <option {{ ($data_surat->golongan_darah ?? '') == 'B' ? 'selected' : '' }}
                                            value="B">B</option>
                                        <option {{ ($data_surat->golongan_darah ?? '') == 'O' ? 'selected' : '' }}
                                            value="O">O</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Respirasi</label>
                                    <div class="input-group mb-2">
                                        <input type="number" class="form-control" placeholder=""
                                            aria-describedby="basic-addon2" name="respirasi"
                                            value="{{ $data_surat->respirasi ?? '' }}">
                                        <div class="input-group-append">
                                            <span class="input-group-text" id="basic-addon2">/menit</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Nadi</label>
                                    <div class="input-group mb-2">
                                        <input type="number" class="form-control" placeholder=""
                                            aria-describedby="basic-addon2" name="nadi"
                                            value="{{ $data_surat->nadi ?? '' }}">
                                        <div class="input-group-append">
                                            <span class="input-group-text" id="basic-addon2">bpm</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Tanggal Tanda Tangan</label>
                                    <input class="form-control dateformat" type="text" name="tgl_ttd" id="tgl_tdd"
                                        value="{{ $data_surat->tgl_ttd ?? $tanggal }}" />
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>Dokter yang Memeriksa</label>
                                    <select name="nama_dokter" id="nama_dokter" class="form-control">
                                        <option value="">--Pilh Pilihan--</option>
                                        @foreach ($dokters as $dokter)
                                            <option
                                                {{ ($data_surat->nama_dokter ?? '') == $dokter->nama_dokter ? 'selected' : '' }}
                                                value="{{ $dokter->nama_dokter }}">{{ $dokter->nama_dokter }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div style="margin-top: 32px;">
                                    <a class="btn btn-dark" href="{{ route('surat_keterangan_sehat.index') }}"
                                        onclick="return confirm('Semua perubahan data tidak akan tersimpan, apakah anda yakin?')">Kembali</a>
                                    <button class="btn btn-primary float-right">Simpan</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>
@endsection
@push('scripts')
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/css/datepicker.min.css"
        rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/js/bootstrap-datepicker.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/locales/bootstrap-datepicker.id.min.js">
    </script>
    <script>
        $(document).ready(function() {

            $('#nama_dokter').select2({
                templateSelection: function(data) {
                    var $result = $(
                        '<span class="select2-selection__rendered pt-1">' +
                        data.text +
                        '</span>'
                    );

                    return $result;
                },
            });

            $(".dateformat")
                .datepicker({
                    format: "dd MM yyyy",
                    autoclose: true,
                    language: 'id'
                });
        });

        function openPasienModal() {
            $('#tabelListPasien').dataTable().fnClearTable();
            $('#tabelListPasien').dataTable().fnDestroy();

            $('#tabelListPasien').DataTable({
                serverSide: 'true',
                processing: 'true',
                pagingType: "full",
                deferRender: 'true',
                ajax: "{{ route('surat_keterangan_sehat.pasien') }}", // memanggil route yang menampilkan data json
                columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'nama',
                        name: 'nama'
                    },
                    {
                        data: 'tempat_lahir',
                        name: 'tempat_lahir'
                    },
                    {
                        data: 'tgl_lahir',
                        name: 'tgl_lahir',
                        render: function(data, type, row) {
                            var tmp2 = data.split('-');
                            return tmp2[2] + '-' + tmp2[1] + '-' + tmp2[0];
                        }
                    },
                    {
                        data: 'kelamin',
                        name: 'kelamin',
                        render: function(data, type, row) {
                            if (data == 1) {
                                return 'Perempuan'
                            } else if (data == 0) {
                                return 'Laki-Laki'
                            }
                        }
                    },
                    {
                        data: 'alamat',
                        name: 'alamat'
                    },
                    {
                        data: 'pekerjaan',
                        name: 'pekerjaan'
                    },
                    {
                        data: 'umur',
                        name: 'umur'
                    },
                    {
                        data: 'id',
                        name: 'id',
                        render: function(data, type, row, meta) {
                            //return '<div class="text-center"><button onclick="setPasien(' + "'" + row.nama +
                            //   "'" + ')" class="btn btn-dark"><i class="fas fa-check"></i></button></div>';
                            //return '<div class="text-center"><button onclick="setPasien(' + "'" + row.nama + "', '" + row.tempat_lahir + "', '" + row.tgl_lahir + "', '" + row.kelamin + "', '" + row.alamat + "', '" + row.pekerjaan + "'" + ')" class="btn btn-dark"><i class="fas fa-check"></i></button></div>';
                            return '<div class="text-center"><button onclick="setPasien(' + "'" + row.nama +
                                "', '" + row.tempat_lahir + "', '" + row.tgl_lahir + "', '" + row.kelamin +
                                "', '" + row.alamat + "', '" + row.pekerjaan + "', '" + row.umur + "','" +
                                data + "'" +
                                ')" class="btn btn-dark"><i class="fas fa-check"></i></button></div>';
                        }
                    }
                ]
            });
            $('#modal_pasien').modal('show');
        }

        function setPasien(nama, tempat_lahir, tgl_lahir, jenis_kelamin, alamat, pekerjaan, umur, nrm) {
            document.getElementById("nama").value = nama;
            document.getElementById("ttl_umur").value = tempat_lahir + " " + convTanggal(tgl_lahir) + " & " + umur;
            document.getElementById("kelamin").value = jenis_kelamin == 1 ? "Perempuan" : "Laki-Laki";
            document.getElementById("alamat").value = alamat;
            document.getElementById("pekerjaan").value = pekerjaan;
            document.getElementById("nrm").value = nrm;

            $('#modal_pasien').modal('hide');
        }

        function convTanggal(param) {
            var tmp2 = param.split('-');
            return tmp2[2] + '-' + tmp2[1] + '-' + tmp2[0];
        }

        //        function setPasien(param) {
        //console.log(param);
        //            $('#nama_pasien').val(param);
        //            $('#modal_pasien').modal('hide');
        //        }
    </script>
@endpush
