@extends('layouts.app')
@section('content')
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Riwayat Kunjungan Pasien Rawat Jalan</h1>
        </div>

        <div class="section-body">
            <form action="{{ url('satu_sehat/rawat_jalan/export') }}" id="fake_form" method="post">
                @csrf
                <input type="hidden" name="from" id="hide_from">
                <input type="hidden" name="to" id="hide_to">
            </form>
            <div class="pb-3" id="msg_loading"></div>
            <div class="card pt-3">
                <form class="row" style="width: 100%; margin-left: 0;" id="form_filter">
                    <div class="col-lg-4">
                        <div class="form-group">
                            <label for="">Dari</label>
                            <input type="date" name="dari" id="dari" value="{{ date('Y-m-d') }}" class="form-control" required>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="form-group">
                            <label for="">Sampai</label>
                            <input type="date" name="sampai" id="sampai" value="{{ date('Y-m-d') }}" class="form-control" required>
                        </div>
                    </div>
                    <div class="col-lg-4" style="padding-top: 30px;">
                        <button class="btn btn-primary" type="submit">Terapkan</button>
                        <button class="btn btn-success" type="button" onclick="send(0)"><i class="fa fa-paper-plane"></i> Kirim Data</button>
                        <button class="btn btn-warning" style="color:#fff;" type="button" onclick="export_excel()"><i class="fa fa-file"></i> Export Excel</button>
                    </div>
                </form>
            </div>
            <div class="card pt-3">
                <div class="row" style="width: 100%; margin-left: 0;">
                    <div class="col-lg-12">
                        <table class="table table-striped" style="width: 100%" id="tabel">
                            <thead>
                                <tr class="text-center">
                                    <th>No</th>
                                    <th>Tanggal Kunjungan</th>
                                    <th>Nama Poli</th>
                                    <th>Nama Pasien</th>
                                    <th>No. RM</th>
                                    <th>Diagnosa</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
@push('scripts')
<script>
    let data = [];

    function progress_loading(now, max) {
        return '<div class="progress" style="height: 30px;">' +
            '<div class="progress-bar progress-bar-striped progress-bar-animated bg-info" role="progressbar" aria-valuenow="' +
            now + '" aria-valuemin="0" aria-valuemax="' + max + '" style="width: ' + ((now / max) * 100) + '%">' + now +
            ' dari ' + max + ' (' + Math.floor((now / max) * 100) + ' %)</div>' +
            '</div>';
    }

    function export_excel() {
        $('#hide_from').val($('#dari').val());
        $('#hide_to').val($('#sampai').val());
        $('#fake_form').submit();
    }

    $(document).ready(function() {
        datatabel();
        get_data();
    })

    $('#form_filter').submit(function(e) {
        e.preventDefault();
        datatabel();
        get_data();
    })

    function send(index) {
        $('#msg_loading').html(progress_loading(index, data.length));
        let temp_index = index + 1;
        console.log(index);

        if (data[index].status_ss == 0) {
            $.ajax({
                url: "{{ url('satu_sehat/rawat_jalan/send') }}",
                data: {
                    id: data[index].id
                },
                success: function(response) {
                    console.log(response);
                    // if (response.code == 500) {
                    //     $('#msg_loading').html('<div class="alert alert-danger text-center">Selesai ' + index + ' dari ' + data.length + '. Jika ingin mengulangi / melanjutkan tekan terapkan terlebih dahulu</div>');
                    //     return;
                    // }

                    if (temp_index < data.length) {
                        send(temp_index);
                    } else {
                        $('#msg_loading').html('<div class="alert alert-success text-center">Selesai ' + (index + 1) + ' dari ' + data.length + '.</div>');
                    }
                }
            })
        } else {
            if (temp_index < data.length) {
                send(temp_index);
            } else {
                $('#msg_loading').html('<div class="alert alert-success text-center">Selesai ' + (index + 1) + ' dari ' + data.length + '.</div>');
            }
        }
    }

    function get_data() {
        data = [];
        $.ajax({
            url: "{{ url('satu_sehat/rawat_jalan/filter') }}",
            data: $('#form_filter').serialize(),
            success: function(response) {
                data = response;
                $('#msg_loading').html('');
                console.log(data);
            }
        })
    }

    function datatabel() {
        if ($.fn.DataTable.isDataTable("#tabel")) {
            $('#tabel').DataTable().clear().destroy();
        }

        $('#tabel').DataTable({
            processing: true,
            serverSide: true,
            bLengthChange: false,
            ajax: "{{ url('satu_sehat/rawat_jalan/datatable?dari=') }}" + $('#dari').val() + '&sampai=' +
                $('#sampai').val(),
            columns: [{
                    data: 'id',
                    name: 'id',
                    render: function(data, type, row, meta) {
                        return '<div class="text-center">' + (meta.row + meta.settings._iDisplayStart +
                            1) + '</div>';
                    }
                },
                {
                    data: 'tanggal',
                    name: 'tanggal',
                    render: function(data, type, row) {
                        return '<div class="text-center">' + reformat_tanggal(data) + '</div>';
                    }
                },
                {
                    data: 'jenislayanan',
                    name: 'jenislayanan',
                    render: function(data, type, row) {
                        return convert_slug(data);
                    }
                },
                {
                    data: 'nama_pasien',
                    name: 'nama_pasien',
                },
                {
                    data: 'nrm',
                    name: 'nrm',
                },
                {
                    data: 'nama_icd',
                    name: 'smis_mr_diagnosa.nama_icd',
                },
                {
                    data: 'status_ss',
                    name: 'status_ss',
                    render: function(data, type, row) {
                        if (data == 0 && row.response_code_satu_sehat == '') {
                            return '<div class="text-center">Belum dikirim</div>';
                        }

                        if (data == 1) {
                            return '<div class="text-center">Berhasil</div>';
                        }

                        return '<div class="text-center">Gagal</div>';
                    }
                }
            ],
            "columnDefs": [{
                "targets": [0, 1, 2, 3, 4, 5, 6],
                "orderable": false
            }]
        })
    }

    function convert_slug(param) {
        if (param == '' || param == null) {
            return '';
        }
        arr = param.split('_');

        for (var i = 0; i < arr.length; i++) {
            arr[i] = arr[i].charAt(0).toUpperCase() + arr[i].slice(1);

        }
        return arr.join(' ');
    }

    function reformat_tanggal(tanggal) {
        if (tanggal == '' || tanggal == null) {
            return '';
        }
        var temp = [];
        var jam = [];
        if (tanggal.includes(' ')) {
            var tgl = tanggal.split(' ');
            temp = tgl[0].split('-');
            jam = tgl[1].split(':');
            return temp[2] + '-' + temp[1] + '-' + temp[0] + ' ' + jam[0] + ':' + jam[1];
        } else {
            temp = tanggal.split('-');
            return temp[2] + '-' + temp[1] + '-' + temp[0];
        }
    }
</script>
@endpush