<script>
    let id_resep = '{{ $data->id_resep ?? "0" }}';
    let d_resep = <?php echo $resep ? $resep->detail : '[]' ?>;

    $("#e_resep_nama_obat").autocomplete({
        serviceUrl: "{{ url('ajax_request/resep/autocomplete_obat') }}", // Kode php untuk prosesing data
        dataType: "JSON", // Tipe data JSON
        params: {
            'depo': function() {
                return $('#e_resep_depo_tujuan').val();
            }
        },
        onSelect: function(suggestion) {
            let temp = suggestion.stok.split(' ');
            $("#e_resep_nama_obat").val(suggestion.nama);
            $('#e_resep_kode_obat').val(suggestion.kode_obat);
            $("#e_resep_id_obat").val(suggestion.id);
            $("#e_resep_jenis_obat").val(suggestion.jenis_obat);
            $("#e_resep_satuan_obat").val(temp[1] != undefined ? temp[1] : '');
            $("#e_resep_sisa_obat").val(temp[0] != undefined ? temp[0] : '');

            get_harga_obat(suggestion.id);
        }
    })

    function lock_terapi() {
        if (!confirm('Apakah anda yakin mengirim resep ke farmasi ? resep yang dikirim tidak dapat diubah lagi')) {
            return;
        }

        $.ajax({
            url: "{{ url('ajax_request/resep/lock') }}",
            data: {
                _token: '{{ csrf_token() }}',
                _method: 'patch',
                id: id_resep
            },
            method: 'post',
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                toastr.success(response.message);

                $('#box_btn_terapi').html(html_dokumen_resep(response.data));
            }
        })
    }

    function html_dokumen_resep(data) {
        var locked_0 = '<button class="btn btn-warning btn-sm" type="button" onclick="open_modal_resep()">' +
            '<i class="fa fa-pencil" style="color:#fff;"></i>' +
            '</button>' +
            '<button class="btn btn-info btn-sm ml-1" type="button" onclick="lock_terapi()">Kirim ke farmasi</button>';

        var row_tabel_resep = '';
        let detail_resep = data.detail;

        for (let i = 0; i < detail_resep.length; i++) {
            row_tabel_resep += '<tr>' +
                '<td style="width:20px;">R/</td>' +
                '<td>' + detail_resep[i].nama_obat + '</td>' +
                '<td>' + detail_resep[i].signa + '</td>' +
                '<td style="padding-left: 20px;">' +
                detail_resep[i].jumlah + ' ' + detail_resep[i].satuan +
                '</td>' +
                '</tr>';
        }

        var html_resep = (data.locked == 0 ? locked_0 : '') +
            '<button class="btn btn-info btn-sm ml-1" type="button" onclick="preview_terapi()">Preview</button>' +
            ' No. Resep Elektronik ' + data.id +
            `<table style="border-collapse: collapse; {{ $dokumen->nama_dokumen == 'Catatan Perkembangan Pasien' ? 'width:100%;' : 'width:50%;' }}">` +
            row_tabel_resep +
            '</table>' +
            data.catatan_obat_racikan;

        return html_resep;
    }

    $('#form_resep').submit(function(e) {
        e.preventDefault();
        toastr.warning('Sedang menyimpan resep, harap tunggu...')

        $('#detail_resep').val(JSON.stringify(d_resep));

        $.ajax({
            url: "{{ url('ajax_request/resep/store') }}",
            data: $('#form_resep').serialize(),
            method: 'post',
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }

                $('#modal_resep').modal('hide');
                toastr.success(response.message);

                $('#box_btn_terapi').html(html_dokumen_resep(response.data));
                id_resep = response.data.id;
                $('[name=id_resep]').val(id_resep);
                $('[name=ppa_submit]').val('dr');
                $('#form_dokumen').submit();
            }
        })
    })

    function open_modal_resep() {
        $.ajax({
            url: "{{ url('ajax_request/resep/select') }}",
            data: {
                id: id_resep
            },
            success: function(response) {
                if (Object.keys(response) == 0) {
                    $('#modal_resep').modal('show');
                    return;
                }

                let temp_tanggal = response.tanggal.split(' ');
                let tgl = temp_tanggal[0].split('-').reverse().join('-');

                $('#e_resep_nrm').val(response.nrm_pasien);
                $('#e_resep_waktu').val(tgl+' '+temp_tanggal[1]);
                $('#e_resep_nama').val(response.nama_pasien);
                $('#e_resep_usia').val(response.usia);
                $('#e_resep_alamat').val(response.alamat_pasien);
                $('#e_resep_telp').val(response.no_telpon);
                $('#e_resep_jenis_pasien').val(response.jenis);
                $('#e_resep_obat_racikan').val(response.catatan_obat_racikan);
                $('#e_resep_dokter').val(response.nama_dokter);
                $('#e_resep_sip').val(response.sip_dokter);
                $('#e_resep_id_dokter').val(response.id_dokter);
                $('#e_resep_berat_badan').val(response.berat_badan);
                $('#e_resep_perusahaan').val(response.perusahaan);
                $('#e_resep_asuransi').val(response.asuransi);

                $('#modal_resep').modal('show');

                render_d_resep();
            }
        })
    }

    function open_modal_list_obat() {
        if ($.fn.DataTable.isDataTable("#tabel_list_obat")) {
            $('#tabel_list_obat').DataTable().clear().destroy();
        }

        $('#tabel_list_obat').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ url('ajax_request/resep/list_obat') }}?depo=" + $('#e_resep_depo_tujuan').val(),
            columns: [{
                    data: 'nama_obat',
                    name: 'nama_obat'
                },
                {
                    data: 'nama_jenis_obat',
                    name: 'nama_jenis_obat'
                },
                {
                    data: 'stok',
                    name: 'stok',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row) {
                        return data;
                    }
                },
                {
                    data: 'id',
                    name: 'id',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row) {
                        let temp = row.stok.split(' ');
                        return '<div class="text-center">' +
                            '<button onclick="get_detail_obat(' + "'" + data + "','" + row.kode_obat + "','" + row.nama_obat + "','" + (temp[1] != undefined ? temp[1] : '') + "','" + row.nama_jenis_obat + "','" + (temp[0] != undefined ? temp[0] : '') + "'" + ')" class="btn btn-dark">' +
                            '<i class="fa fa-check"></i>' +
                            '</button>' +
                            '</div>';
                    }
                },
            ]
        });

        $('#modal_list_obat').modal('show');
    }

    function get_detail_obat(id_obat, kode, nama, satuan, jenis, sisa) {
        $('#e_resep_id_obat').val(id_obat);
        $('#e_resep_kode_obat').val(kode);
        $('#e_resep_nama_obat').val(nama);
        $('#e_resep_satuan_obat').val(satuan);
        $('#e_resep_jenis_obat').val(jenis);
        $('#e_resep_sisa_obat').val(sisa);

        toastr.warning('Sedang mengambil harga obat, harap tunggu...');

        get_harga_obat(id_obat);
    }

    function get_harga_obat(id_obat) {
        $.ajax({
            url: "{{ url('ajax_request/resep/harga_obat') }}",
            data: {
                id_obat: id_obat,
            },
            success: function(response) {
                if (response == null) {
                    toastr.error('Harga obat tidak ditemukan.');
                    return;
                }
                $('#e_resep_harga_obat').val(rupiah(response.toFixed(2)));
                $('#modal_list_obat').modal('hide');
                $('#modal_resep').modal('show');
            }
        })
    }

    function simpan_d_resep() {
        let obj = {
            id: '',
            prop: '',
            id_obat: parseInt($('#e_resep_id_obat').val()),
            kode_obat: $('#e_resep_kode_obat').val(),
            nama_obat: $('#e_resep_nama_obat').val(),
            nama_jenis_obat: $('#e_resep_jenis_obat').val(),
            jumlah: parseFloat($('#e_resep_jumlah_obat').val()),
            satuan: $('#e_resep_satuan_obat').val(),
            harga: parseFloat($('#e_resep_harga_obat').val().toString().replaceAll('.', '').replaceAll(',', '.')),
            aturan_pakai: $('#e_resep_signa').val(),
            signa: $('#e_resep_signa').val(),
            sisa: $('#e_resep_sisa_obat').val(),
        };

        if ($('#e_resep_index_obat').val() == '') {
            d_resep.push(obj);
        } else {
            d_resep[$('#e_resep_index_obat').val()].jumlah = parseFloat($('#e_resep_jumlah_obat').val());
            d_resep[$('#e_resep_index_obat').val()].aturan_pakai = $('#e_resep_signa').val();
            d_resep[$('#e_resep_index_obat').val()].signa = $('#e_resep_signa').val();
        }

        $('#e_resep_index_obat').val('');
        $('#e_resep_id_obat').val('');
        $('#e_resep_kode_obat').val('');
        $('#e_resep_nama_obat').val('');
        $('#e_resep_jenis_obat').val('');
        $('#e_resep_sisa_obat').val('');
        $('#e_resep_satuan_obat').val('');
        $('#e_resep_jumlah_obat').val('');
        $('#e_resep_harga_obat').val('');
        $('#e_resep_signa').val('');

        render_d_resep();
    }

    function render_d_resep() {
        var ins = '';
        var footer = '';
        let jml = 0;
        let iteration = 1;

        for (let i = 0; i < d_resep.length; i++) {
            if (d_resep[i].prop == '') {
                ins += '<tr>' +
                    '<td class="text-center">' + iteration + '</td>' +
                    '<td>' + d_resep[i].nama_obat + '</td>' +
                    '<td class="text-center">' + d_resep[i].nama_jenis_obat + '</td>' +
                    '<td class="text-center">' + d_resep[i].jumlah + '</td>' +
                    '<td class="text-center">' + d_resep[i].satuan + '</td>' +
                    '<td>Rp. ' + rupiah(d_resep[i].harga) + '</td>' +
                    '<td>Rp. ' + rupiah((d_resep[i].harga * d_resep[i].jumlah).toFixed(2)) +
                    '</td>' +
                    '<td class="text-center">' + d_resep[i].signa + '</td>' +
                    '<td class="text-center">' +
                    '<div style="display:flex; flex-direction:row;">' +
                    '<button onclick="edit_d_resep(' + "'" + i + "'" + ')" class="btn btn-warning mr-1" type="button" style="color:#fff"><i class="fa fa-pencil"></i></button>' +
                    '<button onclick="hapus_d_resep(' + "'" + i + "'" + ')" class="btn btn-danger" type="button"><i class="fa fa-trash"></i></button>' +
                    '</div>' +
                    '</td>' +
                    '</tr>';
                jml += parseFloat((d_resep[i].harga * d_resep[i].jumlah).toFixed(2));
                iteration++;
            }
        }

        if (d_resep.length > 0) {
            footer = '<tr>' +
                '<td colspan="6" style="text-align:right; font-weight:bold;">Total : </td>' +
                '<td style="font-weight:bold;">Rp. ' + rupiah(jml) + '</td>' +
                '<td colspan="2"></td>' +
                '</tr>';
        }
        $('#list_d_resep').html(ins);
        $('#footer_list_d_resep').html(footer);
    }

    function edit_d_resep(index) {
        $('#e_resep_index_obat').val(index);
        $('#e_resep_kode_obat').val(d_resep[index].kode_obat);
        $('#e_resep_nama_obat').val(d_resep[index].nama_obat);
        $('#e_resep_jumlah_obat').val(d_resep[index].jumlah);
        $('#e_resep_signa').val(d_resep[index].signa);
        $('#e_resep_sisa_obat').val(d_resep[index].sisa);
        $('#e_resep_satuan_obat').val(d_resep[index].satuan);
        get_harga_obat(d_resep[index].id_obat);
    }

    function hapus_d_resep(index) {
        if ($('#e_resep_index_obat').val() != '') {
            toastr.error('Selesaikan edit obat terlebih dahulu');
            return;
        }

        d_resep[index].prop = 'del';
        render_d_resep();
    }

    function open_modal_dokter_resep(){
        if ($.fn.DataTable.isDataTable('#tabel_dokter_resep')) {
            $('#tabel_dokter_resep').dataTable().fnClearTable();
            $('#tabel_dokter_resep').dataTable().fnDestroy();
        }
        $('#tabel_dokter_resep').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ url('ajax_request/datatable_dokter') }}",
            columns: [{
                    data: 'nama',
                    name: 'nama'
                },
                {
                    data: 'jabatan',
                    name: 'jabatan'
                },
                {
                    data: 'nomor_sipa',
                    name: 'nomor_sipa'
                },
                {
                    data: 'id',
                    name: 'id',
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row) {
                        return '<div class="text-center"><button class="btn btn-dark" onclick="set_dokter_resep(' +
                            "'" + row.nama + "','" + data + "','" + row.nomor_sipa + "'" +
                            ')"><i class="fa fa-check"></i></button></div>';
                    }
                },
            ]
        });


        $('#modal_resep').modal('hide');
        $('#modal_dokter_resep').modal('show');
    }

    function set_dokter_resep(nama, id, sip){
        $('#e_resep_dokter').val(nama);
        $('#e_resep_id_dokter').val(id);
        $('#e_resep_sip').val(sip);
        $('#modal_dokter_resep').modal('hide');
        $('#modal_resep').modal('show');        
    }

    function preview_terapi() {
        $.ajax({
            url: "{{ url('ajax_request/resep/select') }}",
            data: {
                id: id_resep
            },
            success: function(response) {
                if (response == null) {
                    return;
                }
                var ins = '<table id="tabel_preview" style="border: 1px solid; width:100%;">' +
                    '<tr style="border:1px solid;">' +
                    '<td style="padding: 10px;">' +
                    `<p style="text-align:center"><b>{{ env('NAMA_KLINIK') }}</b><br>{{ env('ALAMAT_KLINIK') }}<br>Telp: {{ env('TELPON_KLINIK') }}</p>` +
                    '<table style="width: 100%;">' +
                    '<tr>' +
                    '<td style="width: 40%">Dokter</td>' +
                    '<td style="width: 3%"> : </td>' +
                    '<td style="width: 57%">' + response.nama_dokter + '</td>' +
                    '</tr>' +
                    '<tr>' +
                    '<td>SIP</td>' +
                    '<td> : </td>' +
                    '<td>' + (response.sip_dokter != null ? response.sip_dokter : '') + '</td>' +
                    '</tr>' +
                    '<tr>' +
                    '<td>Unit Pelayanan</td>' +
                    '<td> : </td>' +
                    '<td style="text-transform: uppercase">' +
                    response.jenis.replaceAll('_', ' ') +
                    '</td>' +
                    '</tr>' +
                    '<tr>' +
                    '<td>Catatan Obat Racikan</td>' +
                    '<td> : </td>' +
                    '<td></td>' +
                    '</tr>' +
                    '<tr>' +
                    '<td colspan="3">' +
                    response.catatan_obat_racikan +
                    '</td>' +
                    '</tr>' +
                    '</table>' +
                    '</td>' +
                    '</tr>' +
                    '<tr>' +
                    '<td style="padding:10px;">' +
                    '<table style="width: 100%;">' +
                    '<tr>' +
                    '<td colspan="4" style="text-align: right">' +
                    'Surabaya, <?php echo date('d-m-Y', strtotime($layanan->tanggal)); ?>' +
                    '</td>' +
                    '</tr>';

                for (let j = 0; j < response.detail.length; j++) {
                    ins += '<tr>' +
                        '<td colspan="4">R/</td>' +
                        '</tr>' +
                        '<tr>' +
                        '<td style="width:20px;"></td>' +
                        '<td>' + response.detail[j].nama_obat + '</td>' +
                        '<td>' + response.detail[j].signa + '</td>' +
                        '<td style="padding-left: 20px;">' +
                        response.detail[j].jumlah + ' ' + response.detail[j].satuan + '</td>' +
                        '</tr>';
                }
                ins += '</table>' +
                    '</td>' +
                    '</tr>' +
                    '<tr style="border: 1px solid red;">' +
                    '<td style="border: 1px solid; padding:10px;">' +
                    '<table style="width: 100%">' +
                    '<tr>' +
                    '<td>Nama Pasien</td>' +
                    '<td> : </td>' +
                    '<td>' + response.nama_pasien + '</td>' +
                    '</tr>' +
                    '<tr>' +
                    '<td>No. Reg</td>' +
                    '<td> : </td>' +
                    '<td>' + response.noreg_pasien + '</td>' +
                    '</tr>' +
                    '<tr>' +
                    '<td>No. RM</td>' +
                    '<td> : </td>' +
                    '<td>' + response.nrm_pasien + '</td>' +
                    '</tr>' +
                    '<tr>' +
                    '<td>Alamat</td>' +
                    '<td> : </td>' +
                    '<td>' + response.alamat_pasien + '</td>' +
                    '</tr>' +
                    '<tr>' +
                    '<td>Jenis Pasien</td>' +
                    '<td> : </td>' +
                    '<td style="text-transform: uppercase">' + response.jenis + '</td>' +
                    '</tr>' +
                    '<tr>' +
                    '<td>Perusahaan</td>' +
                    '<td> : </td>' +
                    '<td>' + (response.perusahaan != null ? response.perusahaan : '') + '</td>' +
                    '</tr>' +
                    '<tr>' +
                    '<td>Asuransi</td>' +
                    '<td> : </td>' +
                    '<td>' + (response.asuransi != null ? response.asuransi : '') + '</td>' +
                    '</tr>' +
                    '</table>' +
                    '</td>' +
                    '</tr>' +
                    '</table>';
                $('#box_preview').html(ins);
                $('#modal_preview').modal('show');
            }
        })
    }
</script>