@extends('medical_record.e_rekam_medis.dokumen_kunjungan.layout')
@section('content')
<style>
    #signaturepad_gigi {
        position: absolute;
        border: 1px solid;
        top: 0;
        left: 25%;
    }

    @media print {
        canvas {
            position: absolute;
            left: 210px !important;
            width: 570px !important;
        }
    }
</style>
<form style="border:1px solid;" class="container pl-0 pr-0" id="form_dokumen">
    @csrf
    <input type="hidden" name="dokumen" value="{{ $dokumen->id }}">
    <input type="hidden" name="password">
    <input type="hidden" name="id_diagnosa" value="{{ $data->id_diagnosa ?? 0 }}">
    <input type="hidden" name="id_lab" value="{{ $data->id_lab ?? 0 }}">
    <input type="hidden" name="id_resep" value="{{ $data->id_resep ?? 0 }}">
    @include('medical_record.e_rekam_medis.dokumen_kunjungan.kop')
    <div class="row" style="width:100%; margin-left: 0;">
        <div class="col-md-12 pt-4">
            <p>Pemeriksaan tanggal {{ date('d-m-Y', strtotime($dokumen->created_at)) }} Jam {{ date('H:i', strtotime($dokumen->created_at)) }}</p>
        </div>
    </div>
    <div class="row" style="width:100%; margin-left: 0;">
        <div class="col-md-12 pt-2">
            <h6 style="text-decoration: underline;">Subyektif</h6>
        </div>
        <div class="col-md-12">
            <table style="border-collapse: collapse; width:100%;" id="tabel_subyektif">
                <tr>
                    <td style="width: 20%;">Keluhan Utama</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $data->keluhan_utama ?? '' }}" id="keluhan_utama" name="keluhan_utama">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Riwayat Penyakit Sekarang</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $data->riwayat_penyakit_sekarang ?? '' }}" id="riwayat_penyakit_sekarang" name="riwayat_penyakit_sekarang">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Riwayat Penyakit Dahulu</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <?php
                        $rpd = $data ? $data->riwayat_penyakit_dahulu : '';
                        if ($rpd == '') {
                            if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']) {
                                $rpd = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']->riwayat_penyakit_dahulu;
                            } else if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']) {
                                $rpd = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']->riwayat_penyakit_dahulu;
                            } else if ($dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']) {
                                $rpd = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->riwayat_penyakit_dahulu;
                            }
                        }
                        ?>
                        <input type="text" class="form-control" value="{{ $data->riwayat_penyakit_dahulu ?? $rpd }}" id="riwayat_penyakit_dahulu" name="riwayat_penyakit_dahulu">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Riwayat Penyakit Kronis</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $data->riwayat_penyakit_kronis ?? '' }}" id="riwayat_penyakit_kronis" name="riwayat_penyakit_kronis">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Riwayat Penyakit Keluarga</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <?php
                        $rpk = $data->riwayat_penyakit_keluarga ?? '';
                        if ($rpk == '') {
                            if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']) {
                                $rpk = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']->riwayat_penyakit_keluarga;
                            } else if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']) {
                                $rpk = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']->riwayat_penyakit_keluarga;
                            } else if ($dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']) {
                                $rpk = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->riwayat_penyakit_keluarga;
                            }
                        }
                        ?>
                        <input type="text" class="form-control" value="{{ $data->riwayat_penyakit_keluarga ?? $rpk }}" id="riwayat_penyakit_keluarga" name="riwayat_penyakit_keluarga">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Riwayat Alergi Obat</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <?php
                        $rao = $data->riwayat_alergi_obat ?? '';
                        if ($rao == '') {
                            if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']) {
                                $rao = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']->riwayat_alergi_obat;
                            } else if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']) {
                                $rao = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']->riwayat_alergi_obat;
                            } else if ($dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']) {
                                $rao = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->riwayat_alergi_obat;
                            }
                        }
                        ?>
                        <input type="text" class="form-control" value="{{ $data->riwayat_alergi_obat ?? $rao }}" id="riwayat_alergi_obat" name="riwayat_alergi_obat">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Catatan Khusus</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <?php
                        $ck = '';
                        if ($ck == '') {
                            if ($dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']) {
                                $ck = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->catatan_khusus_ns;
                                if ($ck == '') {
                                    $ck = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->catatan_khusus_dr;
                                }
                            }
                        }
                        ?>
                        <input type="text" readonly class="form-control" value="{{ $ck }}" id="catatan_khusus">
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row" style="width:100%; margin-left: 0;">
        <div class="col-md-12 pt-2">
            <h6 style="text-decoration: underline;">Obyektif</h6>
            <h6>Tanda Vital</h6>
        </div>
        <table style="width: 100%; border-collapse: collapse;">
            <tr>
                <td style="width: 20%; text-align: center;">
                    <p>TD {{ $diagnosa ? $diagnosa->sistole."/".$diagnosa->diastole : '..../....' }} mmHg</p>
                </td>
                <td style="width: 20%; text-align: center;">
                    <p>RR {{ $diagnosa ? $diagnosa->rr : '....' }} x/menit</p>
                </td>
                <td style="width: 20%; text-align: center;">
                    <p>Nadi {{ $diagnosa ? $diagnosa->nadi : '....' }} x/menit</p>
                </td>
                <td style="width: 20%; text-align: center;">
                    <p>Suhu {{ $diagnosa ? $diagnosa->suhu : '....' }} ᵒC</p>
                </td>
                <td style="width: 20%; text-align: center;">
                    <p>Skala nyeri {{ $diagnosa ? $diagnosa->nyeri : '....' }} </p>
                </td>
            </tr>
        </table>
        <div class="col-md-12 pt-2">
            <h6>Status Generans</h6>
        </div>
        <div class="col-md-12">
            <table style="border-collapse: collapse; width:100%;" id="tabel_subyektif">
                <tr>
                    <th colspan="3">Pemeriksaan Ekstra Oral</th>
                </tr>
                <tr>
                    <td style="width: 20%;">Wajah</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $data->wajah ?? '' }}" id="wajah" name="wajah">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Bibir</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $data->bibir ?? '' }}" id="bibir" name="bibir">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Kelenjar Getah Bening</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $data->getah_bening ?? '' }}" id="getah_bening" name="getah_bening">
                    </td>
                </tr>
                <tr>
                    <th colspan="3">Pemeriksaan Intra Oral</th>
                </tr>
                <tr>
                    <td style="width: 20%;">Palatum</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $data->palatum ?? '' }}" id="palatum" name="palatum">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Lidah</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $data->lidah ?? '' }}" id="lidah" name="lidah">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Dasar mulut</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $data->dasar_mulut ?? '' }}" id="dasar_mulut" name="dasar_mulut">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Mukosa pipi</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $data->mukosa_pipi ?? '' }}" id="mukosa_pipi" name="mukosa_pipi">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Lain – Lain</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $data->lain_lain ?? '' }}" id="lain_lain" name="lain_lain">
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-md-12 pt-2">
            <div style="display: flex; width: 100%; flex-direction: column; align-items: center;">
                <div style="z-index: -1" class="text-center">
                    <img src="{{ asset('images/poli_gigi_newz.png') }}" style="width: 80%;" alt="" />
                </div>
                <canvas id="signaturepad_gigi"></canvas>
                <div style="display: inline-flex" class="mt-3">
                    <button class="btn btn-dark mr-1" onclick="change_color('black')" type="button"><i class="fa fa-pencil"></i> Hitam</button>
                    <button class="btn btn-danger mr-1" onclick="change_color('red')" type="button"><i class="fa fa-pencil"></i> Merah</button>
                    <button class="btn btn-primary mr-1" onclick="change_color('blue')" type="button"><i class="fa fa-pencil"></i> Biru</button>
                    <button class="btn btn-success mr-1" onclick="change_color('green')" type="button"><i class="fa fa-pencil"></i> Hijau</button>
                </div>
                <br>
                <br>
                <div style="inline-flex">
                    <button class="btn btn-danger mr-1" onclick="hapus_signature()" type="button">Hapus</button>
                    <button class="btn btn-dark mr-1" onclick="undo_signature()" type="button">Undo</button>
                </div>
            </div>
        </div>
        <div class="col-md-12 pt-2">
            <h6><u>Asesmen</u></h6>
        </div>
        <div class="col-md-12">
            <table id="tabel_subyektif" style="border-collapse: collapse; width:100%;">
                <tr>
                    <td style="width: 20%; vertical-align: top;">Diagnosa</td>
                    <td style="width:5%; vertical-align: top; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <textarea rows="3" readonly style="height: 100%" type="text" id="tmp_catatan_diagnosa" class="form-control">{{ $diagnosa ? $diagnosa->diagnosa : '' }}</textarea>
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Diagnosa utama</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <div style="display: flex; flex-direction: row">
                            <div id="box_button_diagnosa">
                                <button type="button" style="color: #fff; font-weight: bold;" class="btn btn-sm btn-{{ $diagnosa ? 'warning' : 'dark' }}" onclick="open_form_diagnosa()"><i class="fa fa-{{ $diagnosa ? 'pencil' : 'plus' }}"></i></button>
                            </div>
                            <div id="box_diagnosa" class="ml-2">
                                {{ $diagnosa ? ($diagnosa->kode_icd != '' ? $diagnosa->kode_icd . ' - ' . $diagnosa->nama_icd : $diagnosa->nama_icd) : '' }}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Diagnosa sekunder</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;" id="box_diagnosa_sekunder">
                        <?php
                        if ($diagnosa && $diagnosa->nama_icd_sekunder != '') {
                            echo $diagnosa->kode_icd_sekunder . ' - ' . $diagnosa->nama_icd_sekunder;
                        }
                        ?>
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-md-12 pt-2">
            <h6 style="text-decoration: underline;">Planning</h6>
            <p>Pemeriksaan Penunjang</p>
        </div>
        <div class="col-md-12">
            <table style="border-collapse: collapse; width:100%;" id="tabel_subyektif">
                <!-- <tr>
                    <td style="width: 25%; vertical-align:top;">A. Laboratorium</td>
                    <td style="width:5%; vertical-align:top; text-align: center;"> : </td>
                    <td style="width: 70%; vertical-align: top;">
                        <div style="display: flex; flex-direction: row" class="pb-2">
                            <div id="box_button_pesanan_lab" class="mr-2">
                                @if($laboratorium)
                                <button class="btn btn-warning btn-sm" type="button" style="color: #fff" onclick="open_modal_lab()">
                                    <i class="fa fa-pencil"></i>
                                </button>
                                <button class="btn btn-info btn-sm" type="button" style="color: #fff" onclick="open_modal_hasil_lab()">
                                    <i class="fa fa-book"></i>
                                </button>
                                @else
                                <button class="btn btn-dark btn-sm" type="button" onclick="open_modal_lab()">
                                    <i class="fa fa-plus"></i>
                                </button>
                                @endif
                            </div>
                            <div id="list_pesanan_lab">
                                <?php
                                if ($laboratorium) {
                                    $temp = '';
                                    $iteration = 0;
                                    $json = (array) json_decode($laboratorium->periksa);

                                    for ($i = 0; $i < sizeof($pemeriksaan); $i++) {
                                        if ($json[$pemeriksaan[$i]->slug] == 1) {
                                            $temp .= ($iteration > 0 ? ', ' : '') . $pemeriksaan[$i]->nama;
                                            $iteration++;
                                        }
                                    }
                                ?>
                                    {{ $laboratorium->no_lab }} - {{ $temp }}
                                <?php } ?>
                            </div>
                        </div>
                    </td>
                </tr> -->
                <tr>
                    <td style="width: 25%; vertical-align:top;">A. Pemeriksaan Penunjang Lain</td>
                    <td style="width:5%; vertical-align:top; text-align: center;"> : </td>
                    <td style="width: 70%;">
                        <input type="text" class="form-control mb-2" value="{{ $data->penunjang_lain ?? '' }}" id="penunjang_lain" name="penunjang_lain">
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%;">Terapi</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 70%;">
                        <div id="box_btn_terapi">
                            @if ($resep == null)
                            <button class="btn btn-dark btn-sm" type="button" onclick="open_modal_resep()">
                                <i class="fa fa-plus"></i>
                            </button>
                            @else
                            @if ($resep->locked == 0)
                            <button class="btn btn-warning btn-sm" type="button" onclick="open_modal_resep()">
                                <i class="fa fa-pencil" style="color:#fff;"></i>
                            </button>
                            <button class="btn btn-info btn-sm" type="button" onclick="lock_terapi()">Kirim ke farmasi</button>
                            @endif
                            <button class="btn btn-info btn-sm" type="button" onclick="preview_terapi()">Preview</button>
                            No. Resep Elektronik {{ $resep->id ?? '' }}
                            <table style="border-collapse: collapse; width:50%;">
                                @foreach ($resep->detail as $ar_det)
                                <tr>
                                    <td style="width:20px;">{{ 'R/' }}</td>
                                    <td>{{ $ar_det->nama_obat }}</td>
                                    <td>{{ $ar_det->signa }}</td>
                                    <td style="padding-left: 20px;">
                                        {{ $ar_det->jumlah . ' ' . $ar_det->satuan }}
                                    </td>
                                </tr>
                                @endforeach
                            </table>
                            {{ $resep->catatan_obat_racikan }}
                            @endif
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="vertical-align:top;">Tindak lanjut</td>
                    <td style="text-align: center; vertical-align:top;"> : </td>
                    <td>
                        <textarea rows="3" id="tindak_lanjut" name="tindak_lanjut" style="height: 100%" class="form-control">{{ $data->tindak_lanjut ?? '' }}</textarea>
                    </td>
                </tr>
                <tr>
                    <td>Status Pulang</td>
                    <td style="text-align: center"> : </td>
                    <td>
                        <select id="status_pulang" name="status_pulang" class="form-control">
                            <option value="">--Select Here--</option>
                            <option {{ $data && $data->status_pulang == '1' ? 'selected' : ($diagnosa && $diagnosa->kode_status_pulang == '1' ? 'selected' : '') }} value="1">Meninggal</option>
                            <option {{ $data && $data->status_pulang == '3' ? 'selected' : ($diagnosa && $diagnosa->kode_status_pulang == '3' ? 'selected' : '') }} value="3">Berobat Jalan</option>
                            <option {{ $data && $data->status_pulang == '4' ? 'selected' : ($diagnosa && $diagnosa->kode_status_pulang == '4' ? 'selected' : '') }} value="4">Rujuk Vertikal</option>
                            <option {{ $data && $data->status_pulang == '6' ? 'selected' : ($diagnosa && $diagnosa->kode_status_pulang == '6' ? 'selected' : '') }} value="6">Rujuk Horizontal</option>
                        </select>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row pt-4 pb-5" style="width:100%; margin-left: 0; ">
        <table style="width: 100%; border-collapse: collapse;">
            <tr>
                <td style="width: 50%;"></td>
                <td style="width: 50%; text-align: center; font-weight: bold;" onclick="open_modal_verifikasi()">
                    <p>&nbsp;</p>
                    <p>Dokter Penanggung Jawab Pelayanan</p>
                    <div id="box_ttd">
                        @if ($dokumen->status == 0)
                        <br>
                        Simpan & verifikasi
                        <br>
                        <br>
                        (.................................................)
                        <br>Tanda tangan & nama terang
                        @else
                        <img src="{{ env('SMIS_UPLOAD_URL') . '/' . ($employee->ttd_foto ?? '') }}" style="height: 2.5cm; width: 5cm;" alt="">
                        <br>{{ $dokumen->nama_verifikator }}
                        @endif
                    </div>
                </td>
            </tr>
        </table>
    </div>
    <textarea name="signature" hidden></textarea>
</form>
@include('medical_record.e_rekam_medis.dokumen_kunjungan.popup_verifikasi')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.laboratorium')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.diagnosa')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.resep')
@endsection
@push('scripts')
<script>
    function open_modal_verifikasi() {
        $('#modal_verifikasi').modal('show');
    }

    $('#modal_verifikasi').submit(function(e) {
        e.preventDefault();
        $('[name=password]').val($('#pass').val());
        $('#modal_verifikasi').modal('hide');
        $('#form_verifikasi')[0].reset();
        $('#form_dokumen').submit();
    })

    $('#form_dokumen').submit(function(e) {
        e.preventDefault();

        toastr.warning('Sedang menyimpan dokumen, harap tunggu...');

        $('[name=signature]').val(JSON.stringify(signaturePad.toData()));

        $.ajax({
            url: "{{ url('medical_record/e_rekam_medis/asesmen_medis_awal_rawat_jalan_gigi/store') }}",
            data: $('#form_dokumen').serialize(),
            method: 'post',
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                toastr.success(response.message);
                $('#box_ttd').html(
                    `<img src="{{ env('SMIS_UPLOAD_URL') }}/` + (response.employee ? response.employee.ttd : ``) + `" style="height: 2.5cm; width: 5cm;" alt="">` +
                    '<br>' +
                    (response.employee ? response.employee.nama : '')
                );
            }
        })
    })

    $(document).ready(function() {
        $('#signaturepad_gigi').attr('width', window.screen.width * 0.415);
        $('#signaturepad_gigi').attr('height', window.screen.width * 0.22);
        $('#pesan_pemeriksaan').select2();
        <?php if ($data) { ?>
            signaturePad.fromData(<?php echo $data->signature ?>);
        <?php } ?>
    });

    const signaturePad = new SignaturePad(document.getElementById('signaturepad_gigi'), {
        minWidth: 5,
        maxWidth: 10,
        penColor: 'rgb(0, 0, 0)',
        maxWidth: 2
    });

    function hapus_signature() {
        window.event.preventDefault();
        signaturePad.clear();
        $("[name=signature]").val('');
    }

    function undo_signature() {
        window.event.preventDefault();
        var data = signaturePad.toData();
        if (data) {
            data.pop(); // remove the last dot or line
            signaturePad.fromData(data);
        }
    }

    function change_color(color) {
        signaturePad.penColor = color;
    }
</script>
@include('medical_record.e_rekam_medis.dokumen_kunjungan.script.laboratorium')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.script.diagnosa')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.script.resep')
@endpush